/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TriPortIdImpl;
import org.etsi.ttcn.tri.TriPortId;

class EnableXTriMessage
extends AbstractTriTciMessage {
    private TriPortIdImpl m_systemPort;
    private boolean m_bEnable;

    public EnableXTriMessage() {
        this.m_systemPort = new TriPortIdImpl();
    }

    public EnableXTriMessage(TriPortId systemPort, boolean bEnable) {
        this.m_systemPort = systemPort instanceof TriPortIdImpl ? (TriPortIdImpl)systemPort : new TriPortIdImpl(systemPort);
        this.m_bEnable = bEnable;
    }

    @Override
    public boolean isSessionIdRequired() {
        return false;
    }

    public TriPortId getSystemPortId() {
        return this.m_systemPort;
    }

    public boolean enable() {
        return this.m_bEnable;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_systemPort.serialize(ms);
        ms.write(this.m_bEnable ? -1 : 0);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_systemPort.deserialize(ms);
        this.m_bEnable = ms.read() != 0;
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.EnableXTri;
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new EnableXTriMessage();
    }
}

