/*
 * Decompiled with CFR 0.152.
 */
package org.elvior.ttcn.tritci;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.elvior.ttcn.tritci.AbstractTriTciMessage;
import org.elvior.ttcn.tritci.AdapterProcessingResult;
import org.elvior.ttcn.tritci.ETriTciMessageCode;
import org.elvior.ttcn.tritci.TciProvider;
import org.elvior.ttcn.tritci.TciTimerStatus;
import org.elvior.ttcn.tritci.TliTimerMessage;
import org.elvior.ttcn.tritci.TriComponentIdImpl;
import org.elvior.ttcn.tritci.TriStatusImpl;
import org.elvior.ttcn.tritci.TriTimerIdImpl;

class TliTRunningMessage
extends TliTimerMessage {
    private TciTimerStatus m_status;

    public TliTRunningMessage(String am, long ts, String src, int line, TriComponentIdImpl c, TriTimerIdImpl timer, TciTimerStatus status) {
        super(am, ts, src, line, c, timer);
        this.m_status = status;
    }

    public TliTRunningMessage() {
    }

    public TciTimerStatus getStatus() {
        return this.m_status;
    }

    @Override
    public void serialize(ByteArrayOutputStream ms) {
        super.serialize(ms);
        this.m_status.serialize(ms);
    }

    @Override
    protected void deserializeProc(ByteArrayInputStream ms) throws IOException {
        super.deserializeProc(ms);
        this.m_status = new TciTimerStatus();
        this.m_status.deserialize(ms);
    }

    @Override
    public AbstractTriTciMessage createEmptyInstance() {
        return new TliTRunningMessage();
    }

    @Override
    public ETriTciMessageCode getMessageCode() {
        return ETriTciMessageCode.TliTRunning;
    }

    @Override
    public AdapterProcessingResult processInAdapter() {
        if (!this.isSupportedInAdapter()) {
            return new AdapterProcessingResult(TriStatusImpl.error());
        }
        TciProvider.getInstance().getTciTLProvided().tliTRunning(this.getDetails(), this.getTimeStampInSeconds(), this.getFile(), this.getLine(), this.getComponentId(), this.getTimer(), this.getStatus());
        return new AdapterProcessingResult(TriStatusImpl.ok());
    }
}

