<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <hardware>
            <xsl:for-each select="nc:data/hw:hardware/hw:component"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:hw="urn:ietf:params:xml:ns:yang:ietf-hardware">
                <component>
                    <xsl:copy-of select="hw:name" />
                    <xsl:copy-of select="hw:class" />
                    <xsl:copy-of select="hw:physical-index" />
                    <xsl:copy-of select="hw:description" />
                    <xsl:copy-of select="hw:parent" />
                    <xsl:copy-of select="hw:parent-rel-pos" />
                    <!-- contains-child -->
                    <xsl:copy-of select="hw:hardware-rev" />
                    <xsl:copy-of select="hw:firmware-rev" />
                    <xsl:copy-of select="hw:software-rev" />
                    <xsl:copy-of select="hw:serial-num" />
                    <xsl:copy-of select="hw:mfg-name" />
                    <xsl:copy-of select="hw:model-name" />
                    <xsl:copy-of select="hw:alias" />
                    <xsl:copy-of select="hw:asset-id" />
                    <xsl:copy-of select="hw:is-fru" />
                    <xsl:copy-of select="hw:mfg-date" />
                    <!-- uri -->
                    <xsl:copy-of select="hw:uuid" />
                    <!-- state -->
                    <!-- sensor-data -->
                </component>
            </xsl:for-each>
        </hardware>
    </xsl:template>
</xsl:stylesheet>
