<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <interfaces>
            <xsl:for-each select="nc:data/if:interfaces/if:interface"
                        xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
                        xmlns:if="urn:ietf:params:xml:ns:yang:ietf-interfaces"
                        xmlns:mrl="urn:ietf:params:xml:ns:yang:ietf-microwave-radio-link">
                <interface>
                    <xsl:copy-of select="if:name" />
                    <xsl:copy-of select="if:type" />
                    <xsl:copy-of select="mrl:tx-enabled" />
                    <xsl:copy-of select="mrl:tx-frequency" />
                    <xsl:copy-of select="mrl:duplex-distance" />
                    <xsl:copy-of select="mrl:channel-separation" />
                    <!-- get what is inside a child attribute (ex: mrl:maximum-nominal-power is inside mrl:rtpc -->
                    <xsl:copy-of select="mrl:rtpc/mrl:maximum-nominal-power" />
                    <xsl:copy-of select="mrl:single/mrl:selected-cm" />
                    <xsl:copy-of select="mrl:adaptive/mrl:selected-min-acm" />
                    <xsl:copy-of select="mrl:adaptive/mrl:selected-max-acm" />
                </interface>
            </xsl:for-each>
        </interfaces>
    </xsl:template>
</xsl:stylesheet>
