#!/bin/bash
TOSCA_PARSER="Cloudnet-TOSCA-toolbox"
GIT_URL_TOSCA_TOOLBOX="https://github.com/Orange-OpenSource/Cloudnet-TOSCA-toolbox.git"
TOSCA_PARSER_FOLDER="tosca-parser/"

while getopts v: flag
do
        case "${flag}" in
                v) TOSCA_PARSER=${OPTARG};;
        esac
done

if [ ${TOSCA_PARSER} == "Cloudnet-TOSCA-toolbox" ] ; then
	# Parse TOSCA definitions
	echo "Cloudnet-TOSCA-toolbox: Validation starting ..."
	# Cloudnet-TOSCA-toolbox 
    git clone $GIT_URL_TOSCA_TOOLBOX $TOSCA_PARSER_FOLDER
    
	mkdir ${TOSCA_PARSER_FOLDER}examples/mec037
	cp *.yaml -t ${TOSCA_PARSER_FOLDER}examples/mec037
	
	cd ${TOSCA_PARSER_FOLDER}examples/mec037
	
	CLOUDNET_BINDIR=../../bin  
	. ${CLOUDNET_BINDIR}/cloudnet_rc.sh
	
	finalResult=0
	for i in *.yaml ; do
    
		result=0
		echo "Cloudnet-TOSCA-toolbox: Validating file $i..." >> debugCloudnet.log
		../../bin/toscaware/toscaware $i &> debug.log
		#docker ${DOCKER_OPTS} run --user "$(id -u)":"$(id -g)" -v "${PWD}/${TOSCA_PARSER_FOLDER}:/work" -v "${PWD}/${TOSCA_PARSER_FOLDER}/bin/cloudnet:/cloudnet" --workdir="/work" --rm --attach=stdin --attach=stdout --attach=stderr cloudnet/toscaware python ${PYTHON_OPTS} /cloudnet/tosca/tosca2cloudnet.py --template-file "$i" ${TOSCAWARE_OPTS}
		
		#docker ${DOCKER_OPTS} run --user "$(id -u)":"$(id -g)" --rm --attach=stdin --attach=stdout --attach=stderr cloudnet/toscaware python ${PYTHON_OPTS} /cloudnet/tosca/tosca2cloudnet.py --template-file "$1" ${TOSCAWARE_OPTS}
		#./${TOSCA_PARSER_FOLDER}/bin/toscaware/toscaware $i $> debug.log

		if [ $? == 2 ] ; then

			echo "Cloudnet-TOSCA-toolbox: ++++ Issues found with TOSCA file syntax in $i"
			grep "ERROR" < debug.log
			finalResult=1
		else
			echo "Cloudnet-TOSCA-toolbox: ++++ TOSCA parser finished validation of $i"
			#Check the debug messages, if there's at least one ERROR then res=1
			if [ `grep "ERROR" < debug.log | wc -l` == 0 ] ; then
				echo "++++ TOSCA parser finished validation of $i with no errors"
			else
				echo "Cloudnet-TOSCA-toolbox: ++++ TOSCA parser finished validation of $i with errors"
				grep "ERROR" < debug.log
				finalResult=1
			fi
		fi 
		cat debug.log >> debugCloudnet.log
	done
	
	cp debugCloudnet.log ../../../debugCloudnet.log
elif [ ${TOSCA_PARSER} == "Puccini" ] ; then
	finalResult=0
	echo "Puccini: Validation starting ..."
		
	docker run --rm -v "${PWD}:/mec037" puccini ./mec037/scripts/puccini_parse.sh &> debugPuccini.log
		
	if [ $? == 0 ] ; then
		echo "Puccini: ++++ TOSCA parser finished validation with no errors"
	elif  [ $? == 1 ] ; then
		echo "Puccini: ++++ TOSCA parser finished validation with errors"
			#Check the debug messages, if there's at least one ERROR then res=1
			#if [ `grep "PROBLEMS" < debug.log | wc -l` > 0 ] ; then
			#	echo "Puccini: ++++ ERRORS: "
			#	grep "PROBLEMS" < debug.log
			#	res=1
			#fi
			finalResult=1
	fi 
		
fi

exit $finalResult