#!/bin/bash

# Debug mode
#set -e
set -vx

# Usage: sudo ./update_mec_project.bash
# TODO Use git clone in temporary directory

OLDPWD=`pwd`

# Execution path
RUN_PATH="${0%/*}"

if [ "${VALIDATION_DIR}" == "" ]
then
    VALIDATION_DIR=${HOME}
fi

CHOWN_USER_GROUP=${USER}:${USER}
SRC_MEC_PATH=${VALIDATION_DIR}/dev/STF569_Mec

if [ "${PATH_DEV_MEC}" == "" ]
then
    PATH_DEV_MEC=${HOME}/dev/etsi_mec
fi
echo ${PATH_DEV_MEC}

if [ -d ${PATH_DEV_MEC} ]
then
    if [ -f ${HOME}/tmp/mec.tar.bz2 ]
    then
        mv ${HOME}/tmp/mec.tar.bz2 ${VALIDATION_DIR}/tmp/mec.tar.`date +'%Y%m%d'`.bz2
    fi
    find ${PATH_DEV_MEC} -name "*.o" -exec rm {} \;
    tar jchvf ${HOME}/tmp/mec.tar.bz2 ${PATH_DEV_MEC}
    rm -fr ${PATH_DEV_MEC}
fi

# Check if target directory exist
if [ ! -d ${PATH_DEV_MEC} ]
then
    mkdir -p ${PATH_DEV_MEC}/json ${PATH_DEV_MEC}/framework ${PATH_DEV_MEC}/include ${PATH_DEV_MEC}/bin ${PATH_DEV_MEC}/lib ${PATH_DEV_MEC}/objs ${PATH_DEV_MEC}/src ${PATH_DEV_MEC}/docs
fi

# Update JSON files
echo 'Updating JSON files'
JSON_SRC_PATH=${SRC_MEC_PATH}/json
JSON_DST_PATH=${PATH_DEV_MEC}/json
cp ${JSON_SRC_PATH}/*.json ${JSON_DST_PATH}

# Update ETSI Framework files
echo 'Updating ETSI Framework files'
FWK_SRC_PATH=${SRC_MEC_PATH}/ccsrc
FWK_DST_PATH=${PATH_DEV_MEC}/framework
mkdir -p ${FWK_DST_PATH}/src ${FWK_DST_PATH}/include
chmod -R 775 ${FWK_DST_PATH}
# Create link to TITAN Abstract_Socket
ln -sf $TOP/../titan.TestPorts.Common_Components.Abstract_Socket/src/Abstract_Socket.cc ${FWK_DST_PATH}/src/Abstract_Socket.cc
ln -sf $TOP/../titan.TestPorts.Common_Components.Abstract_Socket/src/Abstract_Socket.hh ${FWK_DST_PATH}/include/Abstract_Socket.hh
FWK_DIR_LIST_HH=`find ${FWK_SRC_PATH}/Protocols/ -name "*.h*" -type f`
FWK_DIR_LIST_THH=`find ${FWK_SRC_PATH}/Protocols/ -name "*.t.h*" -type f`
FWK_DIR_LIST_CC=`find ${FWK_SRC_PATH}/Protocols/ -name "*.c*" -type f`
FWK_DIR_LIST_L=`find ${FWK_SRC_PATH}/Protocols/ -name "*.l" -type f`
FWK_DIR_LIST_Y=`find ${FWK_SRC_PATH}/Protocols/ -name "*.y" -type f`
for i in ${FWK_DIR_LIST_HH}
do
    cp $i ${FWK_DST_PATH}/include
done
for i in ${FWK_DIR_LIST_THH}
do
    cp $i ${FWK_DST_PATH}/include
done
for i in ${FWK_DIR_LIST_CC}
do
    cp $i ${FWK_DST_PATH}/src
done
if [ "${FWK_DIR_LIST_L}" != "" ]
then
    for i in ${FWK_DIR_LIST_L}
    do
        cp $i ${FWK_DST_PATH}/src
    done
fi
if [ "${FWK_DIR_LIST_Y}" != "" ]
then
    for i in ${FWK_DIR_LIST_Y}
    do
        cp $i ${FWK_DST_PATH}/src
    done
fi
FWK_DIR_LIST_HH=`find ${FWK_SRC_PATH}/Framework/ -name "*.h*" -type f`
FWK_DIR_LIST_CC=`find ${FWK_SRC_PATH}/Framework/ -name "*.c*" -type f`
for i in ${FWK_DIR_LIST_HH}
do
    cp $i ${FWK_DST_PATH}/include
done
for i in ${FWK_DIR_LIST_CC}
do
    cp $i ${FWK_DST_PATH}/src
done

# Update ATS TTCN-3 files
echo 'Update TTCN-3 files'
TTCN_3_ORG_PATH=${SRC_MEC_PATH}/ttcn
TTCN_3_DST_PATH=${PATH_DEV_MEC}/src
CC_SRC_PATH=${SRC_MEC_PATH}/ccsrc
TTCN_3_ATS_LIST='AtsMec'
for i in ${TTCN_3_ATS_LIST}
do
    if [ ! -d ${TTCN_3_DST_PATH}/$i ]
    then
        mkdir -p ${TTCN_3_DST_PATH}/$i/bin ${TTCN_3_DST_PATH}/$i/lib ${TTCN_3_DST_PATH}/$i/src ${TTCN_3_DST_PATH}/$i/include ${TTCN_3_DST_PATH}/$i/ttcn ${TTCN_3_DST_PATH}/$i/objs ${TTCN_3_DST_PATH}/$i/etc ${TTCN_3_DST_PATH}/$i/docs
        chmod -R 775 ${TTCN_3_DST_PATH}/$i
    fi
    cp ${TTCN_3_ORG_PATH}/$i/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
    cp ${TTCN_3_ORG_PATH}/../etc/$i/*.cfg ${TTCN_3_DST_PATH}/$i/etc
    if [ -d ${TTCN_3_ORG_PATH}/../etc_simu ]
    then
        mkdir -p ${TTCN_3_ORG_PATH}/../etc_simu
        cp ${TTCN_3_ORG_PATH}/../etc_simu/$i/*.cfg ${TTCN_3_DST_PATH}/$i/etc_simu
    fi
    cp ${TTCN_3_ORG_PATH}/../docs/$i/o2.cfg ${TTCN_3_DST_PATH}/$i/docs
done

# Update libraries & CC files
TTCN_3_LIB_LIST='LibMec LibMec/LocationAPI LibMec/UEidentityAPI LibMec/RnisAPI LibMec/BwManagementAPI LibMec/Ams LibMec/AppEna LibMec/AppLCM LibMec/Grant LibMec/FixedAccessInformationAPI LibMec/MeoPkgm LibMec/MepmPkgm LibMec/UEAppInterfaceAPI LibMec/UEidentityAPI LibHttp LibCommon'
for i in ${TTCN_3_LIB_LIST}
do
    if [ ! -d ${TTCN_3_DST_PATH}/$i ]
    then
        mkdir -p ${TTCN_3_DST_PATH}/$i/docs ${TTCN_3_DST_PATH}/$i/src ${TTCN_3_DST_PATH}/$i/include ${TTCN_3_DST_PATH}/$i/ttcn ${TTCN_3_DST_PATH}/$i/json
    fi
    cp ${TTCN_3_ORG_PATH}/$i/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
    # Update files
    if [ "$i" == "LibMec" ]
    then
        cp ${TTCN_3_ORG_PATH}/$i/ttcn/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
        cp ${TTCN_3_ORG_PATH}/$i/json/*.json ${TTCN_3_DST_PATH}/$i/json
        cp ${CC_SRC_PATH}/externals/*_ExternalFunctions.cc ${TTCN_3_DST_PATH}/$i/src
    elif [ "$i" == "LibHttp" ]
    then
        cp ${TTCN_3_ORG_PATH}/LibIts/ttcn/Http/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
        cp ${CC_SRC_PATH}/EncDec/$i/*_Encdec.cc ${TTCN_3_DST_PATH}/$i/src
        cp ${CC_SRC_PATH}/Ports/$i/*.hh ${TTCN_3_DST_PATH}/$i/include
        cp ${CC_SRC_PATH}/Ports/$i/*.cc ${TTCN_3_DST_PATH}/$i/src
        cp ${CC_SRC_PATH}/include/$i/*.hh ${TTCN_3_DST_PATH}/$i/include
        cp ${CC_SRC_PATH}/src/$i/*.cc ${TTCN_3_DST_PATH}/$i/src
        # Patch due to svn/gitlab moving
        cp ${SRC_MEC_PATH}/ttcn/patch_lib_http/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
    elif [ "$i" == "LibCommon" ]
    then
        cp ${TTCN_3_ORG_PATH}/$i/ttcn/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
        # Patch TITAN due to TTCN-3 compiler issues
        cp ${SRC_MEC_PATH}/ttcn/patch_lib_common_titan/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
    else
        cp ${TTCN_3_ORG_PATH}/$i/ttcn/*.ttcn ${TTCN_3_DST_PATH}/$i/ttcn
        cp ${TTCN_3_ORG_PATH}/$i/json/*.json ${TTCN_3_DST_PATH}/$i/json
    fi
done
#######################################################################################
# Remove AtsMec_FixedAccessInformationAPI_TestCases, not supported yet
rm ${TTCN_3_DST_PATH}/AtsMec/ttcn/AtsMec_FixedAccessInfoAPI_TestCases.ttcn
#######################################################################################

# Apply patches
PATH_PATCHES=`pwd`
if [ -d ${PATH_PATCHES} ]
then
    # Update Mec
    cp ${PATH_PATCHES}/mec_generate_makefile.bash ${PATH_DEV_MEC}/src/AtsMec/bin
    cp ${PATH_PATCHES}/run_mtc.bash ${PATH_DEV_MEC}/src/AtsMec/bin
    cp ${PATH_PATCHES}/run_ptcs.bash ${PATH_DEV_MEC}/src/AtsMec/bin
    cp ${PATH_PATCHES}/run_all.bash ${PATH_DEV_MEC}/src/AtsMec/bin
    cp ${PATH_PATCHES}/run_*_simu.bash ${PATH_DEV_MEC}/src/AtsMec/bin
fi

# Set rights
find ${PATH_DEV_MEC} -type f -exec chmod 664 {} \;
find ${PATH_DEV_MEC} -name "*.bash" -type f -exec chmod 775 {} \;
find ${PATH_DEV_MEC} -type d -exec chmod 775 {} \;
chown -R ${CHOWN_USER_GROUP} ${PATH_DEV_MEC}

cd ${OLDPWD}

exit 0
