#!/bin/bash

ECLIPSE_URL='https://www.eclipse.org/downloads/download.php?file=/technology/epp/downloads/release/2020-06/R/eclipse-jee-2020-06-R-linux-gtk-x86_64.tar.gz&r=1'
TITAN_URL='https://www.eclipse.org/downloads/download.php?file=/titan/TITAN_Designer_and_Executor_Plugin_7.1.0.zip&r=1'

#set -e
set -vx

echo -e "*****************************\n* Install eclipse\n*****************************\n"

mkdir -p ${HOME}/frameworks
cd ${HOME}/frameworks || exit 1
wget --progress=dot:mega 'http://www.mirrorservice.org/sites/download.eclipse.org/eclipseMirror/technology/epp/downloads/release/2020-06/R/eclipse-cpp-2020-06-R-linux-gtk-x86_64.tar.gz' -Oeclipse-cpp-2020-06-R-linux-gtk-x86_64.tar.gz || exit 1
tar -zxvf ./eclipse-cpp-2020-06-R-linux-gtk-x86_64.tar.gz || exit 1
ln -sf ${HOME}/frameworks/eclipse/eclipse ${HOME}/bin/eclipse
rm -f ./eclipse-cpp-2020-06-R-linux-gtk-x86_64.tar.gz

if wget --progress=dot:mega 'https://mirrors.dotsrc.org/eclipse//titan/TITAN_Designer_and_Executor_Plugin_7.1.0.zip' -OTITAN_Designer_and_Executor_plugin.zip; then
  eclipse/eclipse -noSplash -application org.eclipse.equinox.p2.director \
    -destination /home/etsi/frameworks/eclipse \
    -repository 'jar:file:///home/etsi/frameworks/TITAN_Designer_and_Executor_plugin.zip!/' \
    -installIU TITAN_Designer.feature.group,TITAN_Executor.feature.group,TITAN_Log_Viewer.feature.group,Titan_external_dependencies.feature.group,Titanium.feature.group,Titanium_external_dependencies.feature.group
  rm -f TITAN_Designer_and_Executor_plugin.zip
fi

cd ${HOME}
