#!/bin/bash
# Copyright ETSI 2018-2021
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt

set -e
set -vx

if [ "$1" == "--force-stfubuntu"]
then
    doker rmi `docker images -q stfubuntu`
fi
# Check and build stfubuntu image
if [ -z `docker images -q stfubuntu` ]; then
    docker build --no-cache --tag stfubuntu:18.04 -f Dockerfile.stfubuntu --force-rm  . || exit 1
fi

docker build --no-cache --tag ttf_t012_mec --force-rm  . || ( echo "Docker build failed: $?"; exit 1 )

docker images
docker inspect ttf_t012_mec:latest || ( echo "Docker inspect failed: $?"; exit 1 )

# That's all Floks
exit 0
