#include "LibMec_Functions.hh"
#include <math.h>

#include "base_time.hh"
#include "loggers.hh"

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif
#define earthRadius 6378137.0L
#define rbis = ((double)(earthRadius * M_PI / 180))

namespace LibMec__Functions {

  /**
   * @desc    This external function gets the current time
   * @return  Timestamp - current time since 01/01/2004 in milliseconds
   * @see     fx_getCurrentTime() return TimestampIts
   */
  INTEGER fx__getCurrentTime(
) {
    INTEGER i;
    i.set_long_long_val(base_time::get_instance().get_its_current_time_ms());
    loggers::get_instance().log_msg("<<< fx__getCurrentTime: ", i);
    return i;
  }
  /**
   * @desc    This external function gets the current time since 01/01/1970 in UTC format
   * @return  The current time since 01/01/1970 in UTC format
   * @see     fx_getCurrentTimeUtc() return UInt64
   */
  INTEGER fx__get__current__time__utc() {
    INTEGER i;
    i.set_long_long_val(base_time::get_instance().get_current_time_ms());
    return i;
  }

} // end of Namespace
