/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.common.base.Objects;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.ControlStatement;
import de.ugoe.cs.swe.tTCN3.ControlStatementOrDefList;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionInstance;
import de.ugoe.cs.swe.tTCN3.FunctionRef;
import de.ugoe.cs.swe.tTCN3.FunctionStatement;
import de.ugoe.cs.swe.tTCN3.FunctionStatementList;
import de.ugoe.cs.swe.tTCN3.LogStatement;
import de.ugoe.cs.swe.tTCN3.PredefinedValue;
import de.ugoe.cs.swe.tTCN3.SetLocalVerdict;
import de.ugoe.cs.swe.tTCN3.SingleExpression;
import de.ugoe.cs.swe.tTCN3.TTCN3Reference;
import de.ugoe.cs.swe.tTCN3.TestcaseDef;
import de.ugoe.cs.swe.tTCN3.Value;
import de.ugoe.cs.swe.tTCN3.VerdictTypeValue;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class LogValidator
extends AbstractDeclarativeValidator {
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();

    @Check
    public void checkLogStatementFormat(FunctionStatementList functionStmList) {
        boolean _notEquals;
        boolean _not;
        boolean _isCheckLogStatementFormat = this.activeProfile.isCheckLogStatementFormat();
        boolean bl = _not = !_isCheckLogStatementFormat;
        if (_not) {
            return;
        }
        TestcaseDef parentTC = TTCN3ScopeHelper.findDesiredParent(functionStmList, TestcaseDef.class);
        FunctionDef parentFunc = TTCN3ScopeHelper.findDesiredParent(functionStmList, FunctionDef.class);
        AltstepDef parentAlt = TTCN3ScopeHelper.findDesiredParent(functionStmList, AltstepDef.class);
        TTCN3Reference parent = null;
        boolean bl2 = _notEquals = !Objects.equal((Object)parentTC, null);
        if (_notEquals) {
            parent = parentTC;
        } else {
            boolean _notEquals_1;
            boolean bl3 = _notEquals_1 = !Objects.equal((Object)parentFunc, null);
            if (_notEquals_1) {
                parent = parentFunc;
            } else {
                boolean _notEquals_2;
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)parentAlt, null);
                if (_notEquals_2) {
                    parent = parentAlt;
                }
            }
        }
        this.checkStatementList((EList<EObject>)functionStmList.eContents(), parent);
    }

    @Check
    public void checkLogStatementFormat(ControlStatementOrDefList ctrlStmList) {
        boolean _not;
        boolean _isCheckLogStatementFormat = this.activeProfile.isCheckLogStatementFormat();
        boolean bl = _not = !_isCheckLogStatementFormat;
        if (_not) {
            return;
        }
        this.checkStatementList((EList<EObject>)ctrlStmList.eContents(), null);
    }

    private void checkStatementList(EList<EObject> statements, TTCN3Reference parent) {
        boolean _notEquals;
        ICompositeNode node = null;
        String statementToCheck = null;
        boolean other = false;
        LogStatement log = null;
        for (EObject s : statements) {
            boolean _notEquals2;
            if (s instanceof FunctionStatement) {
                log = this.findLogStatement((FunctionStatement)s);
            } else if (s instanceof ControlStatement) {
                log = this.findLogStatement((ControlStatement)s);
            }
            boolean bl = _notEquals2 = !Objects.equal((Object)log, null);
            if (_notEquals2) {
                boolean _not;
                if (other) {
                    boolean _notEquals_1;
                    boolean bl2 = _notEquals_1 = !Objects.equal(statementToCheck, null);
                    if (_notEquals_1) {
                        this.checkLogStatementFormat(statementToCheck, (INode)node, parent);
                    }
                    other = false;
                    statementToCheck = null;
                }
                node = NodeModelUtils.getNode((EObject)log);
                boolean _equals = Objects.equal(statementToCheck, null);
                if (_equals) {
                    statementToCheck = "";
                }
                String _statementToCheck = statementToCheck;
                String _concatLogItems = this.concatLogItems(log);
                statementToCheck = String.valueOf(_statementToCheck) + _concatLogItems;
                boolean _isProcessSubsequentLogStatementsAsOne = this.activeProfile.isProcessSubsequentLogStatementsAsOne();
                boolean bl3 = _not = !_isProcessSubsequentLogStatementsAsOne;
                if (!_not) continue;
                this.checkLogStatementFormat(statementToCheck, (INode)node, parent);
                statementToCheck = null;
                continue;
            }
            other = true;
        }
        boolean bl = _notEquals = !Objects.equal(statementToCheck, null);
        if (_notEquals) {
            this.checkLogStatementFormat(statementToCheck, (INode)node, parent);
        }
    }

    private LogStatement findLogStatement(ControlStatement control) {
        if (!Objects.equal((Object)control.getBasic(), null) && !Objects.equal((Object)control.getBasic().getLog(), null)) {
            return control.getBasic().getLog();
        }
        return null;
    }

    private LogStatement findLogStatement(FunctionStatement stm) {
        if (!Objects.equal((Object)stm.getBasic(), null) && !Objects.equal((Object)stm.getBasic().getLog(), null)) {
            return stm.getBasic().getLog();
        }
        return null;
    }

    private String concatLogItems(LogStatement log) {
        String logString = "";
        List items = EcoreUtil2.getAllContentsOfType((EObject)log, PredefinedValue.class);
        for (PredefinedValue i : items) {
            boolean _notEquals;
            String _charString = i.getCharString();
            boolean bl = _notEquals = !Objects.equal((Object)_charString, null);
            if (!_notEquals) continue;
            String _string = i.getCharString().toString();
            int _length = i.getCharString().toString().length();
            int _minus = _length - 1;
            CharSequence _subSequence = _string.subSequence(1, _minus);
            String subString = (String)_subSequence;
            String _logString = logString;
            String _replaceAll = subString.replaceAll("\"\"", "\"");
            logString = String.valueOf(_logString) + _replaceAll;
        }
        return logString;
    }

    private void checkLogStatementFormat(String log, INode node, TTCN3Reference parent) {
        boolean _not;
        boolean problemOccured = false;
        String warning = "";
        Pattern logPattern = Pattern.compile(this.activeProfile.getLogFormatRegExp(), 32);
        Matcher logMatcher = logPattern.matcher(log);
        boolean _matches = logMatcher.matches();
        boolean bl = _not = !_matches;
        if (_not) {
            problemOccured = true;
            warning = "Invalid log format (\"" + log + "\")!";
        } else if (!logMatcher.group(1).equals("") && !Objects.equal((Object)parent, null)) {
            boolean _not_1;
            String logItemContainerIdentifier = logMatcher.group(1);
            boolean _equals = parent.getName().equals(logItemContainerIdentifier);
            boolean bl2 = _not_1 = !_equals;
            if (_not_1) {
                String _plus_1;
                problemOccured = true;
                String _name = parent.getName();
                String _plus = "Log statement contains invalid container identifier (\"" + logItemContainerIdentifier + "\", should be \"" + _name;
                warning = _plus_1 = String.valueOf(_plus) + "\")!";
            }
        }
        if (problemOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            this.warning(warning, null, LoggingInterface.MessageClass.LOGGING.toString(), new String[]{Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "5.1, checkLogFormat"});
        }
    }

    @Check
    public void checkExternalFunctionInvocationPrecededByLogStatement(FunctionInstance function) {
        FunctionRef _ref;
        boolean _not;
        boolean _isCheckExternalFunctionInvocationPrecededByLogStatement = this.activeProfile.isCheckExternalFunctionInvocationPrecededByLogStatement();
        boolean bl = _not = !_isCheckExternalFunctionInvocationPrecededByLogStatement;
        if (_not) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)function);
        boolean problemsOccured = false;
        String _name = function.getRef().getName();
        boolean _equals = Objects.equal((Object)_name, null);
        if (_equals) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            ICompositeNode functionNode = NodeModelUtils.getNode((EObject)function);
            String _trim = functionNode.getText().trim();
            String _plus = "Function definition for \"" + _trim;
            String message = String.valueOf(_plus) + "\" cannot be resolved! It cannot be determined if it is an external function call!";
            String _string = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_1 = Integer.valueOf(functionNode.getStartLine()).toString();
            String _string_2 = Integer.valueOf(functionNode.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus_1 = "5.3, " + _methodName;
            this.info(message, null, _string, new String[]{_string_1, _string_2, _plus_1, LoggingInterface.LogLevel.INFORMATION.toString()});
        }
        if ((_ref = function.getRef()) instanceof ExtFunctionDef) {
            FunctionStatement parent = TTCN3ScopeHelper.findDesiredParent(function, FunctionStatement.class);
            FunctionStatementList parentList = TTCN3ScopeHelper.findDesiredParent(function, FunctionStatementList.class);
            boolean _equals_1 = Objects.equal((Object)parent, null);
            if (_equals_1) {
                TTCN3StatisticsProvider.getInstance().incrementCountLog();
                String _name_1 = function.getRef().getName();
                String _plus_2 = "Call to external function \"" + _name_1;
                String message_1 = String.valueOf(_plus_2) + "\" within a definition on the module level. It cannot be preceded by a log statement!";
                String _string_3 = LoggingInterface.MessageClass.LOGGING.toString();
                String _string_4 = Integer.valueOf(node.getStartLine()).toString();
                String _string_5 = Integer.valueOf(node.getEndLine()).toString();
                String _methodName_1 = MiscTools.getMethodName();
                String _plus_3 = "5.3, " + _methodName_1;
                this.info(message_1, null, _string_3, new String[]{_string_4, _string_5, _plus_3, LoggingInterface.LogLevel.INFORMATION.toString()});
            } else {
                EList items = parentList.eContents();
                int idx = items.indexOf((Object)parent);
                if (idx > 0 && idx < items.size()) {
                    EObject _get = (EObject)items.get(idx - 1);
                    LogStatement log = this.findLogStatement((FunctionStatement)_get);
                    boolean _equals_2 = Objects.equal((Object)log, null);
                    if (_equals_2) {
                        problemsOccured = true;
                    }
                } else {
                    problemsOccured = true;
                }
            }
        }
        if (problemsOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            String _name_2 = function.getRef().getName();
            String _plus_4 = "Call to external function \"" + _name_2;
            String message_2 = String.valueOf(_plus_4) + "\" not preceded by a log statement!";
            String _string_6 = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_7 = Integer.valueOf(node.getStartLine()).toString();
            String _string_8 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName_2 = MiscTools.getMethodName();
            String _plus_5 = "5.3, " + _methodName_2;
            this.warning(message_2, null, _string_6, new String[]{_string_7, _string_8, _plus_5});
        }
    }

    @Check
    public void checkInconcOrFailSetverdictPrecededByLog(SetLocalVerdict verdict) {
        boolean _not;
        boolean _isCheckInconcOrFailSetVerdictPrecededByLog = this.activeProfile.isCheckInconcOrFailSetVerdictPrecededByLog();
        boolean bl = _not = !_isCheckInconcOrFailSetVerdictPrecededByLog;
        if (_not) {
            return;
        }
        FunctionStatement parent = TTCN3ScopeHelper.findDesiredParent(verdict, FunctionStatement.class);
        FunctionStatementList parentList = TTCN3ScopeHelper.findDesiredParent(verdict, FunctionStatementList.class);
        ICompositeNode node = NodeModelUtils.getNode((EObject)verdict);
        boolean problemsOccured = false;
        SingleExpression exp = verdict.getExpression();
        boolean isInconcOrFail = false;
        if (exp instanceof Value && !Objects.equal((Object)((Value)exp).getPredef(), null) && !Objects.equal((Object)((Object)((Value)exp).getPredef().getVerdictType()), null) && (Objects.equal((Object)((Object)((Value)exp).getPredef().getVerdictType()), (Object)((Object)VerdictTypeValue.INCONC)) || Objects.equal((Object)((Object)((Value)exp).getPredef().getVerdictType()), (Object)((Object)VerdictTypeValue.FAIL)))) {
            isInconcOrFail = true;
        }
        if (!isInconcOrFail) {
            return;
        }
        EList items = parentList.eContents();
        int idx = items.indexOf((Object)parent);
        if (idx > 0 && idx < items.size()) {
            EObject _get = (EObject)items.get(idx - 1);
            LogStatement log = this.findLogStatement((FunctionStatement)_get);
            boolean _equals = Objects.equal((Object)log, null);
            if (_equals) {
                problemsOccured = true;
            }
        } else {
            problemsOccured = true;
        }
        if (problemsOccured) {
            TTCN3StatisticsProvider.getInstance().incrementCountLog();
            String message = "No log statement precedes a fail or inconc setverdict statement!!";
            String _string = LoggingInterface.MessageClass.LOGGING.toString();
            String _string_1 = Integer.valueOf(node.getStartLine()).toString();
            String _string_2 = Integer.valueOf(node.getEndLine()).toString();
            String _methodName = MiscTools.getMethodName();
            String _plus = "5.4, " + _methodName;
            this.warning("No log statement precedes a fail or inconc setverdict statement!!", null, _string, new String[]{_string_1, _string_2, _plus});
        }
    }

    public void register(EValidatorRegistrar registrar) {
    }
}

