/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import de.ugoe.cs.swe.common.CommonHelper;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.PreAnalyzer;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.ImportData;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.MultimapBasedScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;

public class TTCN3GlobalScopeProvider
extends AbstractGlobalScopeProvider {
    public static final Map<Resource, IScope> STATIC_SCOPE = Collections.synchronizedMap(Maps.newHashMap());
    public static final SetMultimap<Resource, Resource> IMPORTED_RESOURCES = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static final SetMultimap<Resource, ImportData> IMPORTS = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static final Multimap<TTCN3Module, TTCN3Module> IMPORTED_FROM = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static final SetMultimap<Resource, IEObjectDescription> EXPORTED_OBJECTS = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static final List<Resource> RESOURCES = Collections.synchronizedList(Lists.newArrayList());
    public static final Map<String, TTCN3Module> NAMED_MODULES = Collections.synchronizedMap(Maps.newHashMap());
    public static final Map<String, List<String[]>> FOUND_TABS = Collections.synchronizedMap(Maps.newHashMap());
    public static boolean LIVE = true;
    @Inject
    IResourceDescriptionsProvider rdp;
    @Inject
    XtextResourceSet resourceSet;

    public IScope getScope(Resource resource, EReference reference, Predicate<IEObjectDescription> filter) {
        return this.getScope(resource, reference);
    }

    public IScope getScope(Resource resource, EReference reference) {
        return this.getImportedScope(resource, reference);
    }

    protected IScope getImportedScope(Resource resource) {
        return this.getImportedScope(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IScope getImportedScope(Resource resource, EReference reference) {
        if (TTCN3StatisticsProvider.getInstance().isPreAnalyzingCompleted() && STATIC_SCOPE.containsKey(resource)) {
            return STATIC_SCOPE.get(resource);
        }
        if (TTCN3StatisticsProvider.getInstance().isPreAnalyzingCompleted()) {
            IScope scope = IScope.NULLSCOPE;
            ArrayList objects = Lists.newArrayList();
            for (ImportData importData : IMPORTS.get((Object)resource)) {
                objects.addAll(importData.getExportedObjects());
            }
            if (reference == null) {
                return scope;
            }
            Map<Resource, IScope> map = STATIC_SCOPE;
            synchronized (map) {
                scope = MultimapBasedScope.createScope((IScope)IScope.NULLSCOPE, (Iterable)objects, (boolean)this.isIgnoreCase(reference));
                if (TTCN3StatisticsProvider.getInstance().isParsingCompleted()) {
                    STATIC_SCOPE.put(resource, scope);
                }
            }
            if (LIVE) {
                TTCN3StatisticsProvider.getInstance().setPreAnalyzingCompleted(false);
            }
            return scope;
        }
        if (LIVE) {
            this.reset(resource);
            return this.getImportedScope(resource, reference);
        }
        return IScope.NULLSCOPE;
    }

    public static void printImportedModuleNames(boolean fileNames, LoggingInterface logger) {
        for (String moduleName : NAMED_MODULES.keySet()) {
            TTCN3Module module = NAMED_MODULES.get(moduleName);
            ICompositeNode node = NodeModelUtils.getNode((EObject)module);
            String importList = "";
            int index = 0;
            List imports = EcoreUtil2.getAllContentsOfType((EObject)module, ImportDef.class);
            int size = imports.size();
            for (ImportDef importDef : imports) {
                ++index;
                TTCN3Module importModule = NAMED_MODULES.get(importDef.getName());
                if (importModule != null) {
                    if (fileNames) {
                        importList = String.valueOf(importList) + importDef.getName() + " located in " + importModule.eResource().getURI().devicePath() + (index < size ? ", " : "");
                        continue;
                    }
                    importList = String.valueOf(importList) + importDef.getName() + (index < size ? ", " : "");
                    continue;
                }
                importList = String.valueOf(importList) + "(<" + importDef.getName() + "> is unresolved!)" + (index < size ? ", " : "");
                TTCN3GlobalScopeProvider.printModuleNotResolvedMessage(module.eResource().getURI(), (INode)node, importDef.getName(), logger);
            }
            String message = "Importing from module(s) \"" + importList + "\"";
            logger.logInformation(module.eResource().getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.GENERAL, message, "1.18, " + MiscTools.getMethodName());
        }
    }

    public static void printImportingModuleNames(boolean fileNames, LoggingInterface logger) {
        for (TTCN3Module importedFrom : IMPORTED_FROM.keySet()) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)importedFrom);
            String importList = "";
            int index = 0;
            Collection modules = IMPORTED_FROM.get((Object)importedFrom);
            int size = modules.size();
            for (TTCN3Module module : modules) {
                importList = fileNames ? String.valueOf(importList) + module.getName() + " located in " + module.eResource().getURI().devicePath() + (index < size ? ", " : "") : String.valueOf(importList) + module.getName() + (++index < size ? ", " : "");
                String message = "Module \"" + module.getName() + "\" is imported in module(s) \"" + importList + "\"";
                logger.logInformation(module.eResource().getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.GENERAL, message, "1.18, " + MiscTools.getMethodName());
            }
        }
    }

    private static void printModuleNotResolvedMessage(URI uri, INode node, String name, LoggingInterface logger) {
        logger.logInformation(uri, node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.GENERAL, "Imported module \"" + name + "\" cannot be resolved!", "1.18, " + MiscTools.getMethodName());
    }

    public void reset(Resource resource) {
        Resource r;
        RESOURCES.clear();
        NAMED_MODULES.clear();
        EXPORTED_OBJECTS.clear();
        IMPORTS.clear();
        IMPORTED_FROM.clear();
        IMPORTED_RESOURCES.clear();
        STATIC_SCOPE.clear();
        for (IResourceDescription d : this.rdp.getResourceDescriptions((ResourceSet)this.resourceSet).getAllResourceDescriptions()) {
            TTCN3Module module;
            if (!d.getURI().lastSegment().endsWith("ttcn3") && !d.getURI().lastSegment().endsWith("ttcn") || (module = CommonHelper.getModule(r = resource.getResourceSet().getResource(d.getURI(), true))) == null || NAMED_MODULES.containsKey(module.getName())) continue;
            RESOURCES.add(r);
            NAMED_MODULES.put(module.getName(), module);
        }
        for (IResourceDescription d : this.rdp.getResourceDescriptions((ResourceSet)this.resourceSet).getAllResourceDescriptions()) {
            if (!d.getURI().lastSegment().endsWith("ttcn3") && !d.getURI().lastSegment().endsWith("ttcn")) continue;
            r = resource.getResourceSet().getResource(d.getURI(), true);
            TTCN3GlobalScopeProvider.initExportedObjects(r);
        }
        int i = 0;
        while (i < RESOURCES.size()) {
            PreAnalyzer p = new PreAnalyzer(RESOURCES.get(i));
            try {
                p.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        TTCN3StatisticsProvider.getInstance().setPreAnalyzingCompleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initExportedObjects(Resource resource) {
        ArrayList objects = Lists.newArrayList();
        ArrayList exports = Lists.newArrayList((Iterable)TTCN3GlobalScopeProvider.internalGetAllDescriptions(resource).getExportedObjects());
        int size = exports.size();
        int i = 0;
        while (i < size) {
            IEObjectDescription e = (IEObjectDescription)exports.get(i);
            IEObjectDescription d = null;
            if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getTTCN3Module(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getGroupDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getEnumDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getEnumeration(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getComponentDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getPortDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getRecordDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSetDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSubTypeDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getUnionDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getRecordOfDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSetOfDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSignatureDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getBaseTemplate(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getFunctionRef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getAltstepDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getTestcaseDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSingleConstDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getModuleParameter(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            }
            ++i;
        }
        SetMultimap<Resource, IEObjectDescription> setMultimap = EXPORTED_OBJECTS;
        synchronized (setMultimap) {
            EXPORTED_OBJECTS.putAll((Object)resource, (Iterable)objects);
        }
    }

    private static ISelectable internalGetAllDescriptions(final Resource resource) {
        Iterable<EObject> allContents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            }
        };
        Iterable allDescriptions = Scopes.scopedElementsFor((Iterable)allContents);
        return new MultimapBasedSelectable(allDescriptions);
    }
}

