/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import com.google.inject.Injector;
import de.ugoe.cs.swe.T3Q.Analyzer;
import de.ugoe.cs.swe.T3Q.DependencyAnalyzer;
import de.ugoe.cs.swe.T3Q.FileParser;
import de.ugoe.cs.swe.T3Q.TTCN3Dependency;
import de.ugoe.cs.swe.T3Q.TTCN3Output;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.TTCN3StandaloneSetup;
import de.ugoe.cs.swe.common.CommonHelper;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.PreAnalyzer;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class TTCN3ResourceProvider {
    private ArrayList<String> paths;
    private LoggingInterface logger;
    private QualityCheckProfile activeProfile;
    private final int cores = Runtime.getRuntime().availableProcessors();
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();

    public TTCN3ResourceProvider(ArrayList<String> paths, LoggingInterface logger, QualityCheckProfile activeProfile) {
        this.paths = paths;
        this.logger = logger;
        this.activeProfile = activeProfile;
    }

    public void loadResources() {
        Injector injector = new TTCN3StandaloneSetup().createInjectorAndDoEMFRegistration();
        injector.injectMembers((Object)this);
        this.stopwatch.start();
        ExecutorService pool = Executors.newFixedThreadPool(this.cores);
        ArrayList<FileParser> parser = new ArrayList<FileParser>();
        for (String path : this.paths) {
            File file = new File(path);
            if (file.isFile()) {
                parser.add(new FileParser(file, this.qualifiedNameProvider, this.logger));
                continue;
            }
            if (!file.isDirectory()) continue;
            Collection files = FileUtils.listFiles((File)file, (IOFileFilter)new RegexFileFilter("^.*ttcn3$|^.*ttcn$|^.*3mp$"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File f : files) {
                parser.add(new FileParser(f, this.qualifiedNameProvider, this.logger));
            }
        }
        try {
            List list = pool.invokeAll(parser);
            for (Future f : list) {
                Resource r = (Resource)f.get();
                TTCN3GlobalScopeProvider.RESOURCES.add(r);
                TTCN3Module module = CommonHelper.getModule(r);
                TTCN3GlobalScopeProvider.NAMED_MODULES.put(module.getName(), module);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        ArrayList<PreAnalyzer> preAnalyzer = new ArrayList<PreAnalyzer>();
        int i = 0;
        while (i < TTCN3GlobalScopeProvider.RESOURCES.size()) {
            preAnalyzer.add(new PreAnalyzer(TTCN3GlobalScopeProvider.RESOURCES.get(i)));
            ++i;
        }
        try {
            pool.invokeAll(preAnalyzer);
            pool.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TTCN3StatisticsProvider.getInstance().setPreAnalyzingCompleted(true);
        this.stopwatch.stop();
        TTCN3StatisticsProvider.getInstance().setParsingCompleted(true);
        System.out.println("Test suite parsed in " + MiscTools.msToString(this.stopwatch.elapsed(TimeUnit.MILLISECONDS)) + " minutes." + '\n');
    }

    public void analyzeResources() {
        Stopwatch watchAnalyzing = Stopwatch.createStarted();
        ExecutorService pool = Executors.newFixedThreadPool(this.cores);
        Pattern pattern = Pattern.compile(this.activeProfile.getIgnoredResourceRegExp());
        Matcher matcher = null;
        ArrayList<Analyzer> analyzer = new ArrayList<Analyzer>();
        int i = 0;
        while (i < TTCN3GlobalScopeProvider.RESOURCES.size()) {
            Resource resource = TTCN3GlobalScopeProvider.RESOURCES.get(i);
            matcher = pattern.matcher(resource.getURI().toFileString());
            if (!matcher.matches()) {
                analyzer.add(new Analyzer(TTCN3GlobalScopeProvider.RESOURCES.get(i), this.logger));
            }
            ++i;
        }
        try {
            List output = pool.invokeAll(analyzer);
            pool.shutdown();
            System.out.print('\n');
            for (Future f : output) {
                TTCN3Output o = (TTCN3Output)f.get();
                System.out.println("Validation output of " + o.getResource().getURI().lastSegment());
                for (FeatureBasedDiagnostic d : o.getOutput()) {
                    this.printOutput(o.getResource(), d);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.activeProfile.isFeatureListImportedModuleNames()) {
            TTCN3GlobalScopeProvider.printImportedModuleNames(false, this.logger);
        }
        if (this.activeProfile.isFeatureListImportedModuleFileNames()) {
            TTCN3GlobalScopeProvider.printImportedModuleNames(true, this.logger);
        }
        if (this.activeProfile.isFeatureListImportingModuleNames()) {
            TTCN3GlobalScopeProvider.printImportingModuleNames(false, this.logger);
        }
        if (this.activeProfile.isFeatureListImportingModuleFileNames()) {
            TTCN3GlobalScopeProvider.printImportingModuleNames(true, this.logger);
        }
        watchAnalyzing.stop();
        System.out.println("Test suite analyzed in " + MiscTools.msToString(watchAnalyzing.elapsed(TimeUnit.MILLISECONDS)) + " minutes." + '\n');
    }

    public void analyzeDependencies() {
        Stopwatch watchAnalyzing = Stopwatch.createStarted();
        ExecutorService pool = Executors.newFixedThreadPool(this.cores);
        Pattern pattern = Pattern.compile(this.activeProfile.getIgnoredResourceRegExp());
        Matcher matcher = null;
        ArrayList<DependencyAnalyzer> analyzer = new ArrayList<DependencyAnalyzer>();
        int i = 0;
        while (i < TTCN3GlobalScopeProvider.RESOURCES.size()) {
            Resource resource = TTCN3GlobalScopeProvider.RESOURCES.get(i);
            matcher = pattern.matcher(resource.getURI().toFileString());
            if (!matcher.matches()) {
                analyzer.add(new DependencyAnalyzer(TTCN3GlobalScopeProvider.RESOURCES.get(i), this.logger));
            }
            ++i;
        }
        try {
            List output = pool.invokeAll(analyzer);
            pool.shutdown();
            System.out.print('\n');
            for (Future f : output) {
                TTCN3Dependency o = (TTCN3Dependency)f.get();
                System.out.println("Dependency analysis output of " + o.getResource().getURI().lastSegment());
                for (String d : o.getMessages()) {
                    this.printOutput(o.getResource(), d);
                }
            }
            String xmlpath = "dependencies.xml";
            File parent = new File(this.activeProfile.getDependencyOutputPath());
            parent.mkdirs();
            xmlpath = String.valueOf(parent.getAbsolutePath()) + File.separator + xmlpath;
            try {
                FileOutputStream file = new FileOutputStream(xmlpath);
                PrintStream stream = new PrintStream(file);
                stream.print("<?xml-stylesheet type=\"text/xsl\" href=\"../dependencies.xsl\"?>\n<dependencies>\n");
                for (Future f : output) {
                    for (String d : ((TTCN3Dependency)f.get()).getOutput()) {
                        stream.print(d);
                    }
                }
                stream.print("</dependencies>");
                stream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        watchAnalyzing.stop();
        System.out.println("Test suite analyzed in " + MiscTools.msToString(watchAnalyzing.elapsed(TimeUnit.MILLISECONDS)) + " minutes." + '\n');
    }

    private void printOutput(Resource resource, String message) {
        System.out.println(message);
    }

    private void printOutput(Resource resource, FeatureBasedDiagnostic featureDiagnostic) {
        block0 : switch (featureDiagnostic.getSeverity()) {
            case 4: {
                this.logger.logError(resource.getURI(), Integer.parseInt(featureDiagnostic.getIssueData()[0]), Integer.parseInt(featureDiagnostic.getIssueData()[1]), LoggingInterface.MessageClass.valueOf(featureDiagnostic.getIssueCode()), featureDiagnostic.getMessage());
                break;
            }
            case 2: {
                this.logger.logWarning(resource.getURI(), Integer.parseInt(featureDiagnostic.getIssueData()[0]), Integer.parseInt(featureDiagnostic.getIssueData()[1]), LoggingInterface.MessageClass.valueOf(featureDiagnostic.getIssueCode()), featureDiagnostic.getMessage(), featureDiagnostic.getIssueData()[2]);
                break;
            }
            case 1: {
                switch (LoggingInterface.LogLevel.valueOf(featureDiagnostic.getIssueData()[3])) {
                    case INFORMATION: {
                        this.logger.logInformation(resource.getURI(), Integer.parseInt(featureDiagnostic.getIssueData()[0]), Integer.parseInt(featureDiagnostic.getIssueData()[1]), LoggingInterface.MessageClass.valueOf(featureDiagnostic.getIssueCode()), featureDiagnostic.getMessage(), featureDiagnostic.getIssueData()[2]);
                        break block0;
                    }
                    case FIXME: {
                        this.logger.logFix(resource.getURI(), Integer.parseInt(featureDiagnostic.getIssueData()[0]), Integer.parseInt(featureDiagnostic.getIssueData()[1]), LoggingInterface.MessageClass.valueOf(featureDiagnostic.getIssueCode()), featureDiagnostic.getMessage(), featureDiagnostic.getIssueData()[2]);
                        break block0;
                    }
                    case DEBUG: {
                        this.logger.logDebug(resource.getURI(), Integer.parseInt(featureDiagnostic.getIssueData()[0]), Integer.parseInt(featureDiagnostic.getIssueData()[1]), LoggingInterface.MessageClass.valueOf(featureDiagnostic.getIssueCode()), featureDiagnostic.getMessage(), featureDiagnostic.getIssueData()[2]);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void printStatistics() {
        if (this.activeProfile.isStatShowLOC()) {
            System.out.println("Total lines of code processed: " + TTCN3StatisticsProvider.getInstance().getParsedLines());
        }
        if (this.activeProfile.isStatShowSummary()) {
            System.out.println("Brief statistics summary of occurences in message classes:");
            System.out.println("\tUniversal: " + TTCN3StatisticsProvider.getInstance().getCountUniversal());
            System.out.println("\tGeneral: " + TTCN3StatisticsProvider.getInstance().getCountGeneral());
            System.out.println("\tNaming Conventions: " + TTCN3StatisticsProvider.getInstance().getCountNaming());
            System.out.println("\tCode Documentation: " + TTCN3StatisticsProvider.getInstance().getCountDocumentation());
            System.out.println("\tLog Statements: " + TTCN3StatisticsProvider.getInstance().getCountLog());
            System.out.println("\tStructure of Data: " + TTCN3StatisticsProvider.getInstance().getCountStructure());
            System.out.println("\tCode Style: " + TTCN3StatisticsProvider.getInstance().getCountStyle());
            System.out.println("\tTest Suite Modularization: " + TTCN3StatisticsProvider.getInstance().getCountModularization());
        }
    }

    public void createXMI() {
        for (Resource r : TTCN3GlobalScopeProvider.RESOURCES) {
            String extension = String.valueOf(TTCN3ResourceProvider.fileExtensionOrPath(r.getURI().devicePath(), true)) + "m";
            this.storeResourceContents((EList<EObject>)r.getContents(), String.valueOf(r.getURI().devicePath()) + "m", extension);
        }
    }

    private void storeResourceContents(EList<EObject> contents, String outputPath, String extension) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(extension, new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource outputResource = resSet.createResource(URI.createURI((String)outputPath));
        outputResource.getContents().addAll(contents);
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            outputResource.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String fileExtensionOrPath(String filename, boolean extension) {
        String[] res = filename.split("\\.");
        int size = res.length;
        if (extension) {
            return res[size - 1];
        }
        return res[0];
    }
}

