/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common;

import com.google.common.collect.SetMultimap;
import de.ugoe.cs.swe.common.CommonHelper;
import de.ugoe.cs.swe.scoping.ImportData;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class PreAnalyzer
implements Callable<Boolean> {
    private final Resource resource;

    public PreAnalyzer(Resource resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findImports() {
        TTCN3Module currentModule = CommonHelper.getModule(this.resource);
        for (ImportDef i : EcoreUtil2.getAllContentsOfType((EObject)currentModule, ImportDef.class)) {
            TTCN3Module importedModule = TTCN3GlobalScopeProvider.NAMED_MODULES.get(i.getName());
            if (importedModule != null) {
                SetMultimap<Resource, ImportData> setMultimap = TTCN3GlobalScopeProvider.IMPORTS;
                synchronized (setMultimap) {
                    if (TTCN3GlobalScopeProvider.IMPORTS.containsKey((Object)this.resource)) {
                        TTCN3GlobalScopeProvider.IMPORTS.get((Object)this.resource).add(this.initializeImportedObjects(i, importedModule));
                    } else {
                        TTCN3GlobalScopeProvider.IMPORTS.put((Object)this.resource, (Object)this.initializeImportedObjects(i, importedModule));
                    }
                }
                setMultimap = TTCN3GlobalScopeProvider.IMPORTED_RESOURCES;
                synchronized (setMultimap) {
                    if (TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.containsKey((Object)this.resource)) {
                        TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.get((Object)this.resource).add(importedModule.eResource());
                    } else {
                        TTCN3GlobalScopeProvider.IMPORTED_RESOURCES.put((Object)this.resource, (Object)importedModule.eResource());
                    }
                }
                setMultimap = TTCN3GlobalScopeProvider.IMPORTED_FROM;
                synchronized (setMultimap) {
                    if (TTCN3GlobalScopeProvider.IMPORTED_FROM.containsKey((Object)importedModule)) {
                        TTCN3GlobalScopeProvider.IMPORTED_FROM.get((Object)importedModule).add(currentModule);
                    } else {
                        TTCN3GlobalScopeProvider.IMPORTED_FROM.put((Object)importedModule, (Object)currentModule);
                    }
                    continue;
                }
            }
            boolean isASN = false;
            if (i.getSpec() != null) {
                for (String s : i.getSpec().getTxt()) {
                    if (!s.contains("ASN")) continue;
                    isASN = true;
                    break;
                }
            }
            if (isASN) continue;
            SetMultimap<Resource, ImportData> setMultimap = TTCN3GlobalScopeProvider.IMPORTS;
            synchronized (setMultimap) {
                if (TTCN3GlobalScopeProvider.IMPORTS.containsKey((Object)this.resource)) {
                    TTCN3GlobalScopeProvider.IMPORTS.get((Object)this.resource).add(this.initializeImportedObjects(i, importedModule));
                } else {
                    TTCN3GlobalScopeProvider.IMPORTS.put((Object)this.resource, (Object)this.initializeImportedObjects(i, importedModule));
                }
            }
        }
        return true;
    }

    private ImportData initializeImportedObjects(ImportDef def, TTCN3Module module) {
        ImportData data = new ImportData(def.getName(), def, module);
        if (module != null) {
            data.getExportedObjects().addAll(TTCN3GlobalScopeProvider.EXPORTED_OBJECTS.get((Object)module.eResource()));
        }
        return data;
    }

    @Override
    public Boolean call() throws Exception {
        return this.findImports();
    }
}

