/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import de.ugoe.cs.swe.T3Q.T3Q;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.scoping.TTCN3GlobalScopeProvider;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;

public class FileParser
implements Callable<Resource> {
    private final File file;
    private final IQualifiedNameProvider qualifiedNameProvider;
    private final LoggingInterface logger;
    public static boolean printParsingErrors = false;

    public FileParser(File file, IQualifiedNameProvider qualifiedNameProvider, LoggingInterface logger) {
        this.file = file;
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.logger = logger;
    }

    private Resource parseFile() {
        SynchronizedXtextResourceSet resourceSet = new SynchronizedXtextResourceSet();
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.FALSE);
        long millisStart = System.currentTimeMillis();
        int lines = 0;
        try {
            lines = T3Q.countLines(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TTCN3StatisticsProvider.getInstance().addParsedLines(lines);
        String path = this.file.getAbsolutePath();
        Resource res = resourceSet.getResource(URI.createURI((String)("file:///" + path)), true);
        EList errors = res.getErrors();
        if (printParsingErrors) {
            for (Resource.Diagnostic d : errors) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logFix(res.getURI(), d.getLine(), d.getLine(), LoggingInterface.MessageClass.UNIVERSAL, d.getMessage());
            }
        }
        this.initExportedObjects(res);
        long millisEnd = System.currentTimeMillis();
        long millis = millisEnd - millisStart;
        System.out.println("Parsing file: " + this.file.getPath() + " (LOC: " + lines + ")" + '\n' + "       ...done in " + millis + "ms (" + MiscTools.msToString(millis) + " minutes).");
        return res;
    }

    public ISelectable internalGetAllDescriptions(final Resource resource) {
        Iterable<EObject> allContents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            }
        };
        Iterable allDescriptions = Scopes.scopedElementsFor((Iterable)allContents, (Function)this.qualifiedNameProvider);
        return new MultimapBasedSelectable(allDescriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExportedObjects(Resource resource) {
        ArrayList objects = Lists.newArrayList();
        ArrayList exports = Lists.newArrayList((Iterable)this.internalGetAllDescriptions(resource).getExportedObjects());
        int size = exports.size();
        int i = 0;
        while (i < size) {
            IEObjectDescription e = (IEObjectDescription)exports.get(i);
            IEObjectDescription d = null;
            if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getTTCN3Module(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getGroupDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getEnumDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getEnumeration(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getComponentDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getPortDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getRecordDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSetDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSubTypeDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getUnionDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getRecordOfDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSetOfDefNamed(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSignatureDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getBaseTemplate(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getFunctionRef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getAltstepDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getTestcaseDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getSingleConstDef(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            } else if (EcoreUtil2.isAssignableFrom((EClass)TTCN3Package.eINSTANCE.getModuleParameter(), (EClass)e.getEClass())) {
                d = EObjectDescription.create((String)e.getQualifiedName().getLastSegment(), (EObject)e.getEObjectOrProxy());
                objects.add(d);
            }
            ++i;
        }
        SetMultimap<Resource, IEObjectDescription> setMultimap = TTCN3GlobalScopeProvider.EXPORTED_OBJECTS;
        synchronized (setMultimap) {
            TTCN3GlobalScopeProvider.EXPORTED_OBJECTS.putAll((Object)resource, (Iterable)objects);
        }
    }

    @Override
    public Resource call() throws Exception {
        return this.parseFile();
    }
}

