/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import de.ugoe.cs.swe.T3Q.TTCN3Dependency;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.BaseTemplate;
import de.ugoe.cs.swe.tTCN3.ComponentDef;
import de.ugoe.cs.swe.tTCN3.ConstDef;
import de.ugoe.cs.swe.tTCN3.EnumDefNamed;
import de.ugoe.cs.swe.tTCN3.ExtConstDef;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.GroupDef;
import de.ugoe.cs.swe.tTCN3.ImportDef;
import de.ugoe.cs.swe.tTCN3.ModuleDefinition;
import de.ugoe.cs.swe.tTCN3.ModulePar;
import de.ugoe.cs.swe.tTCN3.ModuleParDef;
import de.ugoe.cs.swe.tTCN3.ModuleParameter;
import de.ugoe.cs.swe.tTCN3.NamedObject;
import de.ugoe.cs.swe.tTCN3.PortDef;
import de.ugoe.cs.swe.tTCN3.RecordDefNamed;
import de.ugoe.cs.swe.tTCN3.RecordOfDefNamed;
import de.ugoe.cs.swe.tTCN3.RefValue;
import de.ugoe.cs.swe.tTCN3.SetDefNamed;
import de.ugoe.cs.swe.tTCN3.SetOfDefNamed;
import de.ugoe.cs.swe.tTCN3.SignatureDef;
import de.ugoe.cs.swe.tTCN3.SingleConstDef;
import de.ugoe.cs.swe.tTCN3.SubTypeDefNamed;
import de.ugoe.cs.swe.tTCN3.TTCN3File;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TemplateDef;
import de.ugoe.cs.swe.tTCN3.TestcaseDef;
import de.ugoe.cs.swe.tTCN3.TypeDef;
import de.ugoe.cs.swe.tTCN3.TypeDefBody;
import de.ugoe.cs.swe.tTCN3.UnionDefNamed;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class DependencyAnalyzer
implements Callable<TTCN3Dependency> {
    private final Resource resource;
    private final LoggingInterface logger;
    public static boolean printUnresolvedObjects = false;
    private final LinkedHashMap<String, String> types = new LinkedHashMap();

    public DependencyAnalyzer(Resource resource, LoggingInterface logger) {
        this.resource = resource;
        this.logger = logger;
        this.types.put("TypeDef", "Type");
        this.types.put("ComponentDef", "Type");
        this.types.put("PortDef", "Type");
        this.types.put("TemplateDef", "Template");
        this.types.put("FunctionDef", "Function");
        this.types.put("AltstepDef", "Altstep");
        this.types.put("TestcaseDef", "Testcase");
        this.types.put("ConstDef", "Constant");
        this.types.put("ExtConstDef", "External Constant");
        this.types.put("ExtFunctionDef", "External Function");
        this.types.put("ModuleParDef", "Module Parameter");
        this.types.put("SignatureDef", "Signature");
        this.types.put("GroupDef", "Group");
    }

    private TTCN3Dependency analyze() {
        TTCN3Dependency output = new TTCN3Dependency(this.resource);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        EcoreUtil.resolveAll((Resource)this.resource);
        EObject model = (EObject)this.resource.getContents().get(0);
        for (TTCN3Module module : ((TTCN3File)model).getModules()) {
            List definitions = EcoreUtil2.getAllContentsOfType((EObject)module, ModuleDefinition.class);
            for (ModuleDefinition d : definitions) {
                ICompositeNode node = NodeModelUtils.getNode((EObject)d);
                String moduleName = module.getName();
                String elementName = this.getModuleDefinitionName(d);
                String id = String.valueOf(moduleName) + "-" + elementName;
                String type = this.types.get(d.getDef().eClass().getName());
                String fileName = this.resource.getURI().segment(this.resource.getURI().segmentCount() - 1);
                int startLine = node.getStartLine();
                int endLine = node.getTotalEndLine();
                if (type != null && elementName != null) {
                    String xml;
                    String references;
                    int pEndLine;
                    int pStartLine;
                    ICompositeNode pNode;
                    String pid;
                    String pElementName;
                    String option;
                    if (type.equals("Module Parameter")) {
                        List parameters = EcoreUtil2.getAllContentsOfType((EObject)d, ModuleParameter.class);
                        option = "";
                        if (parameters.size() > 1) {
                            option = " conflicted=\"true\"";
                        }
                        for (RefValue p : parameters) {
                            pElementName = p.getName();
                            pid = String.valueOf(moduleName) + "-" + pElementName;
                            pNode = NodeModelUtils.getNode((EObject)p);
                            pStartLine = pNode.getStartLine();
                            pEndLine = pNode.getTotalEndLine();
                            pStartLine = startLine;
                            pEndLine = endLine;
                            references = "";
                            references = String.valueOf(references) + this.getReferences(p, (INode)pNode, pid);
                            references = String.valueOf(references) + this.getReferences(((ModulePar)p.eContainer().eContainer()).getType(), (INode)pNode, pid);
                            references = "\n\t\t<reflist>" + references + "\n\t\t</reflist>";
                            xml = "\t<element id=\"" + pid + "\"" + " name=\"" + pElementName + "\"" + " type=\"" + type + "\"" + " startline=\"" + pStartLine + "\"" + " endline=\"" + pEndLine + "\"" + " module=\"" + moduleName + "\"" + " file=\"" + fileName + "\"" + option + ">" + references + "\n\t" + "</element>" + "\n\n";
                            output.getOutput().add(xml);
                        }
                        continue;
                    }
                    if (type.equals("Constant")) {
                        List constants = EcoreUtil2.getAllContentsOfType((EObject)d, SingleConstDef.class);
                        option = "";
                        if (constants.size() > 1) {
                            option = " conflicted=\"true\"";
                        }
                        for (RefValue p : constants) {
                            pElementName = p.getName();
                            pid = String.valueOf(moduleName) + "-" + pElementName;
                            pNode = NodeModelUtils.getNode((EObject)p);
                            pStartLine = pNode.getStartLine();
                            pEndLine = pNode.getTotalEndLine();
                            pStartLine = startLine;
                            pEndLine = endLine;
                            references = "";
                            references = String.valueOf(references) + this.getReferences(p, (INode)pNode, pid);
                            references = String.valueOf(references) + this.getReferences(((ConstDef)p.eContainer().eContainer()).getType(), (INode)pNode, pid);
                            references = "\n\t\t<reflist>" + references + "\n\t\t</reflist>";
                            xml = "\t<element id=\"" + pid + "\"" + " name=\"" + pElementName + "\"" + " type=\"" + type + "\"" + " startline=\"" + pStartLine + "\"" + " endline=\"" + pEndLine + "\"" + " module=\"" + moduleName + "\"" + " file=\"" + fileName + "\"" + option + ">" + references + "\n\t" + "</element>" + "\n\n";
                            output.getOutput().add(xml);
                        }
                        continue;
                    }
                    if (type.equals("External Constant")) {
                        EList<NamedObject> ids = ((ExtConstDef)d.getDef()).getId().getIds();
                        option = "";
                        if (ids.size() > 1) {
                            option = " conflicted=\"true\"";
                        }
                        for (RefValue p : ids) {
                            pElementName = p.getName();
                            pid = String.valueOf(moduleName) + "-" + pElementName;
                            pNode = NodeModelUtils.getNode((EObject)p);
                            pStartLine = pNode.getStartLine();
                            pEndLine = pNode.getTotalEndLine();
                            pStartLine = startLine;
                            pEndLine = endLine;
                            references = "";
                            references = String.valueOf(references) + this.getReferences(((ExtConstDef)p.eContainer().eContainer()).getType(), (INode)pNode, pid);
                            references = "\n\t\t<reflist>" + references + "\n\t\t</reflist>";
                            xml = "\t<element id=\"" + pid + "\"" + " name=\"" + pElementName + "\"" + " type=\"" + type + "\"" + " startline=\"" + pStartLine + "\"" + " endline=\"" + pEndLine + "\"" + " module=\"" + moduleName + "\"" + " file=\"" + fileName + "\"" + option + ">" + references + "\n\t" + "</element>" + "\n\n";
                            output.getOutput().add(xml);
                        }
                        continue;
                    }
                    String option2 = "";
                    String content = "";
                    String references2 = "";
                    if (type.equals("Group")) {
                        content = this.getContent(d, (INode)node, moduleName);
                        content = "\n\t\t<elementlist>" + content + "\n\t\t</elementlist>";
                    } else {
                        references2 = this.getReferences(d, (INode)node, id);
                        references2 = "\n\t\t<reflist>" + references2 + "\n\t\t</reflist>";
                    }
                    String xml2 = "\t<element id=\"" + id + "\"" + " name=\"" + elementName + "\"" + " type=\"" + type + "\"" + " startline=\"" + startLine + "\"" + " endline=\"" + endLine + "\"" + " module=\"" + moduleName + "\"" + " file=\"" + fileName + "\"" + option2 + ">" + content + references2 + "\n\t" + "</element>" + "\n\n";
                    output.getOutput().add(xml2);
                    continue;
                }
                if (d.getDef() instanceof ImportDef) continue;
                String message = "analyze: Element type (" + d.getDef().getClass().getName() + ") not supported yet!";
                this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
            }
        }
        if (printUnresolvedObjects) {
            for (Resource.Diagnostic d : this.resource.getErrors()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), d.getLine(), d.getLine(), LoggingInterface.MessageClass.UNIVERSAL, d.getMessage());
            }
            for (Resource.Diagnostic d : this.resource.getWarnings()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), d.getLine(), d.getLine(), LoggingInterface.MessageClass.UNIVERSAL, d.getMessage());
            }
        }
        stopwatch.stop();
        System.out.println("Analyzing  file: " + this.resource.getURI().devicePath().replaceFirst("///", "") + '\n' + "       ...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        return output;
    }

    private String getContent(ModuleDefinition d, INode node, String moduleName) {
        String content = "";
        if (((GroupDef)d.getDef()).getList() != null) {
            for (ModuleDefinition gd : ((GroupDef)d.getDef()).getList().getDefinitions()) {
                String pid;
                String pElementName;
                if (gd.getDef() instanceof ConstDef) {
                    List constants = EcoreUtil2.getAllContentsOfType((EObject)gd, SingleConstDef.class);
                    for (RefValue p : constants) {
                        pElementName = p.getName();
                        pid = String.valueOf(moduleName) + "-" + pElementName;
                        content = String.valueOf(content) + "\n\t\t\t<ref id=\"" + pid + "\"" + "/>";
                    }
                    continue;
                }
                if (gd.getDef() instanceof ModuleParDef) {
                    List parameters = EcoreUtil2.getAllContentsOfType((EObject)gd, ModuleParameter.class);
                    for (RefValue p : parameters) {
                        pElementName = p.getName();
                        pid = String.valueOf(moduleName) + "-" + pElementName;
                        content = String.valueOf(content) + "\n\t\t\t<ref id=\"" + pid + "\"" + "/>";
                    }
                    continue;
                }
                if (gd.getDef() instanceof ExtConstDef) {
                    EList<NamedObject> ids = ((ExtConstDef)gd.getDef()).getId().getIds();
                    for (NamedObject ec : ids) {
                        pElementName = ec.getName();
                        pid = String.valueOf(moduleName) + "-" + pElementName;
                        content = String.valueOf(content) + "\n\t\t\t<ref id=\"" + pid + "\"" + "/>";
                    }
                    continue;
                }
                String gElementName = this.getModuleDefinitionName(gd);
                if (gElementName != null) {
                    String rid = String.valueOf(moduleName) + "-" + gElementName;
                    content = String.valueOf(content) + "\n\t\t\t<ref id=\"" + rid + "\"" + "/>";
                    continue;
                }
                String message = "getContent: Element (" + gd + ") not supported yet!";
                this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
            }
        }
        return content;
    }

    private String getReferences(EObject d, INode node, String id) {
        String references = "";
        HashSet<String> rids = new HashSet<String>();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)Lists.newArrayList((Object[])new EObject[]{d}));
        TreeMap<String, EObject> offsetCrossReferences = new TreeMap<String, EObject>();
        for (EObject o : crossReferences.keySet()) {
            int offset = NodeModelUtils.getNode((EObject)((EStructuralFeature.Setting)((Collection)crossReferences.get(o)).iterator().next()).getEObject()).getOffset();
            int targetOffset = -1;
            ICompositeNode targetNode = NodeModelUtils.getNode((EObject)o);
            if (targetNode != null) {
                targetOffset = targetNode.getOffset();
            }
            offsetCrossReferences.put(String.valueOf(offset) + "->" + targetOffset, o);
        }
        for (EObject o : offsetCrossReferences.values()) {
            String rid;
            String rName;
            TTCN3Module rModule = (TTCN3Module)EcoreUtil2.getContainerOfType((EObject)o, TTCN3Module.class);
            if (rModule == null) {
                EObject sObject = ((EStructuralFeature.Setting)((Collection)crossReferences.get(o)).iterator().next()).getEObject();
                rName = this.getSObjectName(sObject);
                rid = "unresolvedReference---" + rName.trim();
                if (rids.contains(rid)) continue;
                rids.add(rid);
                references = String.valueOf(references) + "\n\t\t\t<ref id=\"" + rid + "\"" + "/>";
                String message = "getReferences: Element (" + o + ") cannot be resolved! (" + sObject + ")";
                this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
                continue;
            }
            String rModuleName = rModule.getName();
            rName = this.getReferencedDefinitionName(o);
            if (rName != null) {
                rid = String.valueOf(rModuleName) + "-" + rName;
                if (rid.equals(id) || rids.contains(rid)) continue;
                rids.add(rid);
                references = String.valueOf(references) + "\n\t\t\t<ref id=\"" + rid + "\"" + "/>";
                continue;
            }
            String message = "getReferences: Element (" + o + ") not supported yet!";
            this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
        }
        return references;
    }

    private String getSObjectName(EObject sObject) {
        String name = NodeModelUtils.getNode((EObject)sObject).getText().trim();
        for (INode c : NodeModelUtils.getNode((EObject)sObject).getChildren()) {
            if (!(c.getGrammarElement() instanceof CrossReference)) continue;
            name = c.getText().trim();
        }
        name = name.replaceAll("//.+\\s*\n\\s+", "");
        name = name.replaceAll("runs on ", "");
        name = name.replaceAll("system ", "");
        name = name.replaceAll("([\\d\\w_]+).*", "$1");
        name = name.replaceAll("^\\.", "");
        return name;
    }

    @Override
    public TTCN3Dependency call() throws Exception {
        return this.analyze();
    }

    private String getModuleDefinitionName(ModuleDefinition d) {
        String eClassName;
        String name = null;
        switch (eClassName = d.getDef().eClass().getName()) {
            case "FunctionDef": {
                name = ((FunctionDef)d.getDef()).getName();
                break;
            }
            case "ExtFunctionDef": {
                name = ((ExtFunctionDef)d.getDef()).getName();
                break;
            }
            case "TemplateDef": {
                name = ((TemplateDef)d.getDef()).getBase().getName();
                break;
            }
            case "TypeDef": {
                TypeDefBody body = ((TypeDef)d.getDef()).getBody();
                if (body.getStructured() != null) {
                    if (body.getStructured().getComponent() != null) {
                        name = body.getStructured().getComponent().getName();
                        break;
                    }
                    if (body.getStructured().getPort() != null) {
                        name = body.getStructured().getPort().getName();
                        break;
                    }
                    if (body.getStructured().getRecord() != null) {
                        if (!(body.getStructured().getRecord() instanceof RecordDefNamed)) break;
                        name = ((RecordDefNamed)body.getStructured().getRecord()).getName();
                        break;
                    }
                    if (body.getStructured().getRecordOf() != null) {
                        if (!(body.getStructured().getRecordOf() instanceof RecordOfDefNamed)) break;
                        name = ((RecordOfDefNamed)body.getStructured().getRecordOf()).getName();
                        break;
                    }
                    if (body.getStructured().getSet() != null) {
                        if (!(body.getStructured().getSet() instanceof SetDefNamed)) break;
                        name = ((SetDefNamed)body.getStructured().getSet()).getName();
                        break;
                    }
                    if (body.getStructured().getSetOf() != null) {
                        if (!(body.getStructured().getSetOf() instanceof SetOfDefNamed)) break;
                        name = ((SetOfDefNamed)body.getStructured().getSetOf()).getName();
                        break;
                    }
                    if (body.getStructured().getEnumDef() != null) {
                        if (!(body.getStructured().getEnumDef() instanceof EnumDefNamed)) break;
                        name = ((EnumDefNamed)body.getStructured().getEnumDef()).getName();
                        break;
                    }
                    if (body.getStructured().getUnion() == null || !(body.getStructured().getUnion() instanceof UnionDefNamed)) break;
                    name = ((UnionDefNamed)body.getStructured().getUnion()).getName();
                    break;
                }
                if (!(body.getSub() instanceof SubTypeDefNamed)) break;
                name = ((SubTypeDefNamed)body.getSub()).getName();
                break;
            }
            case "AltstepDef": {
                name = ((AltstepDef)d.getDef()).getName();
                break;
            }
            case "TestcaseDef": {
                name = ((TestcaseDef)d.getDef()).getName();
                break;
            }
            case "SignatureDef": {
                name = ((SignatureDef)d.getDef()).getName();
                break;
            }
            case "ModuleParDef": {
                if (((ModuleParDef)d.getDef()).getParam() != null) {
                    name = ((ModuleParameter)((ModuleParDef)d.getDef()).getParam().getList().getParams().get(0)).getName();
                    break;
                }
                if (((ModuleParDef)d.getDef()).getMultitypeParam() == null || ((ModuleParDef)d.getDef()).getMultitypeParam().getParams().isEmpty()) break;
                name = ((ModuleParameter)((ModulePar)((ModuleParDef)d.getDef()).getMultitypeParam().getParams().get(0)).getList().getParams().get(0)).getName();
                break;
            }
            case "GroupDef": {
                name = ((GroupDef)d.getDef()).getName();
                break;
            }
            case "ConstDef": {
                name = ((SingleConstDef)((ConstDef)d.getDef()).getDefs().getList().get(0)).getName();
                break;
            }
            case "ExtConstDef": {
                name = ((NamedObject)((ExtConstDef)d.getDef()).getId().getIds().get(0)).getName();
                break;
            }
            default: {
                String message = "getModuleDefinitionName: Element type (" + eClassName + ") not supported yet!";
                ICompositeNode node = NodeModelUtils.getNode((EObject)d);
                this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
            }
        }
        return name;
    }

    private String getReferencedDefinitionName(EObject d) {
        String eClassName;
        String name = null;
        switch (eClassName = d.eClass().getName()) {
            case "FunctionDef": {
                name = ((FunctionDef)d).getName();
                break;
            }
            case "ExtFunctionDef": {
                name = ((ExtFunctionDef)d).getName();
                break;
            }
            case "NamedObject": {
                name = ((NamedObject)d).getName();
                break;
            }
            case "BaseTemplate": {
                name = ((BaseTemplate)d).getName();
                break;
            }
            case "TemplateDef": {
                name = ((TemplateDef)d).getBase().getName();
                break;
            }
            case "ComponentDef": {
                name = ((ComponentDef)d).getName();
                break;
            }
            case "PortDef": {
                name = ((PortDef)d).getName();
                break;
            }
            case "RecordDefNamed": {
                name = ((RecordDefNamed)d).getName();
                break;
            }
            case "RecordOfDefNamed": {
                name = ((RecordOfDefNamed)d).getName();
                break;
            }
            case "SetDefNamed": {
                name = ((SetDefNamed)d).getName();
                break;
            }
            case "SetOfDefNamed": {
                name = ((SetOfDefNamed)d).getName();
                break;
            }
            case "UnionDefNamed": {
                name = ((UnionDefNamed)d).getName();
                break;
            }
            case "EnumDefNamed": {
                name = ((EnumDefNamed)d).getName();
                break;
            }
            case "SubTypeDefNamed": {
                name = ((SubTypeDefNamed)d).getName();
                break;
            }
            case "AltstepDef": {
                name = ((AltstepDef)d).getName();
                break;
            }
            case "TestcaseDef": {
                name = ((TestcaseDef)d).getName();
                break;
            }
            case "SignatureDef": {
                name = ((SignatureDef)d).getName();
                break;
            }
            case "SingleConstDef": {
                if (!(d.eContainer().eContainer().eContainer() instanceof ModuleDefinition)) break;
                name = ((SingleConstDef)d).getName();
                break;
            }
            case "ModuleParameter": {
                name = ((ModuleParameter)d).getName();
                break;
            }
            default: {
                String message = "getReferencedDefinitionName: Element type (" + eClassName + ") not supported yet!";
                ICompositeNode node = NodeModelUtils.getNode((EObject)d);
                this.logger.logFix(this.resource.getURI(), node.getStartLine(), node.getEndLine(), LoggingInterface.MessageClass.UNIVERSAL, message);
            }
            case "SingleVarInstance": 
        }
        return name;
    }
}

