# MEC Testing Framework in TTCN-3

## Introduction
This repositories contains the test specifications and test adapter code for MEC Testing project in TTCN-3.

## Contact information
Email at cti_support at etsi dot org

## License
Unless specified otherwise, the content of this repository and the files contained are released under the ETSI Software License.
See the attached LICENSE file or visit
https://forge.etsi.org/etsi-software-license

## Standard links
- Mobile-Edge Computation standards, accessible [here](https://www.etsi.org/standards#page=1&search=MEC&title=1&etsiNumber=1&content=1&version=0&onApproval=1&published=1&historical=1&startDate=1988-01-15&endDate=2019-05-06&harmonized=0&keyword=&TB=&stdType=&frequency=&mandate=&collection=&sort=1)

## RFC links
- RFC 7159 - The JavaScript Object Notation (JSON) Data Interchange Format, accessible [here](https://tools.ietf.org/html/rfc7159.html)

NOTE All draft can be found in the 'IETF XML Registry', accessible [here](https://www.iana.org/assignments/xml-registry/xml-registry.xhtml)



## Installation

The MEC Testing Framework project builds and tests regularly on the following platforms:

  - Linux (Ubuntu)

Note: The [OpenSSL](https://www.openssl.org) version > 1.1.x is also required.

### How to do it?

They are two different methods:
- Using [Vagrant](https://www.vagrantup.com/)
- Using [Docker](https://www.docker.com/)

How to choose one of these methods is depending of your host system.

NOTE: In all case, if you want to setup an continuous integration process (e.g. Jenkins), Docker is the best choice. 


#### The host system is Windows
The both methods require a virtual machine. You can use either VirtualBox or WMware.
In this case, the easiest way is to use Vagrant.


#### The host system is Linux
Vagrant requires a virtual machine. You can use either VirtualBox or WMware.
Docker does not need a virtual machine, so it is the more efficant way.


### Using Vagrant

Pre-requisites on your host machine:
- Install [Virtualbox](https://www.virtualbox.org/manual/ch01.html)
- Install [Vagrant](https://www.vagrantup.com/intro/getting-started/)
- Install Vagrant plugin vagrant-vbguest
- Credentials to access [ETSI forge](https://forge.etsi.org/gitlab/users/sign_in)
    - Set the environment variable USERNAME to your ETSI EOL account user name
    - Set the environment variable PASSWORD to your ETSI EOL account password

Procedure:
- On your host machine, open a command line session (PuTTY, DOS window...)
- From the ETSI MEC Testing Framework project, clone the Vagrant folder
- In the file Vagrantfile, modify the tag config.vm.provision replacing <username> & <password> strings by your ETSI credentials
- In the Vagrant folder, execute the following commands:

```sh
$ vagrant up --provider virtualbox --provision
...
```

NOTE The creation and the installations will take some time to achieve
- Stop vagrant virtual machine

```sh
$ vagrant halt
...
```

- Update the file 'Vagrantfile' to match with your networks configuration
- Re-start the vagrant virtual machine and log to to the machine

```sh
$ vagrant up
...
$ vagrant ssh
```

- Switch to the next clause (Usage)

NOTE The user password is vagrant.


### Using Docker

Pre-requisites on your host machine:
- Install Virtualbox
- Install Docker

Procedure for a Windows host machine:
- On your host machine, open a the Docker Quickstart Terminal
- On your host machine, clone the ETSI MEC Testing Framework project. NOTE that only Docker folder and .jenkins.sh script file are required
- From the ETSI MEC Testing Framework project root directory, execute the following commands:

```sh
$ ./.jenkins.sh
...
```

NOTE The creation and the installations will take some time to achieve
- Start the container

```sh
$ ./docker/run-container.sh
...
```

- Switch to the next clause (Usage)


### From scratch

Pre-requisites:
- Install Virtualbox

Procedure:
- Install a new Linux Virtual machine (Mint, Debian...)
- Update your system with the latest version of kernel and security packages
- Install the following packages (According to the Linux chosen, the package naming can be different)
    autoconf
    bison
    build-essential
    cmake
    curl
    dos2unix
    doxygen
    emacs
    expect
    flex
    g++:latest
    gcc:latest
    graphviz
    gdb 
    git-core
    gnutls-bin
    libglib2.0-dev
    libpcap-dev
    libgcrypt-dev
    libncurses5-dev
    libssl-dev
    libtool-bin
    libtool
    libwireshark-dev
    libxml2-dev
    lsof
    ntp
    pkg-config
    qt5-default
    qtmultimedia5-dev
    libqt5svg5-dev
    subversion
    sudo
    sshpass
    tcpdump
    texlive-font-utils
    tshark
    valgrind
    vim
    vsftpd
    xutils-dev 
    tree
    tzdata
    unzip
    wget
    xsltproc
- In your home directory, create the following folders: 
    - $HOME/frameworks, 
    - $HOME/dev
    - $HOME/lib
- In $HOME/frameworks, build the following package:
    - asn1c, according the procedure specified [here](https://github.com/vlm/asn1c.git)
    - Eclipse IDE for C/C++ Developers, according the procedure specified [here](https://www.eclipse.org/cdt/)
    - TITAN, according the procedure specified [here](https://github.com/eclipse/titan.core)
    - Import the TITAN plugin into your Eclipse IDE, according the procedure specified [here](https://github.com/eclipse/titan.core)
- Clone the ETSI MEC Testing Framework project into $HOME/dev folder

```sh
$ git clone 
```

- Update your default environment with the content of the script $HOME/dev/STF569_Mec/scripts/devenv.bash.ubuntu
- Switch to the next clause (Usage)


## Usage

This clause describes how to compile and execute an Abstract Test Suite.


Pre-requisites:
- Your machine is installed following one of the installation method describes in the previous clause
- Your are logged as 'etsi' or 'vagrant' user

Procedure using Eclipse TITAN:
- Start eclipse using a new workspace, (e.g. with the name workspace_titan)
- Download and follow the steps to install Eclipse plugins for TITAN, accessible [here]{https://www.eclipse.org/downloads/download.php?file=/titan/Eclipse_installationguide.pdf}
- Open the workspace_titan
- Create a new TITAN project (e.g. STF569_Mec)
<TODO>

Procedure in TITAN command line:
- Open several SSH session (PuTTY...)
- Change to the directory ~/dev/STF569_Mec/src/AtsMec/objs
- Build the test suite AtsMec

```sh
$ ../bin/mec_generate_makefile.bash
...
```

- Edit the file ../etc/AtsMec.cfg
- Update the following fields (see ETSI TS 103 099 for details):
    - PICS_HEADER_HOST, the HTTP host header value
    - system.httpPort.params
- To run the test suite, execute the following command:

```sh
$ ../bin/run-all.bash
...
```

- The log files are located in ../logs folder. You can edit them using any editor or using the Eclipse TITAN log plugins


## How to Report a Bug

The ETSI MEC Testing Framework project is under constant development, so it is possible that you will
encounter a bug while using it. Please report bugs at cti_support at etsi dot org.
