#!/bin/bash
# Prepare environment for the build
#set -e # Exit with non 0 if any command fails
#set -vx

# Update system
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get dist-upgrade -y
sudo DEBIAN_FRONTEND=noninteractive apt-get install software-properties-common -y
sudo DEBIAN_FRONTEND=noninteractive add-apt-repository ppa:linuxuprising/java -y
sudo DEBIAN_FRONTEND=noninteractive apt-get update
sudo DEBIAN_FRONTEND=noninteractive apt-get --allow-unauthenticated install emacs openjdk-11-jre gcc-8 g++-8 git subversion lsof ntp gdb make cmake flex bison autoconf doxygen graphviz libtool libedit2 libedit-dev libncurses5-dev expect libssl-dev libgcrypt-dev libxml2-dev xutils-dev tcpdump libpcap-dev libwireshark-dev wget tree unzip sshpass kubuntu-desktop valgrind qt5-default qttools5-dev qtmultimedia5-dev libqt5svg5-dev vim tzdata dos2unix xsltproc -y
# Install java
#sudo DEBIAN_FRONTEND=noninteractive apt-get install oracle-java9-installer oracle-java9-set-default -y
#sudo DEBIAN_FRONTEND=noninteractive apt-get --allow-unauthenticated install oracle-java10-installer oracle-java10-set-default -y
#sudo DEBIAN_FRONTEND=noninteractive apt --fix-broken install -y
sudo DEBIAN_FRONTEND=noninteractive apt-get autoremove --purge -y
sudo DEBIAN_FRONTEND=noninteractive apt-get clean

gcc --version
g++ --version
valgrind --version
java -version

export HOME=/home/vagrant

export PATH_DEV=${HOME}/dev
export HOME_FRAMEWORKS=${HOME}/frameworks
export HOME_LIB=${HOME}/lib
export HOME_BIN=${HOME}/bin
export HOME_ETC=${HOME}/etc
export HOME_INC=${HOME}/include
export HOME_TMP=${HOME}/tmp
export HOME_DOCS=${HOME}/docs
export PATH=${HOME_BIN}:${PATH}
export LD_LIBRARY_PATH=${HOME_LIB}:/usr/local/lib:${LD_LIBRARY_PATH}

OLD_PWD=`pwd`
# Create directories
mkdir -p ${HOME_LIB}
if [ ! -d ${HOME_LIB} ]
then
    exit -1
fi
mkdir -p ${HOME_INC}
if [ ! -d ${HOME_INC} ]
then
    exit -1
fi
mkdir -p ${HOME_BIN}
if [ ! -d ${HOME_BIN} ]
then
    exit -1
fi
mkdir -p ${HOME_TMP}
if [ ! -d ${HOME_TMP} ]
then
    exit -1
fi
mkdir -p ${HOME_DOCS}
if [ ! -d ${HOME_DOCS} ]
then
    exit -1
fi
mkdir -p ${HOME_FRAMEWORKS}
if [ ! -d ${HOME_FRAMEWORKS} ]
then
    exit -1
fi
mkdir -p ${PATH_DEV}
if [ ! -d ${PATH_DEV} ]
then
    exit -1
fi

# Clone project
cd /home/vagrant/dev
git clone https://forge.etsi.org/gitlab/mec/gs032p3-ttcn-test-suite.git ./TTF_T012_Mec
cd /home/vagrant/dev/TTF_T012_Mec
git clone --recurse-submodules -b v2.2.1-dev --single-branch https://forge.etsi.org/rep/mec/gs032p3-ttcn-test-suite.git TTF_T012_Mec
cd /home/vagrant/dev/TTF_T012_Mec/ttcn
git clone https://forge.etsi.org/gitlab/LIBS/LibCommon.git ./LibCommon
git clone -bTTF0002 https://forge.etsi.org/gitlab/LIBS/LibIts ./LibIts
cd /home/vagrant/dev/TTF_T012_Mec/ttcn/LibIts
rm -fr asn1 t3q xsd
cd ttcn && rm -fr BTP CAM Common DENM GeoNetworking Ipv6OverGeoNetworking IVIM MapemSpatem Pki Security SremSsem Rtcmem
cd /home/vagrant/dev/TTF_T012_Mec/scripts
chmod 775 *.bash devenv.bash.*
cd /home/vagrant/dev/TTF_T012_Mec/virtualization/docker
chmod 775 *.sh
cd /home/vagrant/dev/TTF_T012_Mec
chmod 775 ./.jenkins.sh
cd /home/vagrant
ln -sf /home/vagrant/dev/TTF_T012_Mec/scripts/devenv.bash.ubuntu /home/vagrant/devenv.bash
. /home/vagrant/devenv.bash

# Apply patch
cd /home/vagrant/dev/TTF_T012_Mec
cp ./ttcn/patch_lib_common_titan/module.mk ./ttcn/LibCommon/
cp ./ttcn/patch_lib_common_titan/*.ttcn ./ttcn/LibCommon/ttcn
cp  ./ttcn/patch_lib_http/*.ttcn ./ttcn/LibIts/ttcn/Http/
cp  ./ttcn/patch_lib_its/module.mk ./ttcn/LibIts/

# Install all frameworks

# Install osip
cd ${HOME_FRAMEWORKS}
git clone git://git.savannah.gnu.org/osip.git ./osip
cd ./osip
./autogen.sh
./configure --prefix=/home/vagrant
make && make install

# Install GoogleTest
cd ${HOME_FRAMEWORKS}
git clone https://github.com/google/googletest.git googletest
cd ${HOME_FRAMEWORKS}/googletest/
cmake .
make CXX=g++
sudo make install

# Install latest LCOV
cd ${HOME_FRAMEWORKS}
mkdir -p ${HOME_FRAMEWORKS}/lcov
cd ${HOME_FRAMEWORKS}/lcov
wget http://ftp.de.debian.org/debian/pool/main/l/lcov/lcov_1.13.orig.tar.gz
tar xf lcov_1.13.orig.tar.gz
sudo make -C lcov-1.13/ install

# Install lcov to coveralls conversion
sudo gem install coveralls-lcov

lcov --version
coveralls-lcov -h

cd /home/vagrant
echo "" >> /home/vagrant/.bashrc
echo "export LD_LIBRARY_PATH=/home/vagrant/lib:$LD_LIBRARY_PATH" >> /home/vagrant/.bashrc
echo "export PATH=/home/vagrant/bin:$PATH" >> /home/vagrant/.bashrc
echo ". ~/devenv.bash" >> /home/vagrant/.bashrc

# Install eclipse
cd ${HOME}/frameworks
wget --progress=dot:mega 'http://www.mirrorservice.org/sites/download.eclipse.org/eclipseMirror/technology/epp/downloads/release/2021-12/R/eclipse-cpp-2021-12-R-linux-gtk-x86_64.tar.gz' -Oeclipse-cpp-2021-12-R-linux-gtk-x86_64.tar.gz || exit 1
tar -zxvf ./eclipse-cpp-2021-12-R-linux-gtk-x86_64.tar.gz || exit 1
ln -sf ${HOME}/frameworks/eclipse/eclipse ${HOME}/bin/eclipse
rm -f ./eclipse-cpp-2021-12-R-linux-gtk-x86_64.tar.gz

if wget --progress=dot:mega 'https://www.eclipse.org/downloads/download.php?file=/titan/TITAN_Designer_and_Executor_plugin-8.1.0.zip' -OTITAN_Designer_and_Executor_plugin.zip; then
  eclipse/eclipse -noSplash -application org.eclipse.equinox.p2.director \
    -destination /home/vagrant/frameworks/eclipse \
    -repository 'jar:file:///home/vagrant/frameworks/TITAN_Designer_and_Executor_plugin.zip!/' \
    -installIU TITAN_Designer.feature.group,TITAN_Executor.feature.group,TITAN_Log_Viewer.feature.group,Titan_external_dependencies.feature.group,Titanium.feature.group,Titanium_external_dependencies.feature.group
  rm -f TITAN_Designer_and_Executor_plugin.zip
fi

# Build Titan
cd /home/vagrant/dev/TTF012_Mec/scripts
./build_titan.bash
. /home/vagrant/devenv.bash

# Build ATSs
cd /home/vagrant/dev/TTF012_Mec
export ATS=AtsMec
make

# Update configuration file
cd ./etc/AtsMec
ln -sf AtsMec_Sandbox.cf_ AtsMec.cfg
cd -

cd ${OLD_PWD}

sudo init 6

exit 0
