#!/bin/bash

#set -e
set -vx

echo -e "*****************************\n* Checkout TTF T012 sources\n*****************************\n"
mkdir -p ${HOME}/dev && cd ${HOME}/dev || exit 1

git clone --recurse-submodules -b v2.2.1-dev --single-branch https://forge.etsi.org/rep/mec/gs032p3-ttcn-test-suite.git TTF_T012_Mec
cd /home/etsi/dev/TTF_T012_Mec/ttcn
git clone https://forge.etsi.org/gitlab/LIBS/LibCommon.git ./LibCommon
git clone -bTTF0002 https://forge.etsi.org/gitlab/LIBS/LibIts ./LibIts
cd /home/etsi/dev/TTF_T012_Mec/ttcn/LibIts
rm -fr asn1 t3q xsd
cd ttcn && rm -fr BTP CAM Common DENM GeoNetworking Ipv6OverGeoNetworking IVIM MapemSpatem Pki Security SremSsem Rtcmem

echo -e "*****************************\n* Set up environment\n*****************************\n"
cd /home/etsi/dev/TTF_T012_Mec/scripts
ln -sf /home/etsi/dev/TTF_T012_Mec/scripts/devenv.bash.ubuntu /home/etsi/devenv.bash
. /home/etsi/devenv.bash

echo -e "*****************************\n* Apply patched \n*****************************\n"
cd /home/etsi/dev/TTF_T012_Mec
cp ./ttcn/patch_lib_common_titan/module.mk ./ttcn/LibCommon/
cp ./ttcn/patch_lib_common_titan/*.ttcn ./ttcn/LibCommon/ttcn
cp  ./ttcn/patch_lib_http/*.ttcn ./ttcn/LibIts/ttcn/Http/
cp  ./ttcn/patch_lib_its/module.mk ./ttcn/LibIts/

echo -e "*****************************\n* Change user in cfg files\n*****************************\n"
. /home/etsi/devenv.bash
cd ${HOME}/dev/TTF011_Its/scripts || exit 1
./update_user_name.sh || exit 1

echo -e "*****************************\n* Build Mec test suite\n*****************************\n"
export ATS=AtsMec
make

cd ./etc/AtsMec
ln -sf AtsMec_Sandbox.cf_ AtsMec.cfg

echo -e "*****************************\n* Change sudo in command line\n*****************************\n"
cd /home/etsi/dev/TTF011_Its/scripts
sed --in-place 's/sudo/echo "etsi" \| sudo -S/' ./run_mtc.bash
sed --in-place 's/sudo/echo "etsi" \| sudo -S/' ./run_ptcs.bash

cd /home/etsi/dev/TTF_T012_Mec
