/*
 * generated by Xtext
 */
package de.ugoe.cs.swe.formatting

import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter
import org.eclipse.xtext.formatting.impl.FormattingConfig
import de.ugoe.cs.swe.services.TTCN3GrammarAccess
import com.google.inject.Inject

// import com.google.inject.Inject;
// import de.ugoe.cs.swe.services.TTCN3GrammarAccess

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#formatting
 * on how and when to use it 
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
class TTCN3Formatter extends AbstractDeclarativeFormatter {

    @Inject extension TTCN3GrammarAccess
	
	override protected void configureFormatting(FormattingConfig c) {
// It's usually a good idea to activate the following three statements.
// They will add and preserve newlines around comments
//		c.setLinewrap(0, 1, 2).before(SL_COMMENTRule)
//		c.setLinewrap(0, 1, 2).before(ML_COMMENTRule)
//		c.setLinewrap(0, 1, 1).after(ML_COMMENTRule)
        for(pair: findKeywordPairs('{', '}')) {
            c.setIndentation(pair.first, pair.second)
            c.setLinewrap(1).after(pair.first)
            c.setLinewrap(1).before(pair.second)
            c.setLinewrap(1).after(pair.second)
        }
        
        
        for(keyword: findKeywords('type')) {
            c.setLinewrap().before(keyword)
            c.setLinewrap().after(keyword)
        }
        
        c.setLinewrap.before(functionStatementRule)
        c.setLinewrap.after(componentDefListRule)
        

        for (r: findRuleCalls(structFieldDefRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(TYPEDEFKEYWORDRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(FUNCTIONKEYWORDRule)) {
            c.setLinewrap(2,2,2).before(r)
        }

        for (r: findRuleCalls(TESTCASEKEYWORDRule)) {
            c.setLinewrap(2,2,2).before(r)
        }

        for (r: findRuleCalls(CONSTKEYWORDRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(TEMPLATEKEYWORDRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(altGuardListRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(SEMICOLONRule)) {
            //c.setLinewrap(0,1,1).after(r)
//            c.setLinewrap.after(r)
        }

        for (r: findRuleCalls(DOTRule)) {
            c.setNoSpace.before(r)
            c.setNoSpace.after(r)
        }

        for (r: findRuleCalls(SQUAREOPENRule)) {
//            c.setNoSpace.before(r)
            c.setNoSpace.after(r)
        }

        for (r: findRuleCalls(SQUARECLOSERule)) {
            c.setNoSpace.before(r)
            c.setNoSpace.after(r)
        }

        for (r: findRuleCalls(moduleDefinitionRule)) {
            c.setLinewrap.before(r)
            c.setLinewrap.after(r)
        }

        for (r: findRuleCalls(componentElementDefRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(messageListRule)) {
            c.setLinewrap.before(r)
        }

        for (r: findRuleCalls(functionFormalParListRule)) {
            c.setLinewrap.before(r)
//            c.setNoLinewrap.before(r)
            c.setIndentationIncrement.before(r)
            c.setIndentationDecrement.after(r)
        }

        
        for (r: findRuleCalls(LBRACKETRule)) {
            c.setLinewrap.after(r)
            c.setIndentationIncrement.after(r)
        }



        for (r: findRuleCalls(RBRACKETRule)) {
            c.setIndentationDecrement.before(r)
            c.setLinewrap.before(r)
            c.setLinewrap(2,2,2).after(r)
        }


        for(keyword: findKeywords('group')) {
//            c.setNoLinewrap().before(keyword)
//            c.setLinewrap().after(keyword)
        }
        
        for(keyword: findKeywords('port')) {
//            c.setNoLinewrap().before(keyword)
//            c.setLinewrap().after(keyword)
        }
        
        
	}
}
