/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.T3Q;

import com.google.common.base.Stopwatch;
import de.ugoe.cs.swe.T3Q.TTCN3Output;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class Analyzer
implements Callable<TTCN3Output> {
    private final Resource resource;
    private final LoggingInterface logger;
    public static boolean printUnresolvedObjects = false;

    public Analyzer(Resource resource, LoggingInterface logger) {
        this.resource = resource;
        this.logger = logger;
    }

    private TTCN3Output analyze() {
        TTCN3Output output = new TTCN3Output(this.resource);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        EcoreUtil.resolveAll((Resource)this.resource);
        EObject model = (EObject)this.resource.getContents().get(0);
        Diagnostic diagnostic = null;
        diagnostic = Diagnostician.INSTANCE.validate(model);
        for (Diagnostic d : diagnostic.getChildren()) {
            if (!(d instanceof FeatureBasedDiagnostic)) continue;
            output.getOutput().add((FeatureBasedDiagnostic)d);
        }
        if (printUnresolvedObjects) {
            for (Diagnostic d : this.resource.getErrors()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), d.getLine(), d.getLine(), LoggingInterface.MessageClass.UNIVERSAL, d.getMessage());
            }
            for (Diagnostic d : this.resource.getWarnings()) {
                TTCN3StatisticsProvider.getInstance().incrementCountUniversal();
                this.logger.logInformation(this.resource.getURI(), d.getLine(), d.getLine(), LoggingInterface.MessageClass.UNIVERSAL, d.getMessage());
            }
        }
        stopwatch.stop();
        System.out.println("Analyzing  file: " + this.resource.getURI().devicePath().replaceFirst("///", "") + '\n' + "       ...done in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms (" + MiscTools.secondsToString(stopwatch.elapsed(TimeUnit.SECONDS)) + " minutes).");
        return output;
    }

    @Override
    public TTCN3Output call() throws Exception {
        return this.analyze();
    }
}

