#!/bin/bash

# Debug mode
#set -e
#set -vx

# Usage: sudo ./merge_mec_project.bash
# TODO Use git clone in temporary directory

OLDPWD=`pwd`

# Storing path
VAGRANT_DIR=~/tmp
if [ ! -d ${VAGRANT_DIR} ]
then
  exit -1
else
  VAGRANT_DIR=${VAGRANT_DIR}/to_be_merged
  if [ -d ${VAGRANT_DIR} ]
  then
      rm -f ${VAGRANT_DIR}/*
  else
      mkdir ${VAGRANT_DIR}
  fi
fi
chmod 775 ${VAGRANT_DIR}

# Execution path
RUN_PATH="${0%/*}"
PATH_DEV_MEC=`pwd`/../../etsi_mec
SRC_MEC_PATH=~/dev/STF569_Mec

# Update ETSI Framework files
echo 'Merging ETSI Framework files'
FWK_SRC_PATH=${SRC_MEC_PATH}/ccsrc
FWK_DST_PATH=${PATH_DEV_MEC}/framework
FWK_DIR_LIST_HH=`find ${FWK_SRC_PATH}/Protocols/ -name "*.h*" -type f`
for i in ${FWK_DIR_LIST_HH}
do
  BN=`basename $i`
  s1=`sha256sum -b $i | cut -d' ' -f1`
  s2=`sha256sum -b ${FWK_DST_PATH}/include/${BN} | cut -d' ' -f1`
  if [ "${s1}" != "${s2}" ]
  then
      cp ${FWK_DST_PATH}/include/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/include/${BN}~ ]
      then
        rm ${FWK_DST_PATH}/include/${BN}~
      fi
  fi
done
FWK_DIR_LIST_CC=`find ${FWK_SRC_PATH}/Protocols/ -name "*.c*" -type f`
for i in ${FWK_DIR_LIST_CC}
do
  BN=`basename $i`
  s1=`sha256sum -b $i | cut -d' ' -f1`
  s2=`sha256sum -b ${FWK_DST_PATH}/src/${BN} | cut -d' ' -f1`
  if [ "${s1}" != "${s2}" ]
  then
      cp ${FWK_DST_PATH}/src/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/src/${BN}~ ]
      then
        rm ${FWK_DST_PATH}/src/${BN}~
      fi
  fi
done
FWK_DIR_LIST_Y=`find ${FWK_SRC_PATH}/Protocols/ -name "*.y" -type f`
for i in ${FWK_DIR_LIST_Y}
do
  BN=`basename $i`
  s1=`sha256sum -b $i | cut -d' ' -f1`
  s2=`sha256sum -b ${FWK_DST_PATH}/src/${BN} | cut -d' ' -f1`
  if [ "${s1}" != "${s2}" ]
  then
      cp ${FWK_DST_PATH}/src/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/src/${BN}~ ]
      then
        rm ${FWK_DST_PATH}/src/${BN}~
      fi
  fi
done
FWK_DIR_LIST_L=`find ${FWK_SRC_PATH}/Protocols/ -name "*.l" -type f`
for i in ${FWK_DIR_LIST_L}
do
  BN=`basename $i`
  s1=`sha256sum -b $i | cut -d' ' -f1`
  s2=`sha256sum -b ${FWK_DST_PATH}/src/${BN} | cut -d' ' -f1`
  if [ "${s1}" != "${s2}" ]
  then
      cp ${FWK_DST_PATH}/src/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/src/${BN}~ ]
      then
        rm ${FWK_DST_PATH}/src/${BN}~
      fi
  fi
done
FWK_DIR_LIST_HH=`find ${FWK_SRC_PATH}/Framework/ -name "*.h*" -type f`
FWK_DIR_LIST_CC=`find ${FWK_SRC_PATH}/Framework/ -name "*.c*" -type f`
for i in ${FWK_DIR_LIST_HH}
do
    BN=`basename $i`
    s1=`sha256sum -b $i | cut -d' ' -f1`
    s2=`sha256sum -b ${FWK_DST_PATH}/include/${BN} | cut -d' ' -f1`
    if [ "${s1}" != "${s2}" ]
    then
      cp ${FWK_DST_PATH}/include/${BN} ${VAGRANT_DIR} 
      if [ -f ${FWK_DST_PATH}/include/${BN}~ ]
      then
          rm ${FWK_DST_PATH}/include/${BN}~
      fi
    fi
done
for i in ${FWK_DIR_LIST_CC}
do
    BN=`basename $i`
    s1=`sha256sum -b $i | cut -d' ' -f1`
    s2=`sha256sum -b ${FWK_DST_PATH}/src/${BN} | cut -d' ' -f1`
    if [ "${s1}" != "${s2}" ]
    then
      cp ${FWK_DST_PATH}/src/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/src/${BN}~ ]
      then
          rm ${FWK_DST_PATH}/src/${BN}~
      fi
    fi
done
FWK_DIR_LIST_HH=`find ${FWK_SRC_PATH}/loggers/ -name "*.h*" -type f`
for i in ${FWK_DIR_LIST_HH}
do
    BN=`basename $i`
    s1=`sha256sum -b $i | cut -d' ' -f1`
    s2=`sha256sum -b ${FWK_DST_PATH}/include/${BN} | cut -d' ' -f1`
    if [ "${s1}" != "${s2}" ]
    then
      cp ${FWK_DST_PATH}/include/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/include/${BN}~ ]
      then
          rm ${FWK_DST_PATH}/include/${BN}~
      fi
    fi
done
FWK_DIR_LIST_CC=`find ${FWK_SRC_PATH}/loggers/ -name "*.c*" -type f`
for i in ${FWK_DIR_LIST_CC}
do
    BN=`basename $i`
    s1=`sha256sum -b $i | cut -d' ' -f1`
    s2=`sha256sum -b ${FWK_DST_PATH}/src/${BN} | cut -d' ' -f1`
    if [ "${s1}" != "${s2}" ]
    then
      cp ${FWK_DST_PATH}/src/${BN} ${VAGRANT_DIR}
      if [ -f ${FWK_DST_PATH}/src/${BN}~ ]
      then
          rm ${FWK_DST_PATH}/src/${BN}~
      fi
    fi
done
# Update ATS TTCN-3 files
echo 'Update TTCN-3 files'
TTCN_3_ORG_PATH=${SRC_MEC_PATH}/ttcn
TTCN_3_DST_PATH=${PATH_DEV_MEC}/src
TTCN_3_ATS_LIST='AtsNg112 LibMec LibMec/LocationAPI LibMec/UEidentityAPI LibMec/RnisAPI LibMec/BwManagementAPI LibHttp LibCommon'
for i in ${TTCN_3_ATS_LIST}
do
    # TTCN-3 files
    LIST_TTCN_FILES=`find ${TTCN_3_ORG_PATH}/$i -name "*.ttcn" -type f`
    for j in ${LIST_TTCN_FILES}
    do
      BN=`basename $j`
      s1=`sha256sum -b $j | cut -d' ' -f1`
      s2=`sha256sum -b ${TTCN_3_DST_PATH}/$i/ttcn/${BN} | cut -d' ' -f1`
      if [ "${s1}" != "${s2}" ]
      then
          cp ${TTCN_3_DST_PATH}/$i/ttcn/${BN} ${VAGRANT_DIR}
      fi
    done
    # JSON files
    LIST_TTCN_FILES=`find ${TTCN_3_ORG_PATH}/$i -name "*.json" -type f`
    for j in ${LIST_TTCN_FILES}
    do
      BN=`basename $j`
      s1=`sha256sum -b $j | cut -d' ' -f1`
      s2=`sha256sum -b ${TTCN_3_DST_PATH}/$i/ttcn/${BN} | cut -d' ' -f1`
      if [ "${s1}" != "${s2}" ]
      then
          cp ${TTCN_3_DST_PATH}/$i/json/${BN} ${VAGRANT_DIR}
      fi
    done
    # Other files
    if [ -f ${SRC_MEC_PATH}/docs/$i/o2.cfg ]
    then
      s1=`sha256sum -b ${PATH_DEV_MEC}/src/$i/docs/o2.cfg | cut -d' ' -f1`
      s2=`sha256sum -b ${SRC_MEC_PATH}/docs/$i/o2.cfg | cut -d' ' -f1`
      if [ "${s1}" != "${s2}" ]
      then
            mkdir -p ${VAGRANT_DIR}/docs/$i
          cp ${PATH_DEV_MEC}/src/$i/docs/o2.cfg ${VAGRANT_DIR}/docs/$i
      fi
    fi
    if [ -f ${SRC_MEC_PATH}/etc/$i/$i.cfg ]
    then
      s1=`sha256sum -b ${PATH_DEV_MEC}/src/$i/etc/$i.cfg | cut -d' ' -f1`
      s2=`sha256sum -b ${SRC_MEC_PATH}/etc/$i/$i.cfg | cut -d' ' -f1`
      if [ "${s1}" != "${s2}" ]
      then
            mkdir -p ${VAGRANT_DIR}/etc/$i
          cp ${PATH_DEV_MEC}/src/$i/etc/%i.cfg ${VAGRANT_DIR}/etc/$i
      fi
    fi
done

TTCN_3_LIB_LIST='TestCodec'
for i in ${TTCN_3_LIB_LIST}
do
    LIST_TTCN_FILES=`find ${TTCN_3_ORG_PATH}/$i -name "*.ttcn" -type f`
    for j in ${LIST_TTCN_FILES}
    do
      BN=`basename $j`
      s1=`sha256sum -b $j | cut -d' ' -f1`
      s2=`sha256sum -b ${TTCN_3_DST_PATH}/$i/ttcn/${BN} | cut -d' ' -f1`
      if [ "${s1}" != "${s2}" ]
      then
          cp ${TTCN_3_DST_PATH}/$i/ttcn/${BN} ${VAGRANT_DIR}
          rm ${TTCN_3_DST_PATH}/$i/ttcn/${BN}~
      fi
    done
done


LIST_FILES=`find ${PATH_DEV_MEC} -name "*~" -type f`
for i in ${LIST_FILES}
do
    BN=$i
    BN=${BN:: -1} # Remove the last character
    cp ${BN} ${VAGRANT_DIR}
    rm $i
done

chmod -R 664 ${VAGRANT_DIR}/*.*
exit 0

