#!/bin/bash
# Copyright ETSI 2018
# See: https://forge.etsi.org/etsi-forge-copyright-statement.txt

#set -e
#set -vx

DOCKER_FILE=./docker/Dockerfile
if [ -f ${DOCKER_FILE} ]
then
    docker rm --force stf549_ng112
    docker build --tag stf549_ng112 --force-rm -f ${DOCKER_FILE} .
    if [ "$?" != "0" ]
    then
        echo "Docker build failed: $?"
        exit -1
    fi
    docker image ls -a
    docker inspect stf549_ng112:latest
    if [ "$?" != "0" ]
    then
        echo "Docker inspect failed: $?"
        exit -2
    fi
else
    exit -3
fi

# That's all Floks
exit 0
