# Simulate MEC devices using Pandas database

import os
import pandas as pd
from datetime import datetime, time

class mec_database:
    """
    TODO
    """
    # Private properties
    __path__ = '' # To be updated according to the local settings
    __subscribers__ = None
    __registered_list__ = None
    __zones__ = None
    __ue_information_list__ = None
    __access_point_list__ = None
    __location_info__ = None
    __cells__ = None
    __associated__ = None
    __subscribions__ = None
    __transport_info__ = None
    __security__ = None
    __traffic_rules__ = None

    def __init__(self):
        """ Default ctor: Open Pandas database. """
        self.__path__ = os.path.join(os.getcwd(), 'data')
        print('==> self.__path__=', self.__path__)
        self.__zones__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'zones.csv'), index_col = 'zoneId'))
        self.__subscribers__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'subscribers.csv'), index_col = 'address'))
        self.__ue_information_list__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'ue_information_list.csv'), index_col = ['appInst', 'ueTag']))
        self.__access_point_list__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'access_point_list.csv'), index_col = 'accessPointId'))
        self.__location_info__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'location_info.csv'), index_col = 'accessPointId'))
        self.__cells__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'cells.csv'), encoding = 'utf-8', index_col = 'cellId'))
        self.__associated__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'associated.csv'), encoding = 'utf-8', index_col = 'cellId'))
        self.__subscriptions__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'subscriptions.csv'), encoding = 'utf-8', index_col = 'subscription_id'))
        self.__transport_info__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'transport_info.csv'), encoding = 'utf-8', index_col = 'transportId'))
        self.__security__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'security.csv'), encoding = 'utf-8', index_col = 'id'))
        self.__traffic_rules__ = pd.DataFrame(pd.read_csv(os.path.join(self.__path__, 'traffic_rules.csv'), encoding = 'utf-8', index_col = 'trafficRuleId'))
#        self.dump()
    # End of __init__

    def dump(self):
        """ Dump database contents. For debug purpose only. """
        print("Subscribers: ", self.__subscribers__.head())
        print("Zones: ", self.__zones__.head())
        print("UEinformation", self.__ue_information_list__.head())
        print("AccessPoint: ", self.__access_point_list__.head())
        print("LocationInfo: ", self.__location_info__.head())
        print("Cells: ", self.__cells__.head())
        print("Associated: ", self.__associated__.head())
        print("subscriptions: ", self.__subscriptions__.head())
        print("transport_info: ", self.__transport_info__.head())
        print("security: ", self.__security__.head())
        print("traffic_rules: ", self.__traffic_rules__.head())
    # End of dump

    def __to_accessPoint__(self, p_access_point, p_location):
        """
        Build an AccessPointLocation Json message.
        Keyword arguments:
        -- p_access_point: Access point identifier
        -- p_location    : Access point geographical location
        """
        print(">>> __to_accessPoint__: ", p_access_point)
        print("__to_accessPoint__: location= ", p_location['latitude'][0])
        i = 0.0
        resp = "{\"accessPointId\": \"" + p_access_point[0] + \
                 "\",\"locationInfo\": {\"latitude\": " + str(p_location['latitude'][0]) + ",\"longitude\": " + str(p_location['longitude'][0]) + ",\"altitude\": " + str(p_location['altitude'][0]) + ",\"accuracy\": " + str(p_location['accuracy'][0]) + "}," \
                 "\"connectionType\": \"" + p_access_point[2] + "\"," \
                 "\"operationStatus\": \"" + p_access_point[3] + "\"," \
                 "\"numberOfUsers\": " + str(p_access_point[4]) + "," \
                 "\"interestRealm\": \"" + p_access_point[5] + "\"," \
                 "\"resourceURL\": \"" + p_access_point[6] + "\"" \
                 "}"
        print("__to_accessPoint__: ", resp)
        return resp
    # End of __to_accessPoint__

    def __to_zone__(self, p_zone):
        """
        Build a Zones Json message.
        Keyword arguments:
        -- p_zone: Zone description
        """
        print(">>> __to_zone__: ", p_zone)
        resp = "{\t\"zoneId\": \"" + p_zone[0] + "\",\t\"numberOfAccessPoints\": \"" + str(p_zone[1]) + "\",\t\"numberOfUnserviceableAccessPoints\": \"" + str(p_zone[2]) + "\",\t\"numberOfUsers\": \"" + str(p_zone[3]) + "\",\t\"resourceURL\": \"" + p_zone[4] + "\"}"
        print("__to_zone__: ", resp)
        return resp
    # End of __to_zone__

    def __to_userInfo__(self, p_subscriber, p_location = None, p_contextLocationInfo = None):
        """ Build a UserInfo Json message. """
        print(">>> __to_userInfo__: ", p_subscriber)
        resp = "{\t\"address\": \"" + p_subscriber[0] + "\",\t\"accessPointId\": \"" + p_subscriber[2] + "\",\t\"zoneId\": \"" + p_subscriber[3] + "\",\t\"resourceURL\": \"" + p_subscriber[4] + "\"}"
        print("__to_userInfo__: ", resp)
        return resp
    # End of __to_userInfo__

    def __to_ueIdentityTagInfo__(self, p_ue_identity_tag, p_ue):
        """ Build a ueIdentityTagInfo Json message. """
        print(">>> __to_ueIdentityTagInfo__: ", p_ue_identity_tag, ", ", p_ue)
        resp = "{\t\"ueIdentityTagInfo\": {\t\"ueIdentityTags\": [{\t\"ueIdentityTag\": \"" + p_ue_identity_tag + "\",\t\"state\": \"" + p_ue[1] + "\"}]}}"
        print("__to_ueIdentityTagInfo__: ", resp)
        return resp
    # End of __to_ueIdentityTagInfo__

    def __to_subscriptions__(self, p_subscription):
        """ Build the userTrackingSubscription response """
        print(">>> __to_subscriptions__: ", p_subscription)
        resp = "\t{\"userTrackingSubscription\": {\t\"clientCorrelator\": \"" + p_subscription[1] + "\",\t\"callbackReference\": {\"notifyURL\": \"" + p_subscription[3] + "\"},\t\"address\": \"" + p_subscription[2] + "\",\t\"userEventCriteria\" : ["
        resp += "\"" + p_subscription[4][0] + "\""
        i = 1
        while i < len(p_subscription[4]):
            resp += ",\"" + p_subscription[4][i] + "\""
            i += 1
        # End of 'while' statement
        resp += "],\t\"resourceURL\":\"" + p_subscription[5] + "\"\t}}"
        print("__to_subscriptions__: ", resp)
        return resp
    # End of __to_subscriptions__

    def __to_transport_info__(self, p_transport_info):
        """
        Build a TransportInfo Json message.
        Keyword arguments:
        -- p_transport_info: TransportInfo description
        """
        print(">>> __to_transport_info__: ", p_transport_info)
#        print("__to_transport_info__: security id: ", p_transport_info[7])
        resp = "{{\t\"id\": \"TransId12345\",\"name\": \"REST\",\"description\": \"REST API\",\"type\": \"REST_HTTP\",\"protocol\": \"HTTP\",\"version\": \"2.0\",\"endpoint\": {},\"security\": {\"oAuth2Info\": {\"grantTypes\": [\"OAUTH2_CLIENT_CREDENTIALS\"],\"tokenEndpoint\": \"/meMp1/security/TokenEndPoint\"}\"},\"implSpecificInfo\": {}}"
#        resp = None
#        try:
#            security = self.__security__.loc[self.__security__['id'] == p_transport_info[7]]
#            print("__to_transport_info__: security= ", security)
#
#            resp = "{\t\"id\": \"" + p_transport_info[0] + "\",\t\"name\": \"" + p_transport_info[1] + "\",\t\"description\": \"" + p_transport_info[2] + "\",\t\"type\": \"" + p_transport_info[3] + "\",\t\"protocol\": \"" + p_transport_info[4] + "\",\t\"version\": \"" + str(p_transport_info[5]) + "\",\t\"endpoint\": \"" + p_transport_info[6] + "\",\t\"security\": \"" + security + "\",\t\"implSpecificInfo\": \"" + p_transport_info[8] + "\"}"
#            print("__to_transport_info__: ", resp)
#        except KeyError:
#            print("__to_transport_info__: No security entry")
        return resp
    # End of method __to_transport_info__

    def __to_traffic_rule__(self, p_traffic_rule):
        """
        Build a TrafficRule Json message.
        Keyword arguments:
        -- p_traffic_rule: TrafficRule description
        """
        print(">>> __to_traffic_rule__: ", p_traffic_rule)
        resp = "{\"trafficRuleId\": \"TrafficRule1\",\"filterType\": \"FLOW\",\"priority\": 1,\"trafficFilter\": [{\"srcAddress\": [\"192.168.1.1\"],\"dstAddress\": [\"192.168.1.1\"],\"srcPort\": [\"8080\"],\"dstPort\": [\"8080\"],\"protocol\": [  \"?\"],\"token\": [\"?\"],\"srcTunnelAddress\": [\"?\"],\"tgtTunnelAddress\": [\"?\"],\"srcTunnelPort\": [\"?\"],\"dstTunnelPort\": [\"?\"],\"qCI\": 1,\"dSCP\": 0,\"tC\": 1}],\"action\": \"DROP\",\"dstInterface\": {\"interfaceType\": \"TUNNEL\",\"tunnelInfo\": {\"tunnelType\": \"GTP_U\",\"tunnelDstAddress\": \"?\",\"tunnelSrcAddress\": \"?\"},\"srcMacAddress\": \"02-00-00-00-00-00\",\"dstMacAddress\": \"02-00-00-00-00-00\",\"dstIpAddress\":\"192.0.2.0\"},\"state\":\"ACTIVE\"}"
#        resp = None
#        try:
#            resp = "{\t\"id\": \"" + p_transport_info[0] + "\",\t\"name\": \"" + p_transport_info[1] + "\",\t\"description\": \"" + p_transport_info[2] + "\",\t\"type\": \"" + p_transport_info[3] + "\",\t\"protocol\": \"" + p_transport_info[4] + "\",\t\"version\": \"" + str(p_transport_info[5]) + "\",\t\"endpoint\": \"" + p_transport_info[6] + "\",\t\"security\": \"" + security + "\",\t\"implSpecificInfo\": \"" + p_transport_info[8] + "\"}"
#            print("__to_transport_info__: ", resp)
#        except KeyError:
#            print("__to_transport_info__: No security entry")
        return resp
    # End of method __to_transport_info__

    def __to_rni_subscriptions__(self, p_subscription, p_subscription_type):
        """ Build a RNI subscription Json message. """
        print(">>> __to_rni_subscriptions__")
        resp = "{\"CellChangeSubscription\": {\"subscriptionType\": \"" + p_subscription_type + "\",\"callbackReference\": \"http://meAppClient.example.com/rni/v2/notifications/cell_change/77777\", \"_links\": {\"self\": \"http://example.com/exampleAPI/rni/v2/subscriptions\"}, \"filterCriteria\": {\"appInsId\": \"01\", \"associateId\": [{\"type\": \"1\", \"value\": \"192.0.0.2\"}], \"plmn\": {\"mcc\": \"01\", \"mnc\": \"001\"}, \"cellId\": \"0x800000A\", \"hoStatus\": \"COMPLETED\"}, \"expiryDeadline\": {\"seconds\": 1577836800, \"nanoSeconds\": 0}}}"
#        resp = "{\"CellChangeSubscription\": {\"callbackReference\": " + p_subscription['callbackReference'] + ", \"_links\": {\"self\": " + p_subscription['_links'] + "}, \"filterCriteria\": {\"appInsId\": " + p_subscription['filterCriteria']['appInsId'] + ", \"associateId\": [{\"type\": " + p_subscription['filterCriteria']['associateId']['type'] + ", \"value\": " + p_subscription['filterCriteria']['associateId']['value'] + "}], \"plmn\": {\"mcc\": " +  p_subscription['filterCriteria']['plmn']['mcc'] + ", \"mnc\": " + p_subscription['filterCriteria']['plmn']['mnc'] + "}, \"cellId\": [" + p_subscription['filterCriteria']['cellId'] + "], 'hoStatus': " + p_subscription['filterCriteria']['hoStatus'] + "}, \"expiryDeadline\": {\"seconds\": " + p_subscription['expiryDeadline']['seconds'] + ", \"nanoSeconds\": \"" + p_subscription['expiryDeadline']['nanoSeconds'] + "}}"
        print("__to_rni_subscriptions__: ", resp)
        return resp
    # end of __to_rni_subscriptions__

    def getSubscriberList(self, p_uri):
        """ Build a SubscriberList Json message. """
        print(">>> getSubscriberList")
        resp = None
        try:
            resp = "{\"userList\": {\t\"user\": [\t"
            for r in self.__subscribers__.itertuples():
                t = tuple(r)
                resp += self.__to_userInfo__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t],\"resourceURL\": \"http://example.com" + p_uri + "\"}}"
            print("getSubscriberList: ", resp)
        except KeyError:
            print("getSubscriberList: No subscriber list")
        return resp
    # End of getSubscriberList

    def getZoneList(self, p_uri):
        print(">>> getZoneList")
        resp = None
        try:
            resp = "{\"zoneList\": {\t\"zone\": [\t"
            for r in self.__zones__.itertuples():
                t = tuple(r)
                resp += self.__to_zone__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t],\"resourceURL\": \"http://example.com" + p_uri + "\"}}"
            print("getZoneList: ", resp)
        except KeyError:
            print("getZoneList: No zones list")
        return resp
    # End of getZoneList

    def getAccessPointList(self, p_zone_id, p_uri):
        print(">>> getAccessPointList")
        resp = None
        try:
            r = self.__access_point_list__.loc[self.__access_point_list__['zoneId'] == p_zone_id]
            print("getAccessPointList: r= ", r)
            resp = "{\"accessPointList\": {\t\"zoneId\": \"" + p_zone_id + "\",\t\"accessPoint\": [\t"
            for i in r.itertuples():
                t = tuple(i)
                location = self.__location_info__.loc[[t[0]]]
                resp += self.__to_accessPoint__(t, location) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t],\"resourceURL\": \"http://example.com" + p_uri + "\"}}"
            print("getAccessPointList: ", resp)
        except KeyError:
            print("getAccessPointList: No access point list")
        return resp
    # End of method getAccessPointList

    def getSubscriptionLinkList(self, p_uri):
        s = p_uri.split('?')
        return "{\"SubscriptionLinkList\": {\"_links\": {\"self\": \"http://example.com" + s[0] + "\"},\"subscription\": [{\"href\": \"http://meAppClient.example.com/rni/v1/notifications/cell_change/77777\",\"subscriptionType\": \"CELL_CHANGE\"},{\"href\": \"http://meAppClient.example.com/rni/v1/notifications/MeasTa/77777\",\"subscriptionType\": \"MEAS_TIMING_ADVANCE\"}]}}"
    # End of method getSubscriptionLinkList

    def getMp1TransportInfoList(self):
        print(">>> getMp1TransportInfoList")
        resp = None
        try:
            resp = "{\"transportInfoList\": [\t"
            for r in self.__transport_info__.itertuples():
                t = tuple(r)
                resp += self.__to_transport_info__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t]}"
            print("getMp1TransportInfoList: ", resp)
        except KeyError:
            print("getMp1TransportInfoList: No transportInfo list")
        return resp
    # End of method getMp1TransportInfo

    def getMp1TrafficRulesList(self):
        print(">>> getMp1TrafficRulesList")
        resp = None
        try:
            resp = "{\"TrafficRulesList\": [\t"
            for r in self.__traffic_rules__.itertuples():
                t = tuple(r)
                resp += self.__to_traffic_rule__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t]}"
            print("getMp1TrafficRulesList: ", resp)
        except KeyError:
            print("getMp1TrafficRulesList: No TrafficRules list")
        return resp
    # End of method getMp1TrafficRules

    def getMp1TrafficRule(self):
        print(">>> getMp1TrafficRule")
        resp = None
        try:
            resp = "{\"TrafficRule\": [\t"
            for r in self.__traffic_rule__.itertuples():
                t = tuple(r)
                resp += self.__to_traffic_rule__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t]}"
            print("getMp1TrafficRule: ", resp)
        except KeyError:
            print("getMp1TrafficRule: No TrafficRules list")
        return resp
    # End of method getMp1TrafficRules

    def getSubscriberFromAddress(self, p_ue_address):
        print(">>> getSubscriberFromAddress: ", p_ue_address)
        result = None
        try:
            r = tuple(self.__subscribers__.loc[[p_ue_address]].itertuples(index=True, name=''))[0]
            print("getSubscriberFromAddress: Find subscriber with address ", p_ue_address, ": ", r)
            result = "{\"userInfo\": " + self.__to_userInfo__(r) + "}"
        except KeyError:
            print("getSubscriberFromAddress: No subscriber with address ", p_ue_address)
        return result
    # End of method getSubscriberFromAddress

    def getSubscriberFromZoneId(self, p_zone_id, p_uri):
        print(">>> getSubscriberFromZoneId: ", p_zone_id)
        resp = None
        try:
            r = self.__subscribers__.loc[self.__subscribers__['zoneId'] == p_zone_id]
            resp = "{\"userList\": {\t\"user\": [\t"
            for i in r.itertuples():
                t = tuple(i)
                resp += self.__to_userInfo__(t) + ","
            # En of 'for' statement
            resp = resp[: len(resp) - 1]
            resp += "\t],\"resourceURL\": \"http://example.com" + p_uri + "\"}}"
            print("getSubscriberFromZoneId: ", resp)
        except KeyError:
            print("getSubscriberFromZoneId: No subscriber in zone ", p_zone_id)
        return resp
    # End of method getSubscriberFromAddress

    def getUEidentityTagInfo(self, p_app_inst, p_ue_identity_tag):
        print(">>> getUEidentityTagInfo: ", p_app_inst, ", ", p_ue_identity_tag)
        resp = None
        try:
            r = tuple(self.__ue_information_list__.loc[p_app_inst, p_ue_identity_tag])
            print("getUEidentityTagInfo: Find zoneId for appInst: ", p_app_inst, ", r= ", r)
            resp = self.__to_ueIdentityTagInfo__(p_ue_identity_tag, r)
            print("getUEidentityTagInfo: ", resp)
        except KeyError:
            print("getUEidentityTagInfo: No UE for appInst ", p_app_inst)
        return resp
    # End of method getUEidentityTagInfo

    def getBwAllocationAppInst(self, p_app_inst, p_ue_identity_tag):
        print(">>> getBwAllocationAppInst: ", p_app_inst, ", ", p_ue_identity_tag)
        resp = None
        resp = "{\"bwInfo\": {\"timeStamp\": {\"seconds\": 0,\"nanoSeconds\": 0},\"appInsId\": \"string\",\"requestType\": \"APPLICATION_SPECIFIC_BW_ALLOCATION\",\"sessionFilter\": [{\"sourceIp\": \"string\",\"sourcePort\": [\"string\"],\"dstAddress\": \"string\",\"dstPort\": [\"string\"],\"protocol\": \"string\"}],\"fixedBWPriority\": \"not defined in the present document\",\"fixedAllocation\": \"string\",\"allocationDirection\": \"00 = Downlink (towards the UE)\"}}"
        print("getBwAllocationAppInst: ", resp)
        return resp
    # End of method getBwAllocationAppInst

    def registerUEidentity(self, p_app_inst, p_json_msg):
        print(">>> registerUEidentity", p_json_msg)
        if p_json_msg["state"] != "REGISTERED" and p_json_msg["state"] != "UNREGISTERED":
            return '400 Bad Request'
        resp = None
        try:
            # Check the record exists
            r = tuple(self.__ue_information_list__.loc[p_app_inst, p_json_msg["ueIdentityTag"]])
            print("registerUEidentity: Find zoneId for appInst: ", p_app_inst, ", r= ", r)
            if self.__ue_information_list__.loc[p_app_inst, p_json_msg["ueIdentityTag"]]['state'] == 'INVALID_STATE':
                return '412 Precondition Failed'
            self.__ue_information_list__.loc[p_app_inst, p_json_msg["ueIdentityTag"]]['state'] = p_json_msg["state"]
            l = (p_json_msg["ueIdentityTag"], p_json_msg["state"])
            resp = self.__to_ueIdentityTagInfo__(p_json_msg["ueIdentityTag"], l)
        except KeyError:
            print("registerUEidentity: No appInst/UE ", p_app_inst, "/", p_ue_identity_tag)
        return resp
    # End of method registerUEidentity

    def registerSubscription(self, p_json_msg, p_uri):
        print(">>> registerSubscription: ", p_json_msg, "/", p_uri)
        resp = None
        subscription_id = "subscription" + p_json_msg["clientCorrelator"]
        try:
            # Check the record does not exist
            self.__subscriptions__.loc[self.__subscriptions__['subscription_id'] == subscription_id]
            print("registerSubscription: There is a subscription for ", subscription_id)
        except KeyError:
            #print("registerSubscription: Add new row in subscription")
            resource_url = "http://example.com" + p_uri + "/" + subscription_id
            row = pd.Series({ 'subscription_id': subscription_id, 'corr_id': p_json_msg["clientCorrelator"], 'address': p_json_msg["address"], 'callback': p_json_msg["callbackReference"]["notifyURL"], 'ue_event_criteria': p_json_msg["userEventCriteria"], 'resourceURL': resource_url })
            #print("registerSubscription: row: ", row)
            self.__subscriptions__ = self.__subscriptions__.append(row, ignore_index=True).reindex()
            #print("registerSubscription: ", self.__subscriptions__.head())
            r = tuple(self.__subscriptions__.loc[self.__subscriptions__['subscription_id'] == subscription_id].to_records())
            #print("registerSubscription: New added row: ", r[0])
            resp = self.__to_subscriptions__(r[0])
        return resp
    # End of registerSubscription

    def unregisterSubscription(self, p_subscription_id):
        print(">>> unregisterSubscription: ", p_subscription_id)
        resp = None
        try:
            # Check the record exists
            r = self.__subscriptions__.loc[self.__subscriptions__['subscription_id'] == p_subscription_id]
            t = tuple(r.to_records())
            print("unregisterSubscription: Find row: ", t)
            resp = self.__to_subscriptions__(t[0])
            # Remove it
            self.__subscriptions__.drop(r.index)
        except KeyError:
            print("unregisterSubscription: No subscription for ", p_subscription_id)
        return resp
    # End of unregisterSubscription

    def registerRniSubscription(self, p_json_msg):
        print(">>> registerRniSubscription: ", p_json_msg)
        resp = None
        if p_json_msg['subscriptionType'] == 'CELL_CHANGE':
            resp = self.__to_rni_subscriptions__(p_json_msg, 'CELL_CHANGE')
        return resp
    # End of registerRniSubscription

    def getRabInfo(self, p_cell_id):
        print(">>> getRabInfo: ", p_cell_id)
        resp = None
        if p_cell_id == '0x8000099':
            resp = "{\"problemDetails\": {\t\"type\": \"Not Found\",\t\"title\": \"RnisAPI\",\t\"status\": 404,\t\"detail\": \"Not Found\",\t\"instance\": \"string\"}}"
        else:
            resp = "{ \"RabInfo\": { \"timeStamp\": { \"seconds\": 1577836800, \"nanoSeconds\": 0 }, \"appInsId\": \"01\", \"requestId\": \"01\", \"cellUserInfo\": [ { \"ecgi\": { \"plmn\": { \"mcc\": \"001\", \"mnc\": \"01\" }, \"cellId\": \"" + p_cell_id + "\" }, \"ueInfo\": [ { \"associateId\": [ { \"type\": \"1\", \"value\": \"192.0.2.0\" } ], \"erabInfo\": [ { \"erabId\": 10 , \"erabQosParameters\": [ { \"qci\": 7, \"qosInformation\": [ { \"erabMbrDl\": 10, \"erabMbrUl\": 10, \"erabGbrDl\": 10, \"erabGbrUl\": 10 } ] } ] } ] } ] } ] } }"
        return resp
    # End of getRabInfo

    def getPlmnInfo(self, p_app_inst):
        print(">>> getPlmnInfo: ", p_app_inst)
        resp = None
        if p_app_inst == '99':
            resp = "{\"problemDetails\": {\t\"type\": \"Not Found\",\t\"title\": \"RnisAPI\",\t\"status\": 404,\t\"detail\": \"Not Found\",\t\"instance\": \"string\"}}"
        else:
            resp = "{ \"PlmnInfo\": { \"timeStamp\": { \"seconds\": 1577836800, \"nanoSeconds\": 0 }, \"appInsId\": \"" + p_app_inst + "\", \"plmn\": [ { \"mcc\": \"001\", \"mnc\": \"01\" } ] } }"
        return resp
    # End of getPlmnInfo

    def getS1BearerInfo(self, p_cell_id):
        print(">>> getS1BearerInfo: ", p_cell_id)
        resp = None
        if p_cell_id == '0x8000099':
            resp = "{\"problemDetails\": {\t\"type\": \"Not Found\",\t\"title\": \"RnisAPI\",\t\"status\": 404,\t\"detail\": \"Not Found\",\t\"instance\": \"string\"}}"
        else:
            resp = "{ \"S1BearerInfo\": { \"timeStamp\": { \"seconds\": 1577836800, \"nanoSeconds\": 0 }, \"s1UeInfo\": [ { \"tempUeId\": [ { \"mmec\": \"0\", \"mtmsi\": \"1234\" } ], \"associateId\": [ { \"type\": \"1\", \"value\": \"192.0.2.0\" }, { \"type\": \"3\", \"value\": \"198.51.100.0\" } ], \"ecgi\": [ { \"plmn\": { \"mcc\": \"001\", \"mnc\": \"01\" }, \"cellId\": \"0x800000A\" } ], \"s1BearerInfoDetailed\": [ { \"erabId\": 1, \"s1EnbInfo\": { \"ipAddress\": \"192.0.2.0\", \"tunnelId\": \"1111\" }, \"sGwInfo\": { \"ipAddress\": \"192.0.2.1\", \"tunnelId\": \"2222\" } } ] } ]    } }"
        return resp
    # End of getS1BearerInfo

    def getL2MeasInfo(self, p_cell_id):
        print(">>> getL2MeasInfo: ", p_cell_id)
        resp = None
        if p_cell_id == '0x8000099':
            resp = "{\"problemDetails\": {\t\"type\": \"Not Found\",\t\"title\": \"RnisAPI\",\t\"status\": 404,\t\"detail\": \"Not Found\",\t\"instance\": \"string\"}}"
        return resp
    # End of getL2MeasInfo

# End of class mec_database
