#!/bin/bash

#set -e
set -vx

echo -e "*****************************\n* Checkout STF569 sources\n*****************************\n"
mkdir -p ${HOME}/dev && cd ${HOME}/dev || exit 1

git clone --recurse-submodules -b ttf_t012 --single-branch https://forge.etsi.org/rep/mec/gs032p3-ttcn-test-suite.git TTF_T012_Mec
cd /home/etsi/dev/TTF_T012_Mec/ttcn
git clone https://forge.etsi.org/gitlab/LIBS/LibCommon.git ./LibCommon
git clone -bTTF0002 https://forge.etsi.org/gitlab/LIBS/LibIts ./LibIts
cd /home/etsi/dev/TTF_T012_Mec/ttcn/LibIts
git checkout TTF0002
rm -fr asn1 t3q xsd
cd ttcn && rm -fr BTP CAM Common DENM GeoNetworking Ipv6OverGeoNetworking IVIM MapemSpatem Pki Security SremSsem
echo -e "*****************************\n* Set up environment\n*****************************\n"
cd /home/etsi/dev/TTF_T012_Mec/scripts
ln -sf /home/etsi/dev/TTF_T012_Mec/scripts/devenv.bash.ubuntu /home/etsi/devenv.bash
. /home/etsi/devenv.bash
set
echo -e "*****************************\n* Build Mec test suite\n*****************************\n"
cd /home/etsi/dev/TTF_T012_Mec
export ATS=AtsMec
make

echo -e "*****************************\n* Init Eclipse Workspace\n*****************************\n"

