/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.validation;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import de.ugoe.cs.swe.TTCN3Configuration.QualityCheckProfile;
import de.ugoe.cs.swe.common.ConfigTools;
import de.ugoe.cs.swe.common.MiscTools;
import de.ugoe.cs.swe.common.TTCN3ScopeHelper;
import de.ugoe.cs.swe.common.logging.LoggingInterface;
import de.ugoe.cs.swe.tTCN3.AltstepDef;
import de.ugoe.cs.swe.tTCN3.BaseTemplate;
import de.ugoe.cs.swe.tTCN3.ComponentDef;
import de.ugoe.cs.swe.tTCN3.ComponentElementDef;
import de.ugoe.cs.swe.tTCN3.ConstDef;
import de.ugoe.cs.swe.tTCN3.DerivedDef;
import de.ugoe.cs.swe.tTCN3.EnumDefNamed;
import de.ugoe.cs.swe.tTCN3.Enumeration;
import de.ugoe.cs.swe.tTCN3.ExtConstDef;
import de.ugoe.cs.swe.tTCN3.ExtFunctionDef;
import de.ugoe.cs.swe.tTCN3.FormalPortPar;
import de.ugoe.cs.swe.tTCN3.FormalTemplatePar;
import de.ugoe.cs.swe.tTCN3.FormalTimerPar;
import de.ugoe.cs.swe.tTCN3.FormalValuePar;
import de.ugoe.cs.swe.tTCN3.FunctionDef;
import de.ugoe.cs.swe.tTCN3.GroupDef;
import de.ugoe.cs.swe.tTCN3.MatchingSymbol;
import de.ugoe.cs.swe.tTCN3.ModuleDefinition;
import de.ugoe.cs.swe.tTCN3.ModuleParameter;
import de.ugoe.cs.swe.tTCN3.NamedObject;
import de.ugoe.cs.swe.tTCN3.PortDef;
import de.ugoe.cs.swe.tTCN3.PortElement;
import de.ugoe.cs.swe.tTCN3.RecordDefNamed;
import de.ugoe.cs.swe.tTCN3.RecordOfDefNamed;
import de.ugoe.cs.swe.tTCN3.ReferencedType;
import de.ugoe.cs.swe.tTCN3.SetDefNamed;
import de.ugoe.cs.swe.tTCN3.SetOfDefNamed;
import de.ugoe.cs.swe.tTCN3.SignatureDef;
import de.ugoe.cs.swe.tTCN3.SingleConstDef;
import de.ugoe.cs.swe.tTCN3.SingleTempVarInstance;
import de.ugoe.cs.swe.tTCN3.SingleVarInstance;
import de.ugoe.cs.swe.tTCN3.SubTypeDefNamed;
import de.ugoe.cs.swe.tTCN3.TTCN3Module;
import de.ugoe.cs.swe.tTCN3.TTCN3Package;
import de.ugoe.cs.swe.tTCN3.TTCN3Reference;
import de.ugoe.cs.swe.tTCN3.TemplateDef;
import de.ugoe.cs.swe.tTCN3.TemplateOrValueFormalPar;
import de.ugoe.cs.swe.tTCN3.TestcaseDef;
import de.ugoe.cs.swe.tTCN3.TimerInstance;
import de.ugoe.cs.swe.tTCN3.TypeReference;
import de.ugoe.cs.swe.tTCN3.UnionDefNamed;
import de.ugoe.cs.swe.validation.TTCN3StatisticsProvider;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class NamingConventionsValidator
extends AbstractDeclarativeValidator {
    private final ConfigTools configTools = ConfigTools.getInstance();
    private QualityCheckProfile activeProfile = (QualityCheckProfile)this.configTools.getSelectedProfile();

    @Check
    public void checkModuleName(TTCN3Module module) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getModuleRegExp();
        this.checkIdentifierForNamingConventionCompliance(module, regExp, "Module", true);
    }

    @Check
    public void checkFunctionName(FunctionDef function) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getFunctionRegExp();
        this.checkIdentifierForNamingConventionCompliance(function, regExp, "Function", false);
    }

    @Check
    public void checkExtFunctionName(ExtFunctionDef function) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getExtFunctionRegExp();
        this.checkIdentifierForNamingConventionCompliance(function, regExp, "ExtFunction", false);
    }

    @Check
    public void checkConstName(SingleConstDef const_) {
        String message = "";
        String regExp = "";
        ConstDef cDef = TTCN3ScopeHelper.findDesiredParent(const_, ConstDef.class);
        EObject _eContainer = cDef.eContainer();
        if (_eContainer instanceof ModuleDefinition) {
            message = "Constant";
            regExp = this.activeProfile.getNamingConventionsConfig().getConstantRegExp();
        } else {
            message = "Local Constant";
            regExp = this.activeProfile.getNamingConventionsConfig().getLocalConstantRegExp();
        }
        this.checkIdentifierForNamingConventionCompliance(const_, regExp, message, false);
    }

    @Check
    public void checkExtConstantnName(ExtConstDef const_) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getExtConstantRegExp();
        ICompositeNode node = NodeModelUtils.getNode((EObject)const_);
        EList<NamedObject> _ids = const_.getId().getIds();
        for (NamedObject n : _ids) {
            this.checkIdentifierForNamingConventionCompliance(n.getName(), (INode)node, regExp, "External Constant");
        }
    }

    @Check
    public void checkAltstepName(AltstepDef altstep) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getAltstepRegExp();
        this.checkIdentifierForNamingConventionCompliance(altstep, regExp, "Altstep", false);
    }

    @Check
    public void checkGroupName(GroupDef group) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getGroupRegExp();
        this.checkIdentifierForNamingConventionCompliance(group, regExp, "Group", false);
    }

    @Check
    public void checkModuleParameterName(ModuleParameter moduleParameter) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getModuleParameterRegExp();
        this.checkIdentifierForNamingConventionCompliance(moduleParameter, regExp, "ModuleParameter", false);
    }

    @Check
    public void checkTestcaseName(TestcaseDef testcase) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getTestcaseRegExp();
        this.checkIdentifierForNamingConventionCompliance(testcase, regExp, "Testcase", false);
    }

    @Check
    public void checkTestcaseName(SignatureDef signature) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getSignatureTemplateRegExp();
        this.checkIdentifierForNamingConventionCompliance(signature, regExp, "SignatureTemplate", false);
    }

    @Check
    public void checkTestcaseName(FormalValuePar parameter) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getFormalParameterRegExp();
        this.checkIdentifierForNamingConventionCompliance(parameter, regExp, "FormalParameter", false);
    }

    @Check
    public void checkTestcaseName(FormalPortPar parameter) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getFormalParameterRegExp();
        this.checkIdentifierForNamingConventionCompliance(parameter, regExp, "FormalParameter", false);
    }

    @Check
    public void checkTestcaseName(FormalTemplatePar parameter) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getFormalParameterRegExp();
        this.checkIdentifierForNamingConventionCompliance(parameter, regExp, "FormalParameter", false);
    }

    @Check
    public void checkTestcaseName(FormalTimerPar parameter) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getFormalParameterRegExp();
        this.checkIdentifierForNamingConventionCompliance(parameter, regExp, "FormalParameter", false);
    }

    @Check
    public void checkEnumeratedValueName(Enumeration enumeratedValue) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getEnumeratedValueRegExp();
        this.checkIdentifierForNamingConventionCompliance(enumeratedValue, regExp, "EnumeratedValue", false);
    }

    @Check
    public void checkSubTypeValueName(SubTypeDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkRecordOfTypeName(RecordOfDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(SetOfDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(SetDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(RecordDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(ComponentDef dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(UnionDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(PortDef dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(EnumDefNamed dataType) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getDataTypeRegExp();
        this.checkIdentifierForNamingConventionCompliance(dataType, regExp, "DataType", false);
    }

    @Check
    public void checkSetOfTypeName(PortElement port) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getPortInstanceRegExp();
        this.checkIdentifierForNamingConventionCompliance(port, regExp, "PortInstance", false);
    }

    @Check
    public void checkVariableName(SingleVarInstance variable) {
        boolean _notEquals;
        String regExp = "";
        String message = "";
        ComponentElementDef componend = TTCN3ScopeHelper.findDesiredParent(variable, ComponentElementDef.class);
        TypeReference type = TTCN3ScopeHelper.findVariableType(variable);
        boolean bl = _notEquals = !Objects.equal((Object)componend, null);
        if (_notEquals) {
            regExp = this.activeProfile.getNamingConventionsConfig().getComponentVariableRegExp();
            message = "ComponentVariable";
        } else {
            boolean _notEquals_1;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)type, null);
            if (_notEquals_1) {
                ReferencedType refType = TTCN3ScopeHelper.getReferencedType(type);
                if (refType instanceof ComponentDef) {
                    regExp = this.activeProfile.getNamingConventionsConfig().getComponentInstanceRegExp();
                    message = "ComponentInstance";
                } else {
                    regExp = this.activeProfile.getNamingConventionsConfig().getVariableRegExp();
                    message = "Variable";
                }
            } else {
                regExp = this.activeProfile.getNamingConventionsConfig().getVariableRegExp();
                message = "Variable";
            }
        }
        this.checkIdentifierForNamingConventionCompliance(variable, regExp, message, false);
    }

    @Check
    public void checkTimerInstances(TimerInstance timer) {
        ComponentDef componend = TTCN3ScopeHelper.findDesiredParent(timer, ComponentDef.class);
        String regExp = "";
        String message = "";
        EList<SingleVarInstance> _variables = timer.getList().getVariables();
        for (SingleVarInstance v : _variables) {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)componend, null);
            if (_notEquals) {
                regExp = this.activeProfile.getNamingConventionsConfig().getComponentTimerRegExp();
                message = "ComponentTimer";
            } else {
                regExp = this.activeProfile.getNamingConventionsConfig().getTimerRegExp();
                message = "Timer";
            }
            this.checkIdentifierForNamingConventionCompliance(v, regExp, message, false);
        }
    }

    @Check
    public void checkVariableName(SingleTempVarInstance variable) {
        String regExp = this.activeProfile.getNamingConventionsConfig().getVariableRegExp();
        String message = "Variable";
        this.checkIdentifierForNamingConventionCompliance(variable, regExp, message, false);
    }

    @Check
    public void checkSTF160Template(BaseTemplate template) {
        boolean _not;
        String regExp = "";
        String message = "";
        TemplateDef templateDef = TTCN3ScopeHelper.findDesiredParent(template, TemplateDef.class);
        DerivedDef _derived = templateDef.getDerived();
        boolean isDerived = !Objects.equal((Object)_derived, null);
        boolean isSendTemplate = false;
        boolean isAmbiguous = false;
        boolean _isCheckNamingConventions = this.activeProfile.isCheckNamingConventions();
        boolean bl = _not = !_isCheckNamingConventions;
        if (_not) {
            return;
        }
        if (!Objects.equal((Object)templateDef.getRestriction(), null) && Objects.equal((Object)templateDef.getRestriction().getPresent(), null)) {
            if (!Objects.equal((Object)template.getParList(), null) && !Objects.equal(template.getParList().getParams(), null)) {
                EList<TemplateOrValueFormalPar> _params = template.getParList().getParams();
                for (TemplateOrValueFormalPar p : _params) {
                    boolean _notEquals;
                    FormalTemplatePar _template = p.getTemplate();
                    boolean bl2 = _notEquals = !Objects.equal((Object)_template, null);
                    if (_notEquals && (Objects.equal((Object)p.getTemplate().getRestriction(), null) || Objects.equal((Object)p.getTemplate().getRestriction().getRestriction(), null) || !Objects.equal((Object)p.getTemplate().getRestriction().getRestriction().getPresent(), null))) {
                        isAmbiguous = true;
                    }
                    if (!isAmbiguous) continue;
                    TTCN3StatisticsProvider.getInstance().increaseCountNaming();
                    ICompositeNode node = NodeModelUtils.getNode((EObject)templateDef);
                    String _name = template.getName();
                    String _plus = "The template definition for \"" + _name;
                    String infoMessage = String.valueOf(_plus) + "\" is ambiguous. It cannot be determined whether it is a send or a receive template according to STF160's conventions. It will not be analyzed further for naming conventions compliance.";
                    EAttribute _tTCN3Reference_Name = TTCN3Package.eINSTANCE.getTTCN3Reference_Name();
                    String _string = LoggingInterface.MessageClass.NAMING.toString();
                    String _string_1 = Integer.valueOf(node.getStartLine()).toString();
                    String _string_2 = Integer.valueOf(node.getEndLine()).toString();
                    String _methodName = MiscTools.getMethodName();
                    String _plus_1 = "2.1, " + _methodName;
                    this.info(infoMessage, (EStructuralFeature)_tTCN3Reference_Name, _string, new String[]{_string_1, _string_2, _plus_1, LoggingInterface.LogLevel.INFORMATION.toString()});
                    return;
                }
            }
            isSendTemplate = true;
        }
        if (!isDerived) {
            if (isSendTemplate) {
                message = "STF160SendTemplate";
                regExp = this.activeProfile.getNamingConventionsConfig().getStf160sendTemplateRegExp();
            } else {
                message = "STF160ReceiveTemplate";
                regExp = this.activeProfile.getNamingConventionsConfig().getStf160receiveTemplateRegExp();
            }
        } else if (isSendTemplate) {
            message = "DerivedSTF160SendTemplate";
            regExp = this.activeProfile.getNamingConventionsConfig().getDerivedStf160sendTemplateRegExp();
        } else {
            message = "DerivedSTF160ReceiveTemplate";
            regExp = this.activeProfile.getNamingConventionsConfig().getDerivedStf160receiveTemplateRegExp();
        }
        this.checkIdentifierForNamingConventionCompliance(template, regExp, message, true);
    }

    @Check
    public void checkMessageTemplate(BaseTemplate template) {
        String regExp = "";
        String message = "";
        TemplateDef templateDef = TTCN3ScopeHelper.findDesiredParent(template, TemplateDef.class);
        DerivedDef _derived = templateDef.getDerived();
        boolean isDerived = !Objects.equal((Object)_derived, null);
        List matchingSymbols = EcoreUtil2.eAllOfType((EObject)templateDef.getBody(), MatchingSymbol.class);
        matchingSymbols.addAll(EcoreUtil2.eAllOfType((EObject)templateDef.getBase(), MatchingSymbol.class));
        if (!isDerived) {
            boolean _isEmpty = matchingSymbols.isEmpty();
            if (_isEmpty) {
                regExp = this.activeProfile.getNamingConventionsConfig().getMessageTemplateRegExp();
                message = "MessageTemplate";
            } else {
                regExp = this.activeProfile.getNamingConventionsConfig().getMessageTemplateWithWildcardsRegExp();
                message = "MessageTemplateWithMatchingExpression";
            }
        } else {
            boolean _isEmpty_1 = matchingSymbols.isEmpty();
            if (_isEmpty_1) {
                regExp = this.activeProfile.getNamingConventionsConfig().getDerivedMessageTemplateRegExp();
                message = "DerivedMessageTemplate";
            } else {
                regExp = this.activeProfile.getNamingConventionsConfig().getDerivedMessageTemplateWithWildcardsRegExp();
                message = "DerivedMessageTemplateWithMatchingExpression";
            }
        }
        this.checkIdentifierForNamingConventionCompliance(template, regExp, message, true);
    }

    private boolean regExpMatch(String regExp, String subject) {
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(subject);
        return matcher.matches();
    }

    private void checkIdentifierForNamingConventionCompliance(String name, INode node, String regExp, String type) {
        boolean _not_1;
        boolean _not;
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)regExp);
        if (_isNullOrEmpty) {
            return;
        }
        boolean _isCheckNamingConventions = this.activeProfile.isCheckNamingConventions();
        boolean bl = _not = !_isCheckNamingConventions;
        if (_not) {
            return;
        }
        boolean _regExpMatch = this.regExpMatch(regExp, name);
        boolean bl2 = _not_1 = !_regExpMatch;
        if (_not_1) {
            TTCN3StatisticsProvider.getInstance().increaseCountNaming();
            String message = "\"" + name + "\" does not comply to the naming conventions for \"" + type + "\"!";
            this.warning(message, null, LoggingInterface.MessageClass.NAMING.toString(), new String[]{Integer.valueOf(node.getStartLine()).toString(), Integer.valueOf(node.getEndLine()).toString(), "2.1, " + regExp});
            return;
        }
    }

    private void checkIdentifierForNamingConventionCompliance(TTCN3Reference object, String regExp, String type, boolean showOnlyStartLine) {
        boolean _not_1;
        boolean _not;
        if (Objects.equal((Object)object, null) || Strings.isNullOrEmpty((String)regExp)) {
            return;
        }
        boolean _isCheckNamingConventions = this.activeProfile.isCheckNamingConventions();
        boolean bl = _not = !_isCheckNamingConventions;
        if (_not) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        boolean _regExpMatch = this.regExpMatch(regExp, object.getName());
        boolean bl2 = _not_1 = !_regExpMatch;
        if (_not_1) {
            TTCN3StatisticsProvider.getInstance().increaseCountNaming();
            String _name = object.getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\" does not comply to the naming conventions for \"";
            String _plus_2 = String.valueOf(_plus_1) + type;
            String message = String.valueOf(_plus_2) + "\"!";
            String endLine = "";
            endLine = showOnlyStartLine ? Integer.valueOf(node.getStartLine()).toString() : Integer.valueOf(node.getEndLine()).toString();
            this.warning(message, null, LoggingInterface.MessageClass.NAMING.toString(), new String[]{Integer.valueOf(node.getStartLine()).toString(), endLine, "2.1, " + regExp});
            return;
        }
    }

    public void register(EValidatorRegistrar registrar) {
    }
}

