/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common.logging;

import de.ugoe.cs.swe.common.logging.LogMessage;
import de.ugoe.cs.swe.common.logging.LoggingConfiguration;
import java.io.File;
import org.eclipse.emf.common.util.URI;

public class LoggingInterface {
    private String logSourceName = "";
    private LogLevel maximumLogLevel = LogLevel.INFORMATION;
    private LogLevel defaultLogLevel = LogLevel.INFORMATION;
    private LoggingConfiguration configuration = new LoggingConfiguration();

    public LoggingInterface(LoggingConfiguration logConfiguration) {
        this.setConfiguration(logConfiguration);
    }

    public LoggingInterface(String logSourceName, LoggingConfiguration logConfiguration) {
        this(logConfiguration);
        this.setLogSourceName(logSourceName);
    }

    public LoggingInterface(String logSourceName, LoggingConfiguration logConfiguration, LogLevel maximumLogLevel) {
        this(logSourceName, logConfiguration);
        this.setMaximumLogLevel(maximumLogLevel);
    }

    private LogMessage createLogMessage(URI uri, LogLevel l, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        LogMessage logMessage = new LogMessage();
        logMessage.setPrefix(this.getConfiguration().getLogOutputPrefix());
        if (uri != null && this.getConfiguration().isShowFilename() && this.getConfiguration().isShowFullPath()) {
            logMessage.setFilename(uri.devicePath().replaceFirst("///", ""));
        } else if (uri != null && this.getConfiguration().isShowFilename()) {
            String path = uri.devicePath();
            File file = new File(path);
            logMessage.setFilename(file.getName());
        }
        logMessage.setStartLine(startLine);
        logMessage.setEndLine(endLine);
        logMessage.setLogLevel(l);
        messageClass.addOccurence();
        if (this.getConfiguration().isShowMessageClass()) {
            logMessage.setMessageClass(messageClass);
        } else {
            logMessage.setMessageClass(null);
        }
        logMessage.setMessage(message);
        if (this.getConfiguration().isShowDetails() && details != null) {
            logMessage.setDetails(details);
        } else {
            logMessage.setDetails(null);
        }
        return logMessage;
    }

    public void logMessage(URI uri, LogLevel l, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        if (this.showLogLevel(l)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, l, startLine, endLine, messageClass, message, details);
            this.outputLog(composedLogMessage);
        }
    }

    public void logMessage(URI uri, LogLevel l, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(l)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, l, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logMessage(URI uri, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        if (this.showLogLevel(this.getDefaultLogLevel())) {
            LogMessage composedLogMessage = this.createLogMessage(uri, this.getDefaultLogLevel(), startLine, endLine, messageClass, message, details);
            this.outputLog(composedLogMessage);
        }
    }

    public void logMessage(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(this.getDefaultLogLevel())) {
            LogMessage composedLogMessage = this.createLogMessage(uri, this.getDefaultLogLevel(), startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    private void outputLog(LogMessage composedLogMessage) {
        System.out.println(composedLogMessage.toString());
    }

    public void logWarning(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(LogLevel.WARNING)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.WARNING, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logWarning(URI uri, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        if (this.showLogLevel(LogLevel.WARNING)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.WARNING, startLine, endLine, messageClass, message, details);
            this.outputLog(composedLogMessage);
        }
    }

    public void logDebug(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(LogLevel.DEBUG)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.DEBUG, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logDebug(URI uri, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        if (this.showLogLevel(LogLevel.DEBUG)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.DEBUG, startLine, endLine, messageClass, message, details);
            this.outputLog(composedLogMessage);
        }
    }

    public void logFix(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(LogLevel.FIXME)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.FIXME, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logFix(URI uri, int startLine, int endLine, MessageClass messageClass, String message, String details) {
        if (this.showLogLevel(LogLevel.FIXME)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.FIXME, startLine, endLine, messageClass, message, details);
            this.outputLog(composedLogMessage);
        }
    }

    public void logError(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(LogLevel.ERROR)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.ERROR, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logInformation(URI uri, int startLine, int endLine, MessageClass messageClass, String message) {
        if (this.showLogLevel(LogLevel.INFORMATION)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.INFORMATION, startLine, endLine, messageClass, message, null);
            this.outputLog(composedLogMessage);
        }
    }

    public void logInformation(URI uri, int startLine, int endLine, MessageClass messageClass, String message, String detail) {
        if (this.showLogLevel(LogLevel.INFORMATION)) {
            LogMessage composedLogMessage = this.createLogMessage(uri, LogLevel.INFORMATION, startLine, endLine, messageClass, message, detail);
            this.outputLog(composedLogMessage);
        }
    }

    public String getLogSourceName() {
        return this.logSourceName;
    }

    public void setMaximumLogLevel(LogLevel maximumLogLevel) {
        this.maximumLogLevel = maximumLogLevel;
    }

    public LogLevel getMaximumLogLevel() {
        return this.maximumLogLevel;
    }

    public boolean showLogLevel(LogLevel logLevel) {
        boolean show = false;
        if (logLevel.ordinal() <= this.getMaximumLogLevel().ordinal()) {
            show = true;
        }
        return show;
    }

    public void setConfiguration(LoggingConfiguration configuration) {
        this.configuration = configuration;
    }

    public LoggingConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setDefaultLogLevel(LogLevel defaultLogLevel) {
        this.defaultLogLevel = defaultLogLevel;
    }

    public LogLevel getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    public void setLogSourceName(String logSourceName) {
        this.logSourceName = logSourceName;
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFORMATION,
        FIXME,
        DEBUG;

    }

    public static enum MessageClass {
        UNIVERSAL("Universal", 0),
        GENERAL("General", 1),
        NAMING("Naming Conventions", 2),
        DOCUMENTATION("Code Documentation", 3),
        LOGGING("Log Statements", 4),
        STRUCTURE("Structure of Data", 5),
        STYLE("Code Style", 6),
        MODULARIZATION("Test Suite Modularization", 7);

        private final String description;
        private final int id;
        private int occurenceCount = 0;

        private MessageClass(String description, int id) {
            this.description = description;
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public void addOccurence() {
            ++this.occurenceCount;
        }

        public int getOccurenceCount() {
            return this.occurenceCount;
        }
    }
}

