/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.swe.common;

import com.google.common.collect.Lists;
import de.ugoe.cs.swe.tTCN3.Assignment;
import de.ugoe.cs.swe.tTCN3.Enumeration;
import de.ugoe.cs.swe.tTCN3.FormalTemplatePar;
import de.ugoe.cs.swe.tTCN3.FormalValuePar;
import de.ugoe.cs.swe.tTCN3.Head;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class TTCN3ReferenceHelper {
    public static boolean isReferenced(EObject rootElement, Set<? extends EObject> targets) {
        LinkedList elements = Lists.newLinkedList();
        elements.add(rootElement);
        while (!elements.isEmpty()) {
            if (!TTCN3ReferenceHelper.findChildElements(targets, elements)) continue;
            return true;
        }
        return false;
    }

    private static boolean findChildElements(Set<? extends EObject> targets, Queue<EObject> elements) {
        EObject rootElement = elements.poll();
        for (EReference ref : rootElement.eClass().getEAllReferences()) {
            if (!rootElement.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isContainment()) {
                Object content = rootElement.eGet((EStructuralFeature)ref, false);
                if (ref.isMany()) {
                    InternalEList contentList = (InternalEList)content;
                    int i = 0;
                    while (i < contentList.size()) {
                        EObject childElement = (EObject)contentList.basicGet(i);
                        if (!childElement.eIsProxy()) {
                            elements.add(childElement);
                        }
                        ++i;
                    }
                    continue;
                }
                EObject childElement = (EObject)content;
                if (childElement.eIsProxy()) continue;
                elements.add(childElement);
                continue;
            }
            if (ref.isContainer() || !TTCN3ReferenceHelper.checkNoContainerElements(rootElement, targets, ref)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNoContainerElements(EObject rootElement, Set<? extends EObject> targets, EReference ref) {
        Object value = rootElement.eGet((EStructuralFeature)ref, true);
        if (ref.isMany()) {
            InternalEList values = (InternalEList)value;
            int i = 0;
            while (i < values.size()) {
                EObject refElement = (EObject)values.get(i);
                if (targets.contains(refElement)) {
                    return true;
                }
                ++i;
            }
        } else {
            EObject refElement = (EObject)value;
            if (targets.contains(refElement)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isReferenced3(EObject rootElement, Set<? extends EObject> targets) {
        Map results = EcoreUtil.UsageCrossReferencer.findAll(targets, (EObject)rootElement);
        for (EObject o : results.keySet()) {
            System.out.println(o + " -> ");
            for (EStructuralFeature.Setting s : (Collection)results.get(o)) {
                System.out.println("    " + s.getEStructuralFeature());
            }
        }
        return results.size() > 0;
    }

    public static boolean isReferenced2(EObject rootElement, Set<? extends EObject> targets) {
        return TTCN3ReferenceHelper.isReferenced2(rootElement, targets, true);
    }

    public static boolean isReferenced2(EObject rootElement, Set<? extends EObject> targets, boolean ignoreAssignment) {
        boolean found = false;
        for (EReference ref : rootElement.eClass().getEAllReferences()) {
            int i;
            if (found) {
                return true;
            }
            if (!rootElement.eIsSet((EStructuralFeature)ref)) continue;
            if (ref.isContainment()) {
                Object content = rootElement.eGet((EStructuralFeature)ref, true);
                if (ref.isMany()) {
                    InternalEList contentList = (InternalEList)content;
                    i = 0;
                    while (i < contentList.size()) {
                        EObject childElement = (EObject)contentList.basicGet(i);
                        if (!childElement.eIsProxy()) {
                            found |= TTCN3ReferenceHelper.isReferenced2(childElement, targets, ignoreAssignment);
                        }
                        ++i;
                    }
                    continue;
                }
                EObject childElement = (EObject)content;
                if (childElement.eIsProxy()) continue;
                found |= TTCN3ReferenceHelper.isReferenced2(childElement, targets, ignoreAssignment);
                continue;
            }
            if (ref.isContainer()) continue;
            Object value = rootElement.eGet((EStructuralFeature)ref, true);
            if (ref.isMany()) {
                InternalEList values = (InternalEList)value;
                i = 0;
                while (i < values.size()) {
                    EObject refElement = (EObject)values.get(i);
                    if (targets.contains(refElement)) {
                        return true;
                    }
                    ++i;
                }
                continue;
            }
            EObject refElement = (EObject)value;
            if (!targets.contains(refElement)) continue;
            if (refElement instanceof Enumeration) {
                return false;
            }
            if (ignoreAssignment) {
                return TTCN3ReferenceHelper.checkAssignment(rootElement, refElement);
            }
            return true;
        }
        return found;
    }

    private static boolean checkAssignment(EObject rootElement, EObject refElement) {
        if (rootElement instanceof Head && rootElement.eContainer().eContainer().eContainer() instanceof Assignment) {
            if (refElement instanceof FormalValuePar && ((FormalValuePar)refElement).getInOut() == null) {
                ((FormalValuePar)refElement).setInOut("in");
            } else if (refElement instanceof FormalTemplatePar && ((FormalTemplatePar)refElement).getInOut() == null) {
                ((FormalTemplatePar)refElement).setInOut("in");
            }
            return refElement instanceof FormalValuePar && (((FormalValuePar)refElement).getInOut().equals("out") || ((FormalValuePar)refElement).getInOut().equals("inout")) || refElement instanceof FormalTemplatePar && (((FormalTemplatePar)refElement).getInOut().equals("out") || ((FormalTemplatePar)refElement).getInOut().equals("inout"));
        }
        return true;
    }
}

