#!/bin/bash

echo -e "*****************************\n* Checkout STF569 sources\n*****************************\n"
mkdir -p ${HOME}/dev && cd ${HOME}/dev || exit 1

git clone --recurse-submodules -b latest-open-draft --single-branch https://forge.etsi.org/rep/mec/gs032p3-ttcn-test-suite.git STF569_Mec
cd /home/etsi/dev/STF569_Mec/ttcn
git clone https://forge.etsi.org/gitlab/LIBS/LibCommon.git ./LibCommon
git clone -bTTF0002 https://forge.etsi.org/gitlab/LIBS/LibIts ./LibIts
cd /home/etsi/dev/STF569_Mec/ttcn/LibIts
git checkout TTF0002
rm -fr asn1 t3q xsd
cd ttcn && rm -fr BTP CAM Common DENM GeoNetworking Ipv6OverGeoNetworking IVIM MapemSpatem Pki Security SremSsem
cd /home/etsi/dev/STF569_Mec/scripts
chmod 775 *.bash devenv.bash.*
cd /home/etsi
ln -sf /home/etsi/dev/STF569_Mec/scripts/devenv.bash.ubuntu /home/etsi/devenv.bash
ls -ltr /home/etsi
export HOME=/home/etsi
. /home/etsi/devenv.bash
cd /home/etsi/dev/STF569_Mec/scripts
./build_titan.bash
. /home/etsi/devenv.bash
./update_mec_project.bash
cd /home/etsi/dev/etsi_mec/src/AtsMec/objs
../bin/mec_generate_makefile.bash

echo -e "*****************************\n* Init Eclipse Workspace\n*****************************\n"
mkdir -p ${HOME}/dev/Workspace/STF569/bin/
cd ${HOME}/dev/Workspace/STF569

exit 0
