#!/bin/bash

#set -e
set -vx

echo -e "*****************************\n* Install eclipse\n*****************************\n"
mkdir -p ${HOME}/frameworks
cd ${HOME}/frameworks || exit 1
wget --progress=dot:mega 'https://www.eclipse.org/downloads/download.php?file=/technology/epp/downloads/release/helios/SR2/eclipse-cpp-helios-SR2-linux-gtk-x86_64.tar.gz' -Oeclipse-cpp-helios-SR2-linux-gtk-x86_64.tar.gz || exit 1
tar -zxvf ./eclipse-cpp-helios-SR2-linux-gtk-x86_64.tar.gz || exit 1
ln -sf ${HOME}/frameworks/eclipse/eclipse ${HOME}/bin/eclipse
rm -f ./eclipse-cpp-helios-SR2-linux-gtk-x86_64.tar.gz

if wget --progress=dot:mega 'https://www.eclipse.org/downloads/download.php?file=/titan/TITAN_Designer_and_Executor_plugin-6.4.pl0.zip&r=1' -OTITAN_Designer_and_Executor_plugin.zip; then
  eclipse/eclipse -noSplash -application org.eclipse.equinox.p2.director \
    -destination ${HOME}/frameworks/eclipse \
    -repository jar:file://${HOME}/frameworks/TITAN_Designer_and_Executor_plugin.zip!/ \
    -installIU TITAN_Designer.feature.group,TITAN_Executor.feature.group,TITAN_Log_Viewer.feature.group,Titan_external_dependencies.feature.group,Titanium.feature.group,Titanium_external_dependencies.feature.group
  rm -f TITAN_Designer_and_Executor_plugin.zip
fi

exit 0
