# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.s1_bearer_info_s1_ue_info import S1BearerInfoS1UeInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server import util


class S1BearerInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, s1_ue_info: List[S1BearerInfoS1UeInfo]=None, time_stamp: TimeStamp=None):  # noqa: E501
        """S1BearerInfo - a model defined in Swagger

        :param s1_ue_info: The s1_ue_info of this S1BearerInfo.  # noqa: E501
        :type s1_ue_info: List[S1BearerInfoS1UeInfo]
        :param time_stamp: The time_stamp of this S1BearerInfo.  # noqa: E501
        :type time_stamp: TimeStamp
        """
        self.swagger_types = {
            's1_ue_info': List[S1BearerInfoS1UeInfo],
            'time_stamp': TimeStamp
        }

        self.attribute_map = {
            's1_ue_info': 's1UeInfo',
            'time_stamp': 'timeStamp'
        }
        self._s1_ue_info = s1_ue_info
        self._time_stamp = time_stamp

    @classmethod
    def from_dict(cls, dikt) -> 'S1BearerInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The S1BearerInfo of this S1BearerInfo.  # noqa: E501
        :rtype: S1BearerInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def s1_ue_info(self) -> List[S1BearerInfoS1UeInfo]:
        """Gets the s1_ue_info of this S1BearerInfo.

        Information on a specific UE as defined below.  # noqa: E501

        :return: The s1_ue_info of this S1BearerInfo.
        :rtype: List[S1BearerInfoS1UeInfo]
        """
        return self._s1_ue_info

    @s1_ue_info.setter
    def s1_ue_info(self, s1_ue_info: List[S1BearerInfoS1UeInfo]):
        """Sets the s1_ue_info of this S1BearerInfo.

        Information on a specific UE as defined below.  # noqa: E501

        :param s1_ue_info: The s1_ue_info of this S1BearerInfo.
        :type s1_ue_info: List[S1BearerInfoS1UeInfo]
        """
        if s1_ue_info is None:
            raise ValueError("Invalid value for `s1_ue_info`, must not be `None`")  # noqa: E501

        self._s1_ue_info = s1_ue_info

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this S1BearerInfo.


        :return: The time_stamp of this S1BearerInfo.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this S1BearerInfo.


        :param time_stamp: The time_stamp of this S1BearerInfo.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp
