/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeysToMultiValues;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexMultiMap multiMap;

    public MultiValueMapMatcher(MockServerLogger mockServerLogger, KeysToMultiValues keysToMultiValues) {
        this.mockServerLogger = mockServerLogger;
        this.multiMap = keysToMultiValues != null ? keysToMultiValues.toCaseInsensitiveRegexMultiMap() : null;
    }

    @Override
    public boolean matches(HttpRequest context, KeysToMultiValues values) {
        boolean result = false;
        if (this.multiMap == null || this.multiMap.isEmpty()) {
            result = true;
        } else if (values.toCaseInsensitiveRegexMultiMap().containsAll(this.multiMap)) {
            result = true;
        } else {
            this.mockServerLogger.trace(context, "Map [{}] is not a subset of {}", this.multiMap, values);
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

