# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.meas_rep_ue_notification_nr_n_cell_info import MeasRepUeNotificationNrNCellInfo  # noqa: F401,E501
from swagger_server.models.rs_index_results import RsIndexResults  # noqa: F401,E501
from swagger_server import util


class MeasRepUeNotificationNewRadioMeasNeiInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, nr_n_cell_info: List[MeasRepUeNotificationNrNCellInfo]=None, nr_n_cell_rsrp: int=None, nr_n_cell_rsrq: int=None, nr_n_cell_rssi: int=None, rs_index_results: RsIndexResults=None):  # noqa: E501
        """MeasRepUeNotificationNewRadioMeasNeiInfo - a model defined in Swagger

        :param nr_n_cell_info: The nr_n_cell_info of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :type nr_n_cell_info: List[MeasRepUeNotificationNrNCellInfo]
        :param nr_n_cell_rsrp: The nr_n_cell_rsrp of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :type nr_n_cell_rsrp: int
        :param nr_n_cell_rsrq: The nr_n_cell_rsrq of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :type nr_n_cell_rsrq: int
        :param nr_n_cell_rssi: The nr_n_cell_rssi of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :type nr_n_cell_rssi: int
        :param rs_index_results: The rs_index_results of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :type rs_index_results: RsIndexResults
        """
        self.swagger_types = {
            'nr_n_cell_info': List[MeasRepUeNotificationNrNCellInfo],
            'nr_n_cell_rsrp': int,
            'nr_n_cell_rsrq': int,
            'nr_n_cell_rssi': int,
            'rs_index_results': RsIndexResults
        }

        self.attribute_map = {
            'nr_n_cell_info': 'nrNCellInfo',
            'nr_n_cell_rsrp': 'nrNCellRsrp',
            'nr_n_cell_rsrq': 'nrNCellRsrq',
            'nr_n_cell_rssi': 'nrNCellRssi',
            'rs_index_results': 'rsIndexResults'
        }
        self._nr_n_cell_info = nr_n_cell_info
        self._nr_n_cell_rsrp = nr_n_cell_rsrp
        self._nr_n_cell_rsrq = nr_n_cell_rsrq
        self._nr_n_cell_rssi = nr_n_cell_rssi
        self._rs_index_results = rs_index_results

    @classmethod
    def from_dict(cls, dikt) -> 'MeasRepUeNotificationNewRadioMeasNeiInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The MeasRepUeNotification_newRadioMeasNeiInfo of this MeasRepUeNotificationNewRadioMeasNeiInfo.  # noqa: E501
        :rtype: MeasRepUeNotificationNewRadioMeasNeiInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def nr_n_cell_info(self) -> List[MeasRepUeNotificationNrNCellInfo]:
        """Gets the nr_n_cell_info of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        5G NR neighbour cell info.  # noqa: E501

        :return: The nr_n_cell_info of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :rtype: List[MeasRepUeNotificationNrNCellInfo]
        """
        return self._nr_n_cell_info

    @nr_n_cell_info.setter
    def nr_n_cell_info(self, nr_n_cell_info: List[MeasRepUeNotificationNrNCellInfo]):
        """Sets the nr_n_cell_info of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        5G NR neighbour cell info.  # noqa: E501

        :param nr_n_cell_info: The nr_n_cell_info of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :type nr_n_cell_info: List[MeasRepUeNotificationNrNCellInfo]
        """

        self._nr_n_cell_info = nr_n_cell_info

    @property
    def nr_n_cell_rsrp(self) -> int:
        """Gets the nr_n_cell_rsrp of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference Signal Received Power measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_n_cell_rsrp of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :rtype: int
        """
        return self._nr_n_cell_rsrp

    @nr_n_cell_rsrp.setter
    def nr_n_cell_rsrp(self, nr_n_cell_rsrp: int):
        """Sets the nr_n_cell_rsrp of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference Signal Received Power measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_n_cell_rsrp: The nr_n_cell_rsrp of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :type nr_n_cell_rsrp: int
        """

        self._nr_n_cell_rsrp = nr_n_cell_rsrp

    @property
    def nr_n_cell_rsrq(self) -> int:
        """Gets the nr_n_cell_rsrq of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference Signal Received Quality measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_n_cell_rsrq of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :rtype: int
        """
        return self._nr_n_cell_rsrq

    @nr_n_cell_rsrq.setter
    def nr_n_cell_rsrq(self, nr_n_cell_rsrq: int):
        """Sets the nr_n_cell_rsrq of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference Signal Received Quality measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_n_cell_rsrq: The nr_n_cell_rsrq of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :type nr_n_cell_rsrq: int
        """

        self._nr_n_cell_rsrq = nr_n_cell_rsrq

    @property
    def nr_n_cell_rssi(self) -> int:
        """Gets the nr_n_cell_rssi of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference signal SINR measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_n_cell_rssi of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :rtype: int
        """
        return self._nr_n_cell_rssi

    @nr_n_cell_rssi.setter
    def nr_n_cell_rssi(self, nr_n_cell_rssi: int):
        """Sets the nr_n_cell_rssi of this MeasRepUeNotificationNewRadioMeasNeiInfo.

        Reference signal SINR measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_n_cell_rssi: The nr_n_cell_rssi of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :type nr_n_cell_rssi: int
        """

        self._nr_n_cell_rssi = nr_n_cell_rssi

    @property
    def rs_index_results(self) -> RsIndexResults:
        """Gets the rs_index_results of this MeasRepUeNotificationNewRadioMeasNeiInfo.


        :return: The rs_index_results of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :rtype: RsIndexResults
        """
        return self._rs_index_results

    @rs_index_results.setter
    def rs_index_results(self, rs_index_results: RsIndexResults):
        """Sets the rs_index_results of this MeasRepUeNotificationNewRadioMeasNeiInfo.


        :param rs_index_results: The rs_index_results of this MeasRepUeNotificationNewRadioMeasNeiInfo.
        :type rs_index_results: RsIndexResults
        """

        self._rs_index_results = rs_index_results
