# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.meas_rep_ue_notification_nr_scs_nr_s_cell_info import MeasRepUeNotificationNrSCsNrSCellInfo  # noqa: F401,E501
from swagger_server import util


class MeasRepUeNotificationNrSCs(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, nr_s_cell_info: List[MeasRepUeNotificationNrSCsNrSCellInfo]=None, nr_s_cell_rsrp: int=None, nr_s_cell_rsrq: int=None, nr_s_cell_rssi: int=None):  # noqa: E501
        """MeasRepUeNotificationNrSCs - a model defined in Swagger

        :param nr_s_cell_info: The nr_s_cell_info of this MeasRepUeNotificationNrSCs.  # noqa: E501
        :type nr_s_cell_info: List[MeasRepUeNotificationNrSCsNrSCellInfo]
        :param nr_s_cell_rsrp: The nr_s_cell_rsrp of this MeasRepUeNotificationNrSCs.  # noqa: E501
        :type nr_s_cell_rsrp: int
        :param nr_s_cell_rsrq: The nr_s_cell_rsrq of this MeasRepUeNotificationNrSCs.  # noqa: E501
        :type nr_s_cell_rsrq: int
        :param nr_s_cell_rssi: The nr_s_cell_rssi of this MeasRepUeNotificationNrSCs.  # noqa: E501
        :type nr_s_cell_rssi: int
        """
        self.swagger_types = {
            'nr_s_cell_info': List[MeasRepUeNotificationNrSCsNrSCellInfo],
            'nr_s_cell_rsrp': int,
            'nr_s_cell_rsrq': int,
            'nr_s_cell_rssi': int
        }

        self.attribute_map = {
            'nr_s_cell_info': 'nrSCellInfo',
            'nr_s_cell_rsrp': 'nrSCellRsrp',
            'nr_s_cell_rsrq': 'nrSCellRsrq',
            'nr_s_cell_rssi': 'nrSCellRssi'
        }
        self._nr_s_cell_info = nr_s_cell_info
        self._nr_s_cell_rsrp = nr_s_cell_rsrp
        self._nr_s_cell_rsrq = nr_s_cell_rsrq
        self._nr_s_cell_rssi = nr_s_cell_rssi

    @classmethod
    def from_dict(cls, dikt) -> 'MeasRepUeNotificationNrSCs':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The MeasRepUeNotification_nrSCs of this MeasRepUeNotificationNrSCs.  # noqa: E501
        :rtype: MeasRepUeNotificationNrSCs
        """
        return util.deserialize_model(dikt, cls)

    @property
    def nr_s_cell_info(self) -> List[MeasRepUeNotificationNrSCsNrSCellInfo]:
        """Gets the nr_s_cell_info of this MeasRepUeNotificationNrSCs.

        Secondary serving cell(s) info.  # noqa: E501

        :return: The nr_s_cell_info of this MeasRepUeNotificationNrSCs.
        :rtype: List[MeasRepUeNotificationNrSCsNrSCellInfo]
        """
        return self._nr_s_cell_info

    @nr_s_cell_info.setter
    def nr_s_cell_info(self, nr_s_cell_info: List[MeasRepUeNotificationNrSCsNrSCellInfo]):
        """Sets the nr_s_cell_info of this MeasRepUeNotificationNrSCs.

        Secondary serving cell(s) info.  # noqa: E501

        :param nr_s_cell_info: The nr_s_cell_info of this MeasRepUeNotificationNrSCs.
        :type nr_s_cell_info: List[MeasRepUeNotificationNrSCsNrSCellInfo]
        """
        if nr_s_cell_info is None:
            raise ValueError("Invalid value for `nr_s_cell_info`, must not be `None`")  # noqa: E501

        self._nr_s_cell_info = nr_s_cell_info

    @property
    def nr_s_cell_rsrp(self) -> int:
        """Gets the nr_s_cell_rsrp of this MeasRepUeNotificationNrSCs.

        Reference Signal Received Power measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_s_cell_rsrp of this MeasRepUeNotificationNrSCs.
        :rtype: int
        """
        return self._nr_s_cell_rsrp

    @nr_s_cell_rsrp.setter
    def nr_s_cell_rsrp(self, nr_s_cell_rsrp: int):
        """Sets the nr_s_cell_rsrp of this MeasRepUeNotificationNrSCs.

        Reference Signal Received Power measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_s_cell_rsrp: The nr_s_cell_rsrp of this MeasRepUeNotificationNrSCs.
        :type nr_s_cell_rsrp: int
        """

        self._nr_s_cell_rsrp = nr_s_cell_rsrp

    @property
    def nr_s_cell_rsrq(self) -> int:
        """Gets the nr_s_cell_rsrq of this MeasRepUeNotificationNrSCs.

        Reference Signal Received Quality measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_s_cell_rsrq of this MeasRepUeNotificationNrSCs.
        :rtype: int
        """
        return self._nr_s_cell_rsrq

    @nr_s_cell_rsrq.setter
    def nr_s_cell_rsrq(self, nr_s_cell_rsrq: int):
        """Sets the nr_s_cell_rsrq of this MeasRepUeNotificationNrSCs.

        Reference Signal Received Quality measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_s_cell_rsrq: The nr_s_cell_rsrq of this MeasRepUeNotificationNrSCs.
        :type nr_s_cell_rsrq: int
        """

        self._nr_s_cell_rsrq = nr_s_cell_rsrq

    @property
    def nr_s_cell_rssi(self) -> int:
        """Gets the nr_s_cell_rssi of this MeasRepUeNotificationNrSCs.

        Reference signal SINR measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :return: The nr_s_cell_rssi of this MeasRepUeNotificationNrSCs.
        :rtype: int
        """
        return self._nr_s_cell_rssi

    @nr_s_cell_rssi.setter
    def nr_s_cell_rssi(self, nr_s_cell_rssi: int):
        """Sets the nr_s_cell_rssi of this MeasRepUeNotificationNrSCs.

        Reference signal SINR measurement according to mapping table in ETSI TS 138.133 [i.14].  # noqa: E501

        :param nr_s_cell_rssi: The nr_s_cell_rssi of this MeasRepUeNotificationNrSCs.
        :type nr_s_cell_rssi: int
        """

        self._nr_s_cell_rssi = nr_s_cell_rssi
