# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.nr_meas_rep_ue_notification_eutra_neigh_cell_meas_info import NrMeasRepUeNotificationEutraNeighCellMeasInfo  # noqa: F401,E501
from swagger_server.models.nr_meas_rep_ue_notification_nr_neigh_cell_meas_info import NrMeasRepUeNotificationNrNeighCellMeasInfo  # noqa: F401,E501
from swagger_server.models.nr_meas_rep_ue_notification_serv_cell_meas_info import NrMeasRepUeNotificationServCellMeasInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server.models.trigger_nr import TriggerNr  # noqa: F401,E501
from swagger_server import util


class NrMeasRepUeNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, eutra_neigh_cell_meas_info: List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]=None, notification_type: str=None, nr_neigh_cell_meas_info: List[NrMeasRepUeNotificationNrNeighCellMeasInfo]=None, serv_cell_meas_info: List[NrMeasRepUeNotificationServCellMeasInfo]=None, time_stamp: TimeStamp=None, trigger_nr: TriggerNr=None):  # noqa: E501
        """NrMeasRepUeNotification - a model defined in Swagger

        :param associate_id: The associate_id of this NrMeasRepUeNotification.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param eutra_neigh_cell_meas_info: The eutra_neigh_cell_meas_info of this NrMeasRepUeNotification.  # noqa: E501
        :type eutra_neigh_cell_meas_info: List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]
        :param notification_type: The notification_type of this NrMeasRepUeNotification.  # noqa: E501
        :type notification_type: str
        :param nr_neigh_cell_meas_info: The nr_neigh_cell_meas_info of this NrMeasRepUeNotification.  # noqa: E501
        :type nr_neigh_cell_meas_info: List[NrMeasRepUeNotificationNrNeighCellMeasInfo]
        :param serv_cell_meas_info: The serv_cell_meas_info of this NrMeasRepUeNotification.  # noqa: E501
        :type serv_cell_meas_info: List[NrMeasRepUeNotificationServCellMeasInfo]
        :param time_stamp: The time_stamp of this NrMeasRepUeNotification.  # noqa: E501
        :type time_stamp: TimeStamp
        :param trigger_nr: The trigger_nr of this NrMeasRepUeNotification.  # noqa: E501
        :type trigger_nr: TriggerNr
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'eutra_neigh_cell_meas_info': List[NrMeasRepUeNotificationEutraNeighCellMeasInfo],
            'notification_type': str,
            'nr_neigh_cell_meas_info': List[NrMeasRepUeNotificationNrNeighCellMeasInfo],
            'serv_cell_meas_info': List[NrMeasRepUeNotificationServCellMeasInfo],
            'time_stamp': TimeStamp,
            'trigger_nr': TriggerNr
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'eutra_neigh_cell_meas_info': 'eutraNeighCellMeasInfo',
            'notification_type': 'notificationType',
            'nr_neigh_cell_meas_info': 'nrNeighCellMeasInfo',
            'serv_cell_meas_info': 'servCellMeasInfo',
            'time_stamp': 'timeStamp',
            'trigger_nr': 'triggerNr'
        }
        self._associate_id = associate_id
        self._eutra_neigh_cell_meas_info = eutra_neigh_cell_meas_info
        self._notification_type = notification_type
        self._nr_neigh_cell_meas_info = nr_neigh_cell_meas_info
        self._serv_cell_meas_info = serv_cell_meas_info
        self._time_stamp = time_stamp
        self._trigger_nr = trigger_nr

    @classmethod
    def from_dict(cls, dikt) -> 'NrMeasRepUeNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The NrMeasRepUeNotification of this NrMeasRepUeNotification.  # noqa: E501
        :rtype: NrMeasRepUeNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this NrMeasRepUeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :return: The associate_id of this NrMeasRepUeNotification.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this NrMeasRepUeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :param associate_id: The associate_id of this NrMeasRepUeNotification.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def eutra_neigh_cell_meas_info(self) -> List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]:
        """Gets the eutra_neigh_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if nrNeighCellMeasInfo is included.  # noqa: E501

        :return: The eutra_neigh_cell_meas_info of this NrMeasRepUeNotification.
        :rtype: List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]
        """
        return self._eutra_neigh_cell_meas_info

    @eutra_neigh_cell_meas_info.setter
    def eutra_neigh_cell_meas_info(self, eutra_neigh_cell_meas_info: List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]):
        """Sets the eutra_neigh_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if nrNeighCellMeasInfo is included.  # noqa: E501

        :param eutra_neigh_cell_meas_info: The eutra_neigh_cell_meas_info of this NrMeasRepUeNotification.
        :type eutra_neigh_cell_meas_info: List[NrMeasRepUeNotificationEutraNeighCellMeasInfo]
        """

        self._eutra_neigh_cell_meas_info = eutra_neigh_cell_meas_info

    @property
    def notification_type(self) -> str:
        """Gets the notification_type of this NrMeasRepUeNotification.

        Shall be set to \"NrMeasRepUeNotification\".  # noqa: E501

        :return: The notification_type of this NrMeasRepUeNotification.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type: str):
        """Sets the notification_type of this NrMeasRepUeNotification.

        Shall be set to \"NrMeasRepUeNotification\".  # noqa: E501

        :param notification_type: The notification_type of this NrMeasRepUeNotification.
        :type notification_type: str
        """
        if notification_type is None:
            raise ValueError("Invalid value for `notification_type`, must not be `None`")  # noqa: E501

        self._notification_type = notification_type

    @property
    def nr_neigh_cell_meas_info(self) -> List[NrMeasRepUeNotificationNrNeighCellMeasInfo]:
        """Gets the nr_neigh_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if eutraNeighCellMeasInfo is included.  # noqa: E501

        :return: The nr_neigh_cell_meas_info of this NrMeasRepUeNotification.
        :rtype: List[NrMeasRepUeNotificationNrNeighCellMeasInfo]
        """
        return self._nr_neigh_cell_meas_info

    @nr_neigh_cell_meas_info.setter
    def nr_neigh_cell_meas_info(self, nr_neigh_cell_meas_info: List[NrMeasRepUeNotificationNrNeighCellMeasInfo]):
        """Sets the nr_neigh_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain measurement information of all the neighbouring cells up to N. It shall not be included if eutraNeighCellMeasInfo is included.  # noqa: E501

        :param nr_neigh_cell_meas_info: The nr_neigh_cell_meas_info of this NrMeasRepUeNotification.
        :type nr_neigh_cell_meas_info: List[NrMeasRepUeNotificationNrNeighCellMeasInfo]
        """

        self._nr_neigh_cell_meas_info = nr_neigh_cell_meas_info

    @property
    def serv_cell_meas_info(self) -> List[NrMeasRepUeNotificationServCellMeasInfo]:
        """Gets the serv_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain information of all the serving cells up to N.  # noqa: E501

        :return: The serv_cell_meas_info of this NrMeasRepUeNotification.
        :rtype: List[NrMeasRepUeNotificationServCellMeasInfo]
        """
        return self._serv_cell_meas_info

    @serv_cell_meas_info.setter
    def serv_cell_meas_info(self, serv_cell_meas_info: List[NrMeasRepUeNotificationServCellMeasInfo]):
        """Sets the serv_cell_meas_info of this NrMeasRepUeNotification.

        This parameter can be repeated to contain information of all the serving cells up to N.  # noqa: E501

        :param serv_cell_meas_info: The serv_cell_meas_info of this NrMeasRepUeNotification.
        :type serv_cell_meas_info: List[NrMeasRepUeNotificationServCellMeasInfo]
        """

        self._serv_cell_meas_info = serv_cell_meas_info

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this NrMeasRepUeNotification.


        :return: The time_stamp of this NrMeasRepUeNotification.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this NrMeasRepUeNotification.


        :param time_stamp: The time_stamp of this NrMeasRepUeNotification.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp

    @property
    def trigger_nr(self) -> TriggerNr:
        """Gets the trigger_nr of this NrMeasRepUeNotification.


        :return: The trigger_nr of this NrMeasRepUeNotification.
        :rtype: TriggerNr
        """
        return self._trigger_nr

    @trigger_nr.setter
    def trigger_nr(self, trigger_nr: TriggerNr):
        """Sets the trigger_nr of this NrMeasRepUeNotification.


        :param trigger_nr: The trigger_nr of this NrMeasRepUeNotification.
        :type trigger_nr: TriggerNr
        """
        if trigger_nr is None:
            raise ValueError("Invalid value for `trigger_nr`, must not be `None`")  # noqa: E501

        self._trigger_nr = trigger_nr
