# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server import util


class S1BearerSubscriptionS1BearerSubscriptionCriteria(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, ecgi: List[Ecgi]=None, erab_id: List[int]=None):  # noqa: E501
        """S1BearerSubscriptionS1BearerSubscriptionCriteria - a model defined in Swagger

        :param associate_id: The associate_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param ecgi: The ecgi of this S1BearerSubscriptionS1BearerSubscriptionCriteria.  # noqa: E501
        :type ecgi: List[Ecgi]
        :param erab_id: The erab_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.  # noqa: E501
        :type erab_id: List[int]
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'ecgi': List[Ecgi],
            'erab_id': List[int]
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'ecgi': 'ecgi',
            'erab_id': 'erabId'
        }
        self._associate_id = associate_id
        self._ecgi = ecgi
        self._erab_id = erab_id

    @classmethod
    def from_dict(cls, dikt) -> 'S1BearerSubscriptionS1BearerSubscriptionCriteria':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The S1BearerSubscription_S1BearerSubscriptionCriteria of this S1BearerSubscriptionS1BearerSubscriptionCriteria.  # noqa: E501
        :rtype: S1BearerSubscriptionS1BearerSubscriptionCriteria
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        0 to N identifiers to associate the events for a specific UE or a flow.  # noqa: E501

        :return: The associate_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        0 to N identifiers to associate the events for a specific UE or a flow.  # noqa: E501

        :param associate_id: The associate_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def ecgi(self) -> List[Ecgi]:
        """Gets the ecgi of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :return: The ecgi of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :rtype: List[Ecgi]
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: List[Ecgi]):
        """Sets the ecgi of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :param ecgi: The ecgi of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :type ecgi: List[Ecgi]
        """

        self._ecgi = ecgi

    @property
    def erab_id(self) -> List[int]:
        """Gets the erab_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        The attribute that uniquely identifies a S1 bearer for a specific UE, as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :return: The erab_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :rtype: List[int]
        """
        return self._erab_id

    @erab_id.setter
    def erab_id(self, erab_id: List[int]):
        """Sets the erab_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.

        The attribute that uniquely identifies a S1 bearer for a specific UE, as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :param erab_id: The erab_id of this S1BearerSubscriptionS1BearerSubscriptionCriteria.
        :type erab_id: List[int]
        """

        self._erab_id = erab_id
