# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.cell_change_notification_temp_ue_id import CellChangeNotificationTempUeId  # noqa: F401,E501
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server.models.s1_bearer_info_s1_bearer_info_detailed import S1BearerInfoS1BearerInfoDetailed  # noqa: F401,E501
from swagger_server import util


class S1BearerNotificationS1UeInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, ecgi: List[Ecgi]=None, s1_bearer_info: List[S1BearerInfoS1BearerInfoDetailed]=None, temp_ue_id: CellChangeNotificationTempUeId=None):  # noqa: E501
        """S1BearerNotificationS1UeInfo - a model defined in Swagger

        :param associate_id: The associate_id of this S1BearerNotificationS1UeInfo.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param ecgi: The ecgi of this S1BearerNotificationS1UeInfo.  # noqa: E501
        :type ecgi: List[Ecgi]
        :param s1_bearer_info: The s1_bearer_info of this S1BearerNotificationS1UeInfo.  # noqa: E501
        :type s1_bearer_info: List[S1BearerInfoS1BearerInfoDetailed]
        :param temp_ue_id: The temp_ue_id of this S1BearerNotificationS1UeInfo.  # noqa: E501
        :type temp_ue_id: CellChangeNotificationTempUeId
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'ecgi': List[Ecgi],
            's1_bearer_info': List[S1BearerInfoS1BearerInfoDetailed],
            'temp_ue_id': CellChangeNotificationTempUeId
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'ecgi': 'ecgi',
            's1_bearer_info': 's1BearerInfo',
            'temp_ue_id': 'tempUeId'
        }
        self._associate_id = associate_id
        self._ecgi = ecgi
        self._s1_bearer_info = s1_bearer_info
        self._temp_ue_id = temp_ue_id

    @classmethod
    def from_dict(cls, dikt) -> 'S1BearerNotificationS1UeInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The S1BearerNotification_s1UeInfo of this S1BearerNotificationS1UeInfo.  # noqa: E501
        :rtype: S1BearerNotificationS1UeInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this S1BearerNotificationS1UeInfo.

        0 to N identifiers to associate the information for a specific UE or flow.  # noqa: E501

        :return: The associate_id of this S1BearerNotificationS1UeInfo.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this S1BearerNotificationS1UeInfo.

        0 to N identifiers to associate the information for a specific UE or flow.  # noqa: E501

        :param associate_id: The associate_id of this S1BearerNotificationS1UeInfo.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def ecgi(self) -> List[Ecgi]:
        """Gets the ecgi of this S1BearerNotificationS1UeInfo.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :return: The ecgi of this S1BearerNotificationS1UeInfo.
        :rtype: List[Ecgi]
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: List[Ecgi]):
        """Sets the ecgi of this S1BearerNotificationS1UeInfo.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :param ecgi: The ecgi of this S1BearerNotificationS1UeInfo.
        :type ecgi: List[Ecgi]
        """
        if ecgi is None:
            raise ValueError("Invalid value for `ecgi`, must not be `None`")  # noqa: E501

        self._ecgi = ecgi

    @property
    def s1_bearer_info(self) -> List[S1BearerInfoS1BearerInfoDetailed]:
        """Gets the s1_bearer_info of this S1BearerNotificationS1UeInfo.

        S1 bearer information as defined below.  # noqa: E501

        :return: The s1_bearer_info of this S1BearerNotificationS1UeInfo.
        :rtype: List[S1BearerInfoS1BearerInfoDetailed]
        """
        return self._s1_bearer_info

    @s1_bearer_info.setter
    def s1_bearer_info(self, s1_bearer_info: List[S1BearerInfoS1BearerInfoDetailed]):
        """Sets the s1_bearer_info of this S1BearerNotificationS1UeInfo.

        S1 bearer information as defined below.  # noqa: E501

        :param s1_bearer_info: The s1_bearer_info of this S1BearerNotificationS1UeInfo.
        :type s1_bearer_info: List[S1BearerInfoS1BearerInfoDetailed]
        """
        if s1_bearer_info is None:
            raise ValueError("Invalid value for `s1_bearer_info`, must not be `None`")  # noqa: E501

        self._s1_bearer_info = s1_bearer_info

    @property
    def temp_ue_id(self) -> CellChangeNotificationTempUeId:
        """Gets the temp_ue_id of this S1BearerNotificationS1UeInfo.


        :return: The temp_ue_id of this S1BearerNotificationS1UeInfo.
        :rtype: CellChangeNotificationTempUeId
        """
        return self._temp_ue_id

    @temp_ue_id.setter
    def temp_ue_id(self, temp_ue_id: CellChangeNotificationTempUeId):
        """Sets the temp_ue_id of this S1BearerNotificationS1UeInfo.


        :param temp_ue_id: The temp_ue_id of this S1BearerNotificationS1UeInfo.
        :type temp_ue_id: CellChangeNotificationTempUeId
        """

        self._temp_ue_id = temp_ue_id
