# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.s1_bearer_notification_s1_ue_info import S1BearerNotificationS1UeInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server import util


class S1BearerNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, notification_type: str=None, s1_event: int=None, s1_ue_info: S1BearerNotificationS1UeInfo=None, time_stamp: TimeStamp=None):  # noqa: E501
        """S1BearerNotification - a model defined in Swagger

        :param notification_type: The notification_type of this S1BearerNotification.  # noqa: E501
        :type notification_type: str
        :param s1_event: The s1_event of this S1BearerNotification.  # noqa: E501
        :type s1_event: int
        :param s1_ue_info: The s1_ue_info of this S1BearerNotification.  # noqa: E501
        :type s1_ue_info: S1BearerNotificationS1UeInfo
        :param time_stamp: The time_stamp of this S1BearerNotification.  # noqa: E501
        :type time_stamp: TimeStamp
        """
        self.swagger_types = {
            'notification_type': str,
            's1_event': int,
            's1_ue_info': S1BearerNotificationS1UeInfo,
            'time_stamp': TimeStamp
        }

        self.attribute_map = {
            'notification_type': 'notificationType',
            's1_event': 's1Event',
            's1_ue_info': 's1UeInfo',
            'time_stamp': 'timeStamp'
        }
        self._notification_type = notification_type
        self._s1_event = s1_event
        self._s1_ue_info = s1_ue_info
        self._time_stamp = time_stamp

    @classmethod
    def from_dict(cls, dikt) -> 'S1BearerNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The S1BearerNotification of this S1BearerNotification.  # noqa: E501
        :rtype: S1BearerNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def notification_type(self) -> str:
        """Gets the notification_type of this S1BearerNotification.

        Shall be set to \"S1BearerNotification\".  # noqa: E501

        :return: The notification_type of this S1BearerNotification.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type: str):
        """Sets the notification_type of this S1BearerNotification.

        Shall be set to \"S1BearerNotification\".  # noqa: E501

        :param notification_type: The notification_type of this S1BearerNotification.
        :type notification_type: str
        """
        if notification_type is None:
            raise ValueError("Invalid value for `notification_type`, must not be `None`")  # noqa: E501

        self._notification_type = notification_type

    @property
    def s1_event(self) -> int:
        """Gets the s1_event of this S1BearerNotification.

        The subscribed event that triggered this notification in S1BearerSubscription.  # noqa: E501

        :return: The s1_event of this S1BearerNotification.
        :rtype: int
        """
        return self._s1_event

    @s1_event.setter
    def s1_event(self, s1_event: int):
        """Sets the s1_event of this S1BearerNotification.

        The subscribed event that triggered this notification in S1BearerSubscription.  # noqa: E501

        :param s1_event: The s1_event of this S1BearerNotification.
        :type s1_event: int
        """
        if s1_event is None:
            raise ValueError("Invalid value for `s1_event`, must not be `None`")  # noqa: E501

        self._s1_event = s1_event

    @property
    def s1_ue_info(self) -> S1BearerNotificationS1UeInfo:
        """Gets the s1_ue_info of this S1BearerNotification.


        :return: The s1_ue_info of this S1BearerNotification.
        :rtype: S1BearerNotificationS1UeInfo
        """
        return self._s1_ue_info

    @s1_ue_info.setter
    def s1_ue_info(self, s1_ue_info: S1BearerNotificationS1UeInfo):
        """Sets the s1_ue_info of this S1BearerNotification.


        :param s1_ue_info: The s1_ue_info of this S1BearerNotification.
        :type s1_ue_info: S1BearerNotificationS1UeInfo
        """
        if s1_ue_info is None:
            raise ValueError("Invalid value for `s1_ue_info`, must not be `None`")  # noqa: E501

        self._s1_ue_info = s1_ue_info

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this S1BearerNotification.


        :return: The time_stamp of this S1BearerNotification.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this S1BearerNotification.


        :param time_stamp: The time_stamp of this S1BearerNotification.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp
