/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.ExpectationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaExpectationValidator;

public class ExpectationSerializer
implements Serializer<Expectation> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaExpectationValidator expectationValidator;

    public ExpectationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.expectationValidator = new JsonSchemaExpectationValidator(mockServerLogger);
    }

    @Override
    public String serialize(Expectation expectation) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(new ExpectationDTO(expectation));
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing expectation to JSON with value %s", expectation), e);
            throw new RuntimeException(String.format("Exception while serializing expectation to JSON with value %s", expectation), e);
        }
    }

    @Override
    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[expectations.size()]));
    }

    @Override
    public String serialize(Expectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                ExpectationDTO[] expectationDTOs = new ExpectationDTO[expectations.length];
                for (int i = 0; i < expectations.length; ++i) {
                    expectationDTOs[i] = new ExpectationDTO(expectations[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectationDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }

    @Override
    public Expectation deserialize(String jsonExpectation) {
        if (Strings.isNullOrEmpty(jsonExpectation)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation is required but value was \"" + String.valueOf(jsonExpectation) + "\"");
        }
        String validationErrors = this.expectationValidator.isValid(jsonExpectation);
        if (validationErrors.isEmpty()) {
            Expectation expectation = null;
            try {
                ExpectationDTO expectationDTO = this.objectMapper.readValue(jsonExpectation, ExpectationDTO.class);
                if (expectationDTO != null) {
                    expectation = expectationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {} for Expectation", jsonExpectation);
                throw new RuntimeException("Exception while parsing [" + jsonExpectation + "] for Expectation", e);
            }
            return expectation;
        }
        this.mockServerLogger.error("validation failed:{}expectation:{}", validationErrors, jsonExpectation);
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<Expectation> supportsType() {
        return Expectation.class;
    }

    public Expectation[] deserializeArray(String jsonExpectations) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (Strings.isNullOrEmpty(jsonExpectations)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or expectation array is required but value was \"" + String.valueOf(jsonExpectations) + "\"");
        }
        List<String> jsonExpectationList = this.jsonArraySerializer.returnJSONObjects(jsonExpectations);
        if (jsonExpectationList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or array of expectations is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonExpectationList) {
            try {
                expectations.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            if (validationErrorsList.size() > 1) {
                throw new IllegalArgumentException(("[" + Character.NEW_LINE + Joiner.on("," + Character.NEW_LINE).join(validationErrorsList)).replaceAll(Character.NEW_LINE, Character.NEW_LINE + "  ") + Character.NEW_LINE + "]");
            }
            throw new IllegalArgumentException((String)validationErrorsList.get(0));
        }
        return expectations.toArray(new Expectation[expectations.size()]);
    }
}

