/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.mockserver.echo.http.EchoServerInitializer;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;
import org.mockserver.scheduler.Scheduler;

public class EchoServer {
    static final MockServerLogger mockServerLogger = new MockServerLogger(EchoServer.class);
    static final AttributeKey<MockServerEventLog> LOG_FILTER = AttributeKey.valueOf("SERVER_LOG_FILTER");
    static final AttributeKey<NextResponse> NEXT_RESPONSE = AttributeKey.valueOf("NEXT_RESPONSE");
    static final AttributeKey<OnlyResponse> ONLY_RESPONSE = AttributeKey.valueOf("ONLY_RESPONSE");
    private final Scheduler scheduler = new Scheduler();
    private final MockServerEventLog logFilter = new MockServerEventLog(mockServerLogger, this.scheduler);
    private final NextResponse nextResponse = new NextResponse();
    private final OnlyResponse onlyResponse = new OnlyResponse();
    private final NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private final SettableFuture<Integer> boundPort = SettableFuture.create();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public EchoServer(boolean secure) {
        this(secure, null);
    }

    public EchoServer(final boolean secure, final Error error) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EchoServer.this.bossGroup = new NioEventLoopGroup(1);
                EchoServer.this.workerGroup = new NioEventLoopGroup();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(EchoServer.this.bossGroup, EchoServer.this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 100)).handler(new LoggingHandler(EchoServer.class))).childHandler(new EchoServerInitializer(mockServerLogger, secure, error)).childAttr(LOG_FILTER, EchoServer.this.logFilter).childAttr(NEXT_RESPONSE, EchoServer.this.nextResponse).childAttr(ONLY_RESPONSE, EchoServer.this.onlyResponse).bind(0).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            EchoServer.this.boundPort.set(((InetSocketAddress)future.channel().localAddress()).getPort());
                        } else {
                            EchoServer.this.boundPort.setException(future.cause());
                            EchoServer.this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }, "MockServer EchoServer Thread").start();
        try {
            this.boundPort.get();
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            mockServerLogger.error("Exception while waiting for proxy to complete starting up", e);
        }
    }

    public void stop() {
        this.scheduler.shutdown();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
    }

    public Integer getPort() {
        try {
            return (Integer)this.boundPort.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MockServerEventLog requestLogFilter() {
        return this.logFilter;
    }

    public EchoServer withNextResponse(HttpResponse ... httpResponses) {
        this.nextResponse.httpResponse.addAll(Arrays.asList(httpResponses));
        return this;
    }

    public EchoServer withOnlyResponse(HttpResponse httpResponse) {
        this.onlyResponse.httpResponse = httpResponse;
        return this;
    }

    public class OnlyResponse {
        public HttpResponse httpResponse;
    }

    public class NextResponse {
        public final Queue<HttpResponse> httpResponse = new LinkedList<HttpResponse>();
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

