/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.websocket;

import com.google.common.base.Strings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.mockserver.client.netty.codec.mappers.FullHttpResponseToMockServerResponse;
import org.mockserver.client.netty.websocket.WebSocketClient;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final MockServerLogger mockServerLogger = new MockServerLogger(this.getClass());

    public WebSocketClientHandler(InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient) throws URISyntaxException {
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(new URI("ws://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), WebSocketVersion.V13, null, false, new DefaultHttpHeaders(), Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (!Strings.isNullOrEmpty(contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.mockServerLogger.trace("web socket client disconnected", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            if (httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                this.webSocketClient.registrationFuture().set(httpResponse.headers().get("X-CLIENT-REGISTRATION-ID"));
                this.mockServerLogger.trace("web socket client " + (String)this.webSocketClient.registrationFuture().get() + " connected!", new Object[0]);
                return;
            } else {
                if (!httpResponse.status().equals(HttpResponseStatus.NOT_IMPLEMENTED)) throw new WebSocketException("Unsupported web socket message " + new FullHttpResponseToMockServerResponse().mapMockServerResponseToFullHttpResponse(httpResponse));
                String message = this.readRequestBody(httpResponse);
                this.webSocketClient.registrationFuture().setException(new WebSocketException(message));
                this.mockServerLogger.warn(message);
            }
            return;
        } else {
            if (!(msg instanceof WebSocketFrame)) return;
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                this.webSocketClient.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
                return;
            } else if (frame instanceof PingWebSocketFrame) {
                ctx.write(new PongWebSocketFrame(frame.content().retain()));
                return;
            } else {
                if (!(frame instanceof CloseWebSocketFrame)) return;
                this.mockServerLogger.trace("web socket client received request to close", new Object[0]);
                ch.close();
            }
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            Charset requestCharset = ContentTypeMapper.getCharsetFromContentTypeHeader(fullHttpResponse.headers().get(HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, requestCharset);
        }
        return "";
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.error("web socket client caught exception", cause);
        if (!this.webSocketClient.registrationFuture().isDone()) {
            this.webSocketClient.registrationFuture().setException(cause);
        }
        ctx.close();
    }
}

