/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionCacheData;
import org.apache.velocity.util.introspection.VelMethod;

public class ASTMethod
extends SimpleNode {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private String methodName = "";
    private int paramCount = 0;
    protected Info uberInfo;
    protected boolean strictRef = false;

    public ASTMethod(int n) {
        super(n);
    }

    public ASTMethod(Parser parser, int n) {
        super(parser, n);
    }

    @Override
    public Object jjtAccept(ParserVisitor parserVisitor, Object object) {
        return parserVisitor.visit(this, object);
    }

    @Override
    public Object init(InternalContextAdapter internalContextAdapter, Object object) throws TemplateInitException {
        super.init(internalContextAdapter, object);
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
        this.methodName = this.getFirstToken().image;
        this.paramCount = this.jjtGetNumChildren() - 1;
        this.strictRef = this.rsvc.getBoolean("runtime.references.strict", false);
        this.cleanupParserAndTokens();
        return object;
    }

    @Override
    public Object execute(Object object, InternalContextAdapter internalContextAdapter) throws MethodInvocationException {
        Object[] objectArray = new Object[this.paramCount];
        Class[] classArray = this.paramCount > 0 ? new Class[this.paramCount] : EMPTY_CLASS_ARRAY;
        for (int i = 0; i < this.paramCount; ++i) {
            objectArray[i] = this.jjtGetChild(i + 1).value(internalContextAdapter);
            if (objectArray[i] == null) continue;
            classArray[i] = objectArray[i].getClass();
        }
        VelMethod velMethod = ClassUtils.getMethod(this.methodName, objectArray, classArray, object, internalContextAdapter, this, this.strictRef);
        IntrospectionCacheData introspectionCacheData = internalContextAdapter.icacheGet(this);
        if (velMethod == null) {
            if (introspectionCacheData != null) {
                internalContextAdapter.icachePut(this, null);
            }
            return null;
        }
        if (introspectionCacheData == null) {
            internalContextAdapter.icachePut(this, new IntrospectionCacheData());
        }
        try {
            Object object2 = velMethod.invoke(object, objectArray);
            if (object2 == null && velMethod.getReturnType() == Void.TYPE) {
                return "";
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            return this.handleInvocationException(object, internalContextAdapter, invocationTargetException.getTargetException());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.handleInvocationException(object, internalContextAdapter, illegalArgumentException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string = "ASTMethod.execute() : exception invoking method '" + this.methodName + "' in " + object.getClass();
            this.log.error(string, exception);
            throw new VelocityException(string, exception);
        }
    }

    private Object handleInvocationException(Object object, InternalContextAdapter internalContextAdapter, Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof StopCommand) {
            throw (StopCommand)throwable;
        }
        if (throwable instanceof Exception) {
            try {
                return EventHandlerUtil.methodException(this.rsvc, internalContextAdapter, object.getClass(), this.methodName, (Exception)throwable, this.uberInfo);
            }
            catch (Exception exception) {
                throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + object.getClass() + " threw exception " + exception.toString(), exception, this.methodName, this.getTemplateName(), this.getLine(), this.getColumn());
            }
        }
        throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + object.getClass() + " threw exception " + throwable.toString(), throwable, this.methodName, this.getTemplateName(), this.getLine(), this.getColumn());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static class MethodCacheKey {
        private final String methodName;
        private final Class[] params;

        public MethodCacheKey(String string, Class[] classArray) {
            this.methodName = string != null ? string : "";
            this.params = classArray != null ? classArray : EMPTY_CLASS_ARRAY;
        }

        public boolean equals(Object object) {
            if (object instanceof MethodCacheKey) {
                MethodCacheKey methodCacheKey = (MethodCacheKey)object;
                if (this.params.length == methodCacheKey.params.length && this.methodName.equals(methodCacheKey.methodName)) {
                    for (int i = 0; i < this.params.length; ++i) {
                        if (!(this.params[i] == null ? this.params[i] != methodCacheKey.params[i] : !this.params[i].equals(methodCacheKey.params[i]))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            for (Class clazz : this.params) {
                if (clazz == null) continue;
                n = n * 37 + clazz.hashCode();
            }
            n = n * 37 + this.methodName.hashCode();
            return n;
        }
    }
}

