/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNodeReader;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class JsonLoader {
    private static final Pattern INITIAL_SLASH = Pattern.compile("^/+");
    private static final JsonNodeReader READER = new JsonNodeReader();

    private JsonLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromResource(@Nonnull String resource) throws IOException {
        JsonNode ret;
        Preconditions.checkNotNull(resource);
        Preconditions.checkArgument(resource.startsWith("/"), "resource path does not start with a '/'");
        URL url = JsonLoader.class.getResource(resource);
        if (url == null) {
            ClassLoader classLoader = JsonLoader.firstNonNull(Thread.currentThread().getContextClassLoader(), JsonLoader.class.getClassLoader());
            String s = INITIAL_SLASH.matcher(resource).replaceFirst("");
            url = classLoader.getResource(s);
        }
        if (url == null) {
            throw new IOException("resource " + resource + " not found");
        }
        Closer closer = Closer.create();
        try {
            InputStream in = closer.register(url.openStream());
            ret = READER.fromInputStream(in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    private static ClassLoader firstNonNull(ClassLoader first, ClassLoader second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    public static JsonNode fromURL(URL url) throws IOException {
        return READER.fromInputStream(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromPath(String path) throws IOException {
        JsonNode ret;
        Closer closer = Closer.create();
        try {
            FileInputStream in = closer.register(new FileInputStream(path));
            ret = READER.fromInputStream(in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode fromFile(File file) throws IOException {
        JsonNode ret;
        Closer closer = Closer.create();
        try {
            FileInputStream in = closer.register(new FileInputStream(file));
            ret = READER.fromInputStream(in);
        }
        finally {
            closer.close();
        }
        return ret;
    }

    public static JsonNode fromReader(Reader reader) throws IOException {
        return READER.fromReader(reader);
    }

    public static JsonNode fromString(String json) throws IOException {
        return JsonLoader.fromReader(new StringReader(json));
    }
}

