# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.l2_meas_cell_info import L2MeasCellInfo  # noqa: F401,E501
from swagger_server.models.l2_meas_cell_ue_info import L2MeasCellUEInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server import util


class L2Meas(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, cell_info: List[L2MeasCellInfo]=None, cell_ue_info: List[L2MeasCellUEInfo]=None, time_stamp: TimeStamp=None):  # noqa: E501
        """L2Meas - a model defined in Swagger

        :param cell_info: The cell_info of this L2Meas.  # noqa: E501
        :type cell_info: List[L2MeasCellInfo]
        :param cell_ue_info: The cell_ue_info of this L2Meas.  # noqa: E501
        :type cell_ue_info: List[L2MeasCellUEInfo]
        :param time_stamp: The time_stamp of this L2Meas.  # noqa: E501
        :type time_stamp: TimeStamp
        """
        self.swagger_types = {
            'cell_info': List[L2MeasCellInfo],
            'cell_ue_info': List[L2MeasCellUEInfo],
            'time_stamp': TimeStamp
        }

        self.attribute_map = {
            'cell_info': 'cellInfo',
            'cell_ue_info': 'cellUEInfo',
            'time_stamp': 'timeStamp'
        }
        self._cell_info = cell_info
        self._cell_ue_info = cell_ue_info
        self._time_stamp = time_stamp

    @classmethod
    def from_dict(cls, dikt) -> 'L2Meas':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The L2Meas of this L2Meas.  # noqa: E501
        :rtype: L2Meas
        """
        return util.deserialize_model(dikt, cls)

    @property
    def cell_info(self) -> List[L2MeasCellInfo]:
        """Gets the cell_info of this L2Meas.

        The per cell measurement information as defined below.  # noqa: E501

        :return: The cell_info of this L2Meas.
        :rtype: List[L2MeasCellInfo]
        """
        return self._cell_info

    @cell_info.setter
    def cell_info(self, cell_info: List[L2MeasCellInfo]):
        """Sets the cell_info of this L2Meas.

        The per cell measurement information as defined below.  # noqa: E501

        :param cell_info: The cell_info of this L2Meas.
        :type cell_info: List[L2MeasCellInfo]
        """

        self._cell_info = cell_info

    @property
    def cell_ue_info(self) -> List[L2MeasCellUEInfo]:
        """Gets the cell_ue_info of this L2Meas.

        The per cell per UE layer 2 measurements information as defined below.  # noqa: E501

        :return: The cell_ue_info of this L2Meas.
        :rtype: List[L2MeasCellUEInfo]
        """
        return self._cell_ue_info

    @cell_ue_info.setter
    def cell_ue_info(self, cell_ue_info: List[L2MeasCellUEInfo]):
        """Sets the cell_ue_info of this L2Meas.

        The per cell per UE layer 2 measurements information as defined below.  # noqa: E501

        :param cell_ue_info: The cell_ue_info of this L2Meas.
        :type cell_ue_info: List[L2MeasCellUEInfo]
        """

        self._cell_ue_info = cell_ue_info

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this L2Meas.


        :return: The time_stamp of this L2Meas.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this L2Meas.


        :param time_stamp: The time_stamp of this L2Meas.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp
