# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server.models.rab_rel_notification_erab_release_info import RabRelNotificationErabReleaseInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server import util


class RabRelNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, ecgi: Ecgi=None, erab_release_info: RabRelNotificationErabReleaseInfo=None, notification_type: str=None, time_stamp: TimeStamp=None):  # noqa: E501
        """RabRelNotification - a model defined in Swagger

        :param associate_id: The associate_id of this RabRelNotification.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param ecgi: The ecgi of this RabRelNotification.  # noqa: E501
        :type ecgi: Ecgi
        :param erab_release_info: The erab_release_info of this RabRelNotification.  # noqa: E501
        :type erab_release_info: RabRelNotificationErabReleaseInfo
        :param notification_type: The notification_type of this RabRelNotification.  # noqa: E501
        :type notification_type: str
        :param time_stamp: The time_stamp of this RabRelNotification.  # noqa: E501
        :type time_stamp: TimeStamp
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'ecgi': Ecgi,
            'erab_release_info': RabRelNotificationErabReleaseInfo,
            'notification_type': str,
            'time_stamp': TimeStamp
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'ecgi': 'ecgi',
            'erab_release_info': 'erabReleaseInfo',
            'notification_type': 'notificationType',
            'time_stamp': 'timeStamp'
        }
        self._associate_id = associate_id
        self._ecgi = ecgi
        self._erab_release_info = erab_release_info
        self._notification_type = notification_type
        self._time_stamp = time_stamp

    @classmethod
    def from_dict(cls, dikt) -> 'RabRelNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RabRelNotification of this RabRelNotification.  # noqa: E501
        :rtype: RabRelNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this RabRelNotification.

        0 to N identifiers to bind the event for a specific UE or flow as defined below.  # noqa: E501

        :return: The associate_id of this RabRelNotification.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this RabRelNotification.

        0 to N identifiers to bind the event for a specific UE or flow as defined below.  # noqa: E501

        :param associate_id: The associate_id of this RabRelNotification.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def ecgi(self) -> Ecgi:
        """Gets the ecgi of this RabRelNotification.


        :return: The ecgi of this RabRelNotification.
        :rtype: Ecgi
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: Ecgi):
        """Sets the ecgi of this RabRelNotification.


        :param ecgi: The ecgi of this RabRelNotification.
        :type ecgi: Ecgi
        """
        if ecgi is None:
            raise ValueError("Invalid value for `ecgi`, must not be `None`")  # noqa: E501

        self._ecgi = ecgi

    @property
    def erab_release_info(self) -> RabRelNotificationErabReleaseInfo:
        """Gets the erab_release_info of this RabRelNotification.


        :return: The erab_release_info of this RabRelNotification.
        :rtype: RabRelNotificationErabReleaseInfo
        """
        return self._erab_release_info

    @erab_release_info.setter
    def erab_release_info(self, erab_release_info: RabRelNotificationErabReleaseInfo):
        """Sets the erab_release_info of this RabRelNotification.


        :param erab_release_info: The erab_release_info of this RabRelNotification.
        :type erab_release_info: RabRelNotificationErabReleaseInfo
        """
        if erab_release_info is None:
            raise ValueError("Invalid value for `erab_release_info`, must not be `None`")  # noqa: E501

        self._erab_release_info = erab_release_info

    @property
    def notification_type(self) -> str:
        """Gets the notification_type of this RabRelNotification.

        Shall be set to \"RabRelNotification\".  # noqa: E501

        :return: The notification_type of this RabRelNotification.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type: str):
        """Sets the notification_type of this RabRelNotification.

        Shall be set to \"RabRelNotification\".  # noqa: E501

        :param notification_type: The notification_type of this RabRelNotification.
        :type notification_type: str
        """
        if notification_type is None:
            raise ValueError("Invalid value for `notification_type`, must not be `None`")  # noqa: E501

        self._notification_type = notification_type

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this RabRelNotification.


        :return: The time_stamp of this RabRelNotification.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this RabRelNotification.


        :param time_stamp: The time_stamp of this RabRelNotification.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp
