# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server import util


class L2MeasCellInfo(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, dl_gbr_pdr_cell: int=None, dl_gbr_prb_usage_cell: int=None, dl_nongbr_pdr_cell: int=None, dl_nongbr_prb_usage_cell: int=None, dl_total_prb_usage_cell: int=None, ecgi: Ecgi=None, number_of_active_ue_dl_gbr_cell: int=None, number_of_active_ue_dl_nongbr_cell: int=None, number_of_active_ue_ul_gbr_cell: int=None, number_of_active_ue_ul_nongbr_cell: int=None, received_dedicated_preambles_cell: int=None, received_randomly_selected_preambles_high_range_cell: int=None, received_randomly_selected_preambles_low_range_cell: int=None, ul_gbr_pdr_cell: int=None, ul_gbr_prb_usage_cell: int=None, ul_nongbr_pdr_cell: int=None, ul_nongbr_prb_usage_cell: int=None, ul_total_prb_usage_cell: int=None):  # noqa: E501
        """L2MeasCellInfo - a model defined in Swagger

        :param dl_gbr_pdr_cell: The dl_gbr_pdr_cell of this L2MeasCellInfo.  # noqa: E501
        :type dl_gbr_pdr_cell: int
        :param dl_gbr_prb_usage_cell: The dl_gbr_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type dl_gbr_prb_usage_cell: int
        :param dl_nongbr_pdr_cell: The dl_nongbr_pdr_cell of this L2MeasCellInfo.  # noqa: E501
        :type dl_nongbr_pdr_cell: int
        :param dl_nongbr_prb_usage_cell: The dl_nongbr_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type dl_nongbr_prb_usage_cell: int
        :param dl_total_prb_usage_cell: The dl_total_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type dl_total_prb_usage_cell: int
        :param ecgi: The ecgi of this L2MeasCellInfo.  # noqa: E501
        :type ecgi: Ecgi
        :param number_of_active_ue_dl_gbr_cell: The number_of_active_ue_dl_gbr_cell of this L2MeasCellInfo.  # noqa: E501
        :type number_of_active_ue_dl_gbr_cell: int
        :param number_of_active_ue_dl_nongbr_cell: The number_of_active_ue_dl_nongbr_cell of this L2MeasCellInfo.  # noqa: E501
        :type number_of_active_ue_dl_nongbr_cell: int
        :param number_of_active_ue_ul_gbr_cell: The number_of_active_ue_ul_gbr_cell of this L2MeasCellInfo.  # noqa: E501
        :type number_of_active_ue_ul_gbr_cell: int
        :param number_of_active_ue_ul_nongbr_cell: The number_of_active_ue_ul_nongbr_cell of this L2MeasCellInfo.  # noqa: E501
        :type number_of_active_ue_ul_nongbr_cell: int
        :param received_dedicated_preambles_cell: The received_dedicated_preambles_cell of this L2MeasCellInfo.  # noqa: E501
        :type received_dedicated_preambles_cell: int
        :param received_randomly_selected_preambles_high_range_cell: The received_randomly_selected_preambles_high_range_cell of this L2MeasCellInfo.  # noqa: E501
        :type received_randomly_selected_preambles_high_range_cell: int
        :param received_randomly_selected_preambles_low_range_cell: The received_randomly_selected_preambles_low_range_cell of this L2MeasCellInfo.  # noqa: E501
        :type received_randomly_selected_preambles_low_range_cell: int
        :param ul_gbr_pdr_cell: The ul_gbr_pdr_cell of this L2MeasCellInfo.  # noqa: E501
        :type ul_gbr_pdr_cell: int
        :param ul_gbr_prb_usage_cell: The ul_gbr_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type ul_gbr_prb_usage_cell: int
        :param ul_nongbr_pdr_cell: The ul_nongbr_pdr_cell of this L2MeasCellInfo.  # noqa: E501
        :type ul_nongbr_pdr_cell: int
        :param ul_nongbr_prb_usage_cell: The ul_nongbr_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type ul_nongbr_prb_usage_cell: int
        :param ul_total_prb_usage_cell: The ul_total_prb_usage_cell of this L2MeasCellInfo.  # noqa: E501
        :type ul_total_prb_usage_cell: int
        """
        self.swagger_types = {
            'dl_gbr_pdr_cell': int,
            'dl_gbr_prb_usage_cell': int,
            'dl_nongbr_pdr_cell': int,
            'dl_nongbr_prb_usage_cell': int,
            'dl_total_prb_usage_cell': int,
            'ecgi': Ecgi,
            'number_of_active_ue_dl_gbr_cell': int,
            'number_of_active_ue_dl_nongbr_cell': int,
            'number_of_active_ue_ul_gbr_cell': int,
            'number_of_active_ue_ul_nongbr_cell': int,
            'received_dedicated_preambles_cell': int,
            'received_randomly_selected_preambles_high_range_cell': int,
            'received_randomly_selected_preambles_low_range_cell': int,
            'ul_gbr_pdr_cell': int,
            'ul_gbr_prb_usage_cell': int,
            'ul_nongbr_pdr_cell': int,
            'ul_nongbr_prb_usage_cell': int,
            'ul_total_prb_usage_cell': int
        }

        self.attribute_map = {
            'dl_gbr_pdr_cell': 'dl_gbr_pdr_cell',
            'dl_gbr_prb_usage_cell': 'dl_gbr_prb_usage_cell',
            'dl_nongbr_pdr_cell': 'dl_nongbr_pdr_cell',
            'dl_nongbr_prb_usage_cell': 'dl_nongbr_prb_usage_cell',
            'dl_total_prb_usage_cell': 'dl_total_prb_usage_cell',
            'ecgi': 'ecgi',
            'number_of_active_ue_dl_gbr_cell': 'number_of_active_ue_dl_gbr_cell',
            'number_of_active_ue_dl_nongbr_cell': 'number_of_active_ue_dl_nongbr_cell',
            'number_of_active_ue_ul_gbr_cell': 'number_of_active_ue_ul_gbr_cell',
            'number_of_active_ue_ul_nongbr_cell': 'number_of_active_ue_ul_nongbr_cell',
            'received_dedicated_preambles_cell': 'received_dedicated_preambles_cell',
            'received_randomly_selected_preambles_high_range_cell': 'received_randomly_selected_preambles_high_range_cell',
            'received_randomly_selected_preambles_low_range_cell': 'received_randomly_selected_preambles_low_range_cell',
            'ul_gbr_pdr_cell': 'ul_gbr_pdr_cell',
            'ul_gbr_prb_usage_cell': 'ul_gbr_prb_usage_cell',
            'ul_nongbr_pdr_cell': 'ul_nongbr_pdr_cell',
            'ul_nongbr_prb_usage_cell': 'ul_nongbr_prb_usage_cell',
            'ul_total_prb_usage_cell': 'ul_total_prb_usage_cell'
        }
        self._dl_gbr_pdr_cell = dl_gbr_pdr_cell
        self._dl_gbr_prb_usage_cell = dl_gbr_prb_usage_cell
        self._dl_nongbr_pdr_cell = dl_nongbr_pdr_cell
        self._dl_nongbr_prb_usage_cell = dl_nongbr_prb_usage_cell
        self._dl_total_prb_usage_cell = dl_total_prb_usage_cell
        self._ecgi = ecgi
        self._number_of_active_ue_dl_gbr_cell = number_of_active_ue_dl_gbr_cell
        self._number_of_active_ue_dl_nongbr_cell = number_of_active_ue_dl_nongbr_cell
        self._number_of_active_ue_ul_gbr_cell = number_of_active_ue_ul_gbr_cell
        self._number_of_active_ue_ul_nongbr_cell = number_of_active_ue_ul_nongbr_cell
        self._received_dedicated_preambles_cell = received_dedicated_preambles_cell
        self._received_randomly_selected_preambles_high_range_cell = received_randomly_selected_preambles_high_range_cell
        self._received_randomly_selected_preambles_low_range_cell = received_randomly_selected_preambles_low_range_cell
        self._ul_gbr_pdr_cell = ul_gbr_pdr_cell
        self._ul_gbr_prb_usage_cell = ul_gbr_prb_usage_cell
        self._ul_nongbr_pdr_cell = ul_nongbr_pdr_cell
        self._ul_nongbr_prb_usage_cell = ul_nongbr_prb_usage_cell
        self._ul_total_prb_usage_cell = ul_total_prb_usage_cell

    @classmethod
    def from_dict(cls, dikt) -> 'L2MeasCellInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The L2Meas_cellInfo of this L2MeasCellInfo.  # noqa: E501
        :rtype: L2MeasCellInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def dl_gbr_pdr_cell(self) -> int:
        """Gets the dl_gbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the downlink GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The dl_gbr_pdr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._dl_gbr_pdr_cell

    @dl_gbr_pdr_cell.setter
    def dl_gbr_pdr_cell(self, dl_gbr_pdr_cell: int):
        """Sets the dl_gbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the downlink GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param dl_gbr_pdr_cell: The dl_gbr_pdr_cell of this L2MeasCellInfo.
        :type dl_gbr_pdr_cell: int
        """

        self._dl_gbr_pdr_cell = dl_gbr_pdr_cell

    @property
    def dl_gbr_prb_usage_cell(self) -> int:
        """Gets the dl_gbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates the PRB usage for downlink GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The dl_gbr_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._dl_gbr_prb_usage_cell

    @dl_gbr_prb_usage_cell.setter
    def dl_gbr_prb_usage_cell(self, dl_gbr_prb_usage_cell: int):
        """Sets the dl_gbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates the PRB usage for downlink GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param dl_gbr_prb_usage_cell: The dl_gbr_prb_usage_cell of this L2MeasCellInfo.
        :type dl_gbr_prb_usage_cell: int
        """

        self._dl_gbr_prb_usage_cell = dl_gbr_prb_usage_cell

    @property
    def dl_nongbr_pdr_cell(self) -> int:
        """Gets the dl_nongbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the downlink non-GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The dl_nongbr_pdr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._dl_nongbr_pdr_cell

    @dl_nongbr_pdr_cell.setter
    def dl_nongbr_pdr_cell(self, dl_nongbr_pdr_cell: int):
        """Sets the dl_nongbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the downlink non-GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param dl_nongbr_pdr_cell: The dl_nongbr_pdr_cell of this L2MeasCellInfo.
        :type dl_nongbr_pdr_cell: int
        """

        self._dl_nongbr_pdr_cell = dl_nongbr_pdr_cell

    @property
    def dl_nongbr_prb_usage_cell(self) -> int:
        """Gets the dl_nongbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for downlink non-GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The dl_nongbr_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._dl_nongbr_prb_usage_cell

    @dl_nongbr_prb_usage_cell.setter
    def dl_nongbr_prb_usage_cell(self, dl_nongbr_prb_usage_cell: int):
        """Sets the dl_nongbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for downlink non-GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param dl_nongbr_prb_usage_cell: The dl_nongbr_prb_usage_cell of this L2MeasCellInfo.
        :type dl_nongbr_prb_usage_cell: int
        """

        self._dl_nongbr_prb_usage_cell = dl_nongbr_prb_usage_cell

    @property
    def dl_total_prb_usage_cell(self) -> int:
        """Gets the dl_total_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for total downlink traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The dl_total_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._dl_total_prb_usage_cell

    @dl_total_prb_usage_cell.setter
    def dl_total_prb_usage_cell(self, dl_total_prb_usage_cell: int):
        """Sets the dl_total_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for total downlink traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param dl_total_prb_usage_cell: The dl_total_prb_usage_cell of this L2MeasCellInfo.
        :type dl_total_prb_usage_cell: int
        """

        self._dl_total_prb_usage_cell = dl_total_prb_usage_cell

    @property
    def ecgi(self) -> Ecgi:
        """Gets the ecgi of this L2MeasCellInfo.


        :return: The ecgi of this L2MeasCellInfo.
        :rtype: Ecgi
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: Ecgi):
        """Sets the ecgi of this L2MeasCellInfo.


        :param ecgi: The ecgi of this L2MeasCellInfo.
        :type ecgi: Ecgi
        """

        self._ecgi = ecgi

    @property
    def number_of_active_ue_dl_gbr_cell(self) -> int:
        """Gets the number_of_active_ue_dl_gbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with downlink GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The number_of_active_ue_dl_gbr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._number_of_active_ue_dl_gbr_cell

    @number_of_active_ue_dl_gbr_cell.setter
    def number_of_active_ue_dl_gbr_cell(self, number_of_active_ue_dl_gbr_cell: int):
        """Sets the number_of_active_ue_dl_gbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with downlink GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param number_of_active_ue_dl_gbr_cell: The number_of_active_ue_dl_gbr_cell of this L2MeasCellInfo.
        :type number_of_active_ue_dl_gbr_cell: int
        """

        self._number_of_active_ue_dl_gbr_cell = number_of_active_ue_dl_gbr_cell

    @property
    def number_of_active_ue_dl_nongbr_cell(self) -> int:
        """Gets the number_of_active_ue_dl_nongbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with downlink non-GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The number_of_active_ue_dl_nongbr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._number_of_active_ue_dl_nongbr_cell

    @number_of_active_ue_dl_nongbr_cell.setter
    def number_of_active_ue_dl_nongbr_cell(self, number_of_active_ue_dl_nongbr_cell: int):
        """Sets the number_of_active_ue_dl_nongbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with downlink non-GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param number_of_active_ue_dl_nongbr_cell: The number_of_active_ue_dl_nongbr_cell of this L2MeasCellInfo.
        :type number_of_active_ue_dl_nongbr_cell: int
        """

        self._number_of_active_ue_dl_nongbr_cell = number_of_active_ue_dl_nongbr_cell

    @property
    def number_of_active_ue_ul_gbr_cell(self) -> int:
        """Gets the number_of_active_ue_ul_gbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with uplink GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The number_of_active_ue_ul_gbr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._number_of_active_ue_ul_gbr_cell

    @number_of_active_ue_ul_gbr_cell.setter
    def number_of_active_ue_ul_gbr_cell(self, number_of_active_ue_ul_gbr_cell: int):
        """Sets the number_of_active_ue_ul_gbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with uplink GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param number_of_active_ue_ul_gbr_cell: The number_of_active_ue_ul_gbr_cell of this L2MeasCellInfo.
        :type number_of_active_ue_ul_gbr_cell: int
        """

        self._number_of_active_ue_ul_gbr_cell = number_of_active_ue_ul_gbr_cell

    @property
    def number_of_active_ue_ul_nongbr_cell(self) -> int:
        """Gets the number_of_active_ue_ul_nongbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with uplink non-GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The number_of_active_ue_ul_nongbr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._number_of_active_ue_ul_nongbr_cell

    @number_of_active_ue_ul_nongbr_cell.setter
    def number_of_active_ue_ul_nongbr_cell(self, number_of_active_ue_ul_nongbr_cell: int):
        """Sets the number_of_active_ue_ul_nongbr_cell of this L2MeasCellInfo.

        It indicates the number of active UEs with uplink non-GBR traffic, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param number_of_active_ue_ul_nongbr_cell: The number_of_active_ue_ul_nongbr_cell of this L2MeasCellInfo.
        :type number_of_active_ue_ul_nongbr_cell: int
        """

        self._number_of_active_ue_ul_nongbr_cell = number_of_active_ue_ul_nongbr_cell

    @property
    def received_dedicated_preambles_cell(self) -> int:
        """Gets the received_dedicated_preambles_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received dedicated preamples, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The received_dedicated_preambles_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._received_dedicated_preambles_cell

    @received_dedicated_preambles_cell.setter
    def received_dedicated_preambles_cell(self, received_dedicated_preambles_cell: int):
        """Sets the received_dedicated_preambles_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received dedicated preamples, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param received_dedicated_preambles_cell: The received_dedicated_preambles_cell of this L2MeasCellInfo.
        :type received_dedicated_preambles_cell: int
        """

        self._received_dedicated_preambles_cell = received_dedicated_preambles_cell

    @property
    def received_randomly_selected_preambles_high_range_cell(self) -> int:
        """Gets the received_randomly_selected_preambles_high_range_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received randomly selected preambles in the high range, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The received_randomly_selected_preambles_high_range_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._received_randomly_selected_preambles_high_range_cell

    @received_randomly_selected_preambles_high_range_cell.setter
    def received_randomly_selected_preambles_high_range_cell(self, received_randomly_selected_preambles_high_range_cell: int):
        """Sets the received_randomly_selected_preambles_high_range_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received randomly selected preambles in the high range, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param received_randomly_selected_preambles_high_range_cell: The received_randomly_selected_preambles_high_range_cell of this L2MeasCellInfo.
        :type received_randomly_selected_preambles_high_range_cell: int
        """

        self._received_randomly_selected_preambles_high_range_cell = received_randomly_selected_preambles_high_range_cell

    @property
    def received_randomly_selected_preambles_low_range_cell(self) -> int:
        """Gets the received_randomly_selected_preambles_low_range_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received randomly selected preambles in the low range, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The received_randomly_selected_preambles_low_range_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._received_randomly_selected_preambles_low_range_cell

    @received_randomly_selected_preambles_low_range_cell.setter
    def received_randomly_selected_preambles_low_range_cell(self, received_randomly_selected_preambles_low_range_cell: int):
        """Sets the received_randomly_selected_preambles_low_range_cell of this L2MeasCellInfo.

        It indicates (in percentage) the received randomly selected preambles in the low range, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param received_randomly_selected_preambles_low_range_cell: The received_randomly_selected_preambles_low_range_cell of this L2MeasCellInfo.
        :type received_randomly_selected_preambles_low_range_cell: int
        """

        self._received_randomly_selected_preambles_low_range_cell = received_randomly_selected_preambles_low_range_cell

    @property
    def ul_gbr_pdr_cell(self) -> int:
        """Gets the ul_gbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the uplink GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The ul_gbr_pdr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._ul_gbr_pdr_cell

    @ul_gbr_pdr_cell.setter
    def ul_gbr_pdr_cell(self, ul_gbr_pdr_cell: int):
        """Sets the ul_gbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the uplink GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param ul_gbr_pdr_cell: The ul_gbr_pdr_cell of this L2MeasCellInfo.
        :type ul_gbr_pdr_cell: int
        """

        self._ul_gbr_pdr_cell = ul_gbr_pdr_cell

    @property
    def ul_gbr_prb_usage_cell(self) -> int:
        """Gets the ul_gbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for uplink GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The ul_gbr_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._ul_gbr_prb_usage_cell

    @ul_gbr_prb_usage_cell.setter
    def ul_gbr_prb_usage_cell(self, ul_gbr_prb_usage_cell: int):
        """Sets the ul_gbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for uplink GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param ul_gbr_prb_usage_cell: The ul_gbr_prb_usage_cell of this L2MeasCellInfo.
        :type ul_gbr_prb_usage_cell: int
        """

        self._ul_gbr_prb_usage_cell = ul_gbr_prb_usage_cell

    @property
    def ul_nongbr_pdr_cell(self) -> int:
        """Gets the ul_nongbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the uplink non-GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :return: The ul_nongbr_pdr_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._ul_nongbr_pdr_cell

    @ul_nongbr_pdr_cell.setter
    def ul_nongbr_pdr_cell(self, ul_nongbr_pdr_cell: int):
        """Sets the ul_nongbr_pdr_cell of this L2MeasCellInfo.

        It indicates the packet discard rate in percentage of the uplink non-GBR traffic in a cell, as defined in ETSI TS 136 314 [i.11].  # noqa: E501

        :param ul_nongbr_pdr_cell: The ul_nongbr_pdr_cell of this L2MeasCellInfo.
        :type ul_nongbr_pdr_cell: int
        """

        self._ul_nongbr_pdr_cell = ul_nongbr_pdr_cell

    @property
    def ul_nongbr_prb_usage_cell(self) -> int:
        """Gets the ul_nongbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for uplink non-GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The ul_nongbr_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._ul_nongbr_prb_usage_cell

    @ul_nongbr_prb_usage_cell.setter
    def ul_nongbr_prb_usage_cell(self, ul_nongbr_prb_usage_cell: int):
        """Sets the ul_nongbr_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for uplink non-GBR traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param ul_nongbr_prb_usage_cell: The ul_nongbr_prb_usage_cell of this L2MeasCellInfo.
        :type ul_nongbr_prb_usage_cell: int
        """

        self._ul_nongbr_prb_usage_cell = ul_nongbr_prb_usage_cell

    @property
    def ul_total_prb_usage_cell(self) -> int:
        """Gets the ul_total_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for total uplink traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :return: The ul_total_prb_usage_cell of this L2MeasCellInfo.
        :rtype: int
        """
        return self._ul_total_prb_usage_cell

    @ul_total_prb_usage_cell.setter
    def ul_total_prb_usage_cell(self, ul_total_prb_usage_cell: int):
        """Sets the ul_total_prb_usage_cell of this L2MeasCellInfo.

        It indicates (in percentage) the PRB usage for total uplink traffic, as defined in ETSI TS 136 314 [i.11] and ETSI TS 136 423 [i.12].  # noqa: E501

        :param ul_total_prb_usage_cell: The ul_total_prb_usage_cell of this L2MeasCellInfo.
        :type ul_total_prb_usage_cell: int
        """

        self._ul_total_prb_usage_cell = ul_total_prb_usage_cell
