/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import javax.xml.bind.DatatypeConverter;
import org.mockserver.model.BinaryBody;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;

public class BinaryBodyDTO
extends BodyWithContentTypeDTO {
    private String value;

    public BinaryBodyDTO(BinaryBody binaryBody) {
        this(binaryBody, (Boolean)false);
    }

    public BinaryBodyDTO(BinaryBody binaryBody, Boolean not) {
        super(binaryBody.getType(), not, binaryBody.getContentType());
        if (binaryBody.getValue() != null && binaryBody.getValue().length > 0) {
            this.value = DatatypeConverter.printBase64Binary(binaryBody.getValue());
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public BinaryBody buildObject() {
        return new BinaryBody(DatatypeConverter.parseBase64Binary(this.value), this.getMediaType());
    }
}

