/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.velocity.script.VelocityScriptEngine;

public class VelocityScriptEngineFactory
implements ScriptEngineFactory {
    private static final String VELOCITY_NAME = "Velocity";
    private static final String VELOCITY_VERSION = "2.0";
    private static final String VELOCITY_LANGUAGE = "VTL";
    private static List<String> names = new ArrayList<String>();
    private static List<String> extensions;
    private static List<String> mimeTypes;
    private static Properties parameters;

    @Override
    public String getEngineName() {
        return VELOCITY_NAME;
    }

    @Override
    public String getEngineVersion() {
        return VELOCITY_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return VELOCITY_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return VELOCITY_VERSION;
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("${");
        stringBuilder.append(string);
        stringBuilder.append(".");
        stringBuilder.append(string2);
        stringBuilder.append("(");
        if (stringArray.length != 0) {
            int n;
            for (n = 0; n < stringArray.length - 1; ++n) {
                stringBuilder.append("$").append(stringArray[n]);
                stringBuilder.append(", ");
            }
            stringBuilder.append("$").append(stringArray[n]);
        }
        stringBuilder.append(")}");
        return stringBuilder.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#[[").append(string).append("]]#");
        return stringBuilder.toString();
    }

    @Override
    public String getParameter(String string) {
        return parameters.getProperty(string);
    }

    @Override
    public String getProgram(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new VelocityScriptEngine(this);
    }

    static {
        names.add("velocity");
        names.add(VELOCITY_NAME);
        names = Collections.unmodifiableList(names);
        extensions = new ArrayList<String>();
        extensions.add("vm");
        extensions.add("vtl");
        extensions.add("vhtml");
        extensions = Collections.unmodifiableList(extensions);
        mimeTypes = new ArrayList<String>();
        mimeTypes.add("text/x-velocity");
        mimeTypes = Collections.unmodifiableList(mimeTypes);
        parameters = new Properties();
        parameters.put("javax.script.name", VELOCITY_NAME);
        parameters.put("javax.script.engine_version", VELOCITY_VERSION);
        parameters.put("javax.script.engine", VELOCITY_NAME);
        parameters.put("javax.script.language", VELOCITY_LANGUAGE);
        parameters.put("javax.script.language_version", VELOCITY_VERSION);
        parameters.put("THREADING", "MULTITHREADED");
    }
}

