''[Documentation]   robot --outputdir ./outputs ./PlatformConfiguration.robot
...    Test Suite to validate Platform Configuration operations.

*** Settings ***
Resource    environment/variables.txt
Resource    ../../../GenericKeywords.robot
Library     REST    ${MEPM_SCHEMA}://${MEPM_HOST}:${MEPM_PORT}    ssl_verify=false
Library     BuiltIn
Library     OperatingSystem


*** Test Cases ***
TP_MEC_MEC010p2_MEPM_LCM_001_OK
    [Documentation]    TP_MEC_MEC010p2_MEPM_LCM_001_OK
    ...    Check that MEC API provider has created the configuration information in AppD to the MEPM-V
    ...    ETSI GS MEC 010-2 2.2.1, clause 7.7.6.3.1
    ...    ETSI GS MEC 010-2 2.2.1, Table 6.2.2.21.2-1   #ConfigPlatformForAppRequest

    Request to configure Platform    ${APP_INSTANCE_ID}    ConfigPlatformForAppRequest
    Check HTTP Response Status Code Is    202
    Check Response Header contains    Location


TP_MEC_MEC010p2_MEPM_LCM_001_BR
    [Documentation]    TP_MEC_MEC010p2_MEPM_LCM_001_BR
    ...    Check that MEC API provider sends an error when it receives a malformed request for the configuration information in AppD to the MEPM-V
    ...    ETSI GS MEC 010-2 2.2.1, clause 7.7.6.3.1
    ...    ETSI GS MEC 010-2 2.2.1, Table 6.2.2.21.2-1   #ConfigPlatformForAppRequest

    Request to configure Platform   ${APP_INSTANCE_ID}   ConfigPlatformForAppRequestBadRequest
    Check HTTP Response Status Code Is    400
    


TP_MEC_MEC010p2_MEPM_LCM_001_NF
    [Documentation]    TP_MEC_MEC010p2_MEPM_LCM_001_BR
    ...    "Check that MEC API provider sends an error when it receives a request 
	...    for the configuration information in AppD to the MEPM-V with not valid app instance ID
    ...    ETSI GS MEC 010-2 2.2.1, clause 7.7.6.3.1
    ...    ETSI GS MEC 010-2 2.2.1, Table 6.2.2.21.2-1   #ConfigPlatformForAppRequest

    Request to configure Platform   ${NOT_EXISTING_APP_INSTANCE_ID}   ConfigPlatformForAppRequest
    Check HTTP Response Status Code Is    404



*** Keywords ***
Request to configure Platform
    [Argument]  ${appInstanceId}   ${content}
    Log    Request to configure platform
    Set Headers    {"Accept":"application/json"}
    Set Headers    {"Content-Type":"application/json"}
    Set Headers    {"Authorization":"${TOKEN}"}
    ${file}=    Catenate    SEPARATOR=    jsons/    ${content}    .json
    ${body}=    Get File    ${file}
    Post    ${apiRoot}/${apiName}/${apiVersion}/app_instances/${appInstanceId}/configure_platform_for_app  ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
     