# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server import util


class RabModSubscriptionFilterCriteriaQci(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, app_instance_id: str=None, ecgi: List[Ecgi]=None, erab_id: int=None, qci: int=None):  # noqa: E501
        """RabModSubscriptionFilterCriteriaQci - a model defined in Swagger

        :param app_instance_id: The app_instance_id of this RabModSubscriptionFilterCriteriaQci.  # noqa: E501
        :type app_instance_id: str
        :param ecgi: The ecgi of this RabModSubscriptionFilterCriteriaQci.  # noqa: E501
        :type ecgi: List[Ecgi]
        :param erab_id: The erab_id of this RabModSubscriptionFilterCriteriaQci.  # noqa: E501
        :type erab_id: int
        :param qci: The qci of this RabModSubscriptionFilterCriteriaQci.  # noqa: E501
        :type qci: int
        """
        self.swagger_types = {
            'app_instance_id': str,
            'ecgi': List[Ecgi],
            'erab_id': int,
            'qci': int
        }

        self.attribute_map = {
            'app_instance_id': 'appInstanceId',
            'ecgi': 'ecgi',
            'erab_id': 'erabId',
            'qci': 'qci'
        }
        self._app_instance_id = app_instance_id
        self._ecgi = ecgi
        self._erab_id = erab_id
        self._qci = qci

    @classmethod
    def from_dict(cls, dikt) -> 'RabModSubscriptionFilterCriteriaQci':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RabModSubscription_filterCriteriaQci of this RabModSubscriptionFilterCriteriaQci.  # noqa: E501
        :rtype: RabModSubscriptionFilterCriteriaQci
        """
        return util.deserialize_model(dikt, cls)

    @property
    def app_instance_id(self) -> str:
        """Gets the app_instance_id of this RabModSubscriptionFilterCriteriaQci.

        Unique identifier for the MEC application instance.  # noqa: E501

        :return: The app_instance_id of this RabModSubscriptionFilterCriteriaQci.
        :rtype: str
        """
        return self._app_instance_id

    @app_instance_id.setter
    def app_instance_id(self, app_instance_id: str):
        """Sets the app_instance_id of this RabModSubscriptionFilterCriteriaQci.

        Unique identifier for the MEC application instance.  # noqa: E501

        :param app_instance_id: The app_instance_id of this RabModSubscriptionFilterCriteriaQci.
        :type app_instance_id: str
        """

        self._app_instance_id = app_instance_id

    @property
    def ecgi(self) -> List[Ecgi]:
        """Gets the ecgi of this RabModSubscriptionFilterCriteriaQci.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :return: The ecgi of this RabModSubscriptionFilterCriteriaQci.
        :rtype: List[Ecgi]
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: List[Ecgi]):
        """Sets the ecgi of this RabModSubscriptionFilterCriteriaQci.

        E-UTRAN Cell Global Identifier.  # noqa: E501

        :param ecgi: The ecgi of this RabModSubscriptionFilterCriteriaQci.
        :type ecgi: List[Ecgi]
        """

        self._ecgi = ecgi

    @property
    def erab_id(self) -> int:
        """Gets the erab_id of this RabModSubscriptionFilterCriteriaQci.

        The attribute that uniquely identifies a Radio Access bearer for specific UE as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :return: The erab_id of this RabModSubscriptionFilterCriteriaQci.
        :rtype: int
        """
        return self._erab_id

    @erab_id.setter
    def erab_id(self, erab_id: int):
        """Sets the erab_id of this RabModSubscriptionFilterCriteriaQci.

        The attribute that uniquely identifies a Radio Access bearer for specific UE as defined in ETSI TS 136 413 [i.3].  # noqa: E501

        :param erab_id: The erab_id of this RabModSubscriptionFilterCriteriaQci.
        :type erab_id: int
        """
        if erab_id is None:
            raise ValueError("Invalid value for `erab_id`, must not be `None`")  # noqa: E501

        self._erab_id = erab_id

    @property
    def qci(self) -> int:
        """Gets the qci of this RabModSubscriptionFilterCriteriaQci.

        QoS Class Identifier as defined in ETSI TS 123 401 [i.4].  # noqa: E501

        :return: The qci of this RabModSubscriptionFilterCriteriaQci.
        :rtype: int
        """
        return self._qci

    @qci.setter
    def qci(self, qci: int):
        """Sets the qci of this RabModSubscriptionFilterCriteriaQci.

        QoS Class Identifier as defined in ETSI TS 123 401 [i.4].  # noqa: E501

        :param qci: The qci of this RabModSubscriptionFilterCriteriaQci.
        :type qci: int
        """
        if qci is None:
            raise ValueError("Invalid value for `qci`, must not be `None`")  # noqa: E501

        self._qci = qci
