# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.associate_id import AssociateId  # noqa: F401,E501
from swagger_server.models.ecgi import Ecgi  # noqa: F401,E501
from swagger_server.models.meas_rep_ue_notification_carrier_aggregation_meas_info import MeasRepUeNotificationCarrierAggregationMeasInfo  # noqa: F401,E501
from swagger_server.models.meas_rep_ue_notification_eutran_neighbour_cell_meas_info import MeasRepUeNotificationEutranNeighbourCellMeasInfo  # noqa: F401,E501
from swagger_server.models.meas_rep_ue_notification_new_radio_meas_info import MeasRepUeNotificationNewRadioMeasInfo  # noqa: F401,E501
from swagger_server.models.meas_rep_ue_notification_new_radio_meas_nei_info import MeasRepUeNotificationNewRadioMeasNeiInfo  # noqa: F401,E501
from swagger_server.models.time_stamp import TimeStamp  # noqa: F401,E501
from swagger_server.models.trigger import Trigger  # noqa: F401,E501
from swagger_server import util


class MeasRepUeNotification(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, associate_id: List[AssociateId]=None, carrier_aggregation_meas_info: List[MeasRepUeNotificationCarrierAggregationMeasInfo]=None, ecgi: Ecgi=None, eutran_neighbour_cell_meas_info: List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]=None, height_ue: int=None, new_radio_meas_info: List[MeasRepUeNotificationNewRadioMeasInfo]=None, new_radio_meas_nei_info: List[MeasRepUeNotificationNewRadioMeasNeiInfo]=None, notification_type: str=None, rsrp: int=None, rsrp_ex: int=None, rsrq: int=None, rsrq_ex: int=None, sinr: int=None, time_stamp: TimeStamp=None, trigger: Trigger=None):  # noqa: E501
        """MeasRepUeNotification - a model defined in Swagger

        :param associate_id: The associate_id of this MeasRepUeNotification.  # noqa: E501
        :type associate_id: List[AssociateId]
        :param carrier_aggregation_meas_info: The carrier_aggregation_meas_info of this MeasRepUeNotification.  # noqa: E501
        :type carrier_aggregation_meas_info: List[MeasRepUeNotificationCarrierAggregationMeasInfo]
        :param ecgi: The ecgi of this MeasRepUeNotification.  # noqa: E501
        :type ecgi: Ecgi
        :param eutran_neighbour_cell_meas_info: The eutran_neighbour_cell_meas_info of this MeasRepUeNotification.  # noqa: E501
        :type eutran_neighbour_cell_meas_info: List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]
        :param height_ue: The height_ue of this MeasRepUeNotification.  # noqa: E501
        :type height_ue: int
        :param new_radio_meas_info: The new_radio_meas_info of this MeasRepUeNotification.  # noqa: E501
        :type new_radio_meas_info: List[MeasRepUeNotificationNewRadioMeasInfo]
        :param new_radio_meas_nei_info: The new_radio_meas_nei_info of this MeasRepUeNotification.  # noqa: E501
        :type new_radio_meas_nei_info: List[MeasRepUeNotificationNewRadioMeasNeiInfo]
        :param notification_type: The notification_type of this MeasRepUeNotification.  # noqa: E501
        :type notification_type: str
        :param rsrp: The rsrp of this MeasRepUeNotification.  # noqa: E501
        :type rsrp: int
        :param rsrp_ex: The rsrp_ex of this MeasRepUeNotification.  # noqa: E501
        :type rsrp_ex: int
        :param rsrq: The rsrq of this MeasRepUeNotification.  # noqa: E501
        :type rsrq: int
        :param rsrq_ex: The rsrq_ex of this MeasRepUeNotification.  # noqa: E501
        :type rsrq_ex: int
        :param sinr: The sinr of this MeasRepUeNotification.  # noqa: E501
        :type sinr: int
        :param time_stamp: The time_stamp of this MeasRepUeNotification.  # noqa: E501
        :type time_stamp: TimeStamp
        :param trigger: The trigger of this MeasRepUeNotification.  # noqa: E501
        :type trigger: Trigger
        """
        self.swagger_types = {
            'associate_id': List[AssociateId],
            'carrier_aggregation_meas_info': List[MeasRepUeNotificationCarrierAggregationMeasInfo],
            'ecgi': Ecgi,
            'eutran_neighbour_cell_meas_info': List[MeasRepUeNotificationEutranNeighbourCellMeasInfo],
            'height_ue': int,
            'new_radio_meas_info': List[MeasRepUeNotificationNewRadioMeasInfo],
            'new_radio_meas_nei_info': List[MeasRepUeNotificationNewRadioMeasNeiInfo],
            'notification_type': str,
            'rsrp': int,
            'rsrp_ex': int,
            'rsrq': int,
            'rsrq_ex': int,
            'sinr': int,
            'time_stamp': TimeStamp,
            'trigger': Trigger
        }

        self.attribute_map = {
            'associate_id': 'associateId',
            'carrier_aggregation_meas_info': 'carrierAggregationMeasInfo',
            'ecgi': 'ecgi',
            'eutran_neighbour_cell_meas_info': 'eutranNeighbourCellMeasInfo',
            'height_ue': 'heightUe',
            'new_radio_meas_info': 'newRadioMeasInfo',
            'new_radio_meas_nei_info': 'newRadioMeasNeiInfo',
            'notification_type': 'notificationType',
            'rsrp': 'rsrp',
            'rsrp_ex': 'rsrpEx',
            'rsrq': 'rsrq',
            'rsrq_ex': 'rsrqEx',
            'sinr': 'sinr',
            'time_stamp': 'timeStamp',
            'trigger': 'trigger'
        }
        self._associate_id = associate_id
        self._carrier_aggregation_meas_info = carrier_aggregation_meas_info
        self._ecgi = ecgi
        self._eutran_neighbour_cell_meas_info = eutran_neighbour_cell_meas_info
        self._height_ue = height_ue
        self._new_radio_meas_info = new_radio_meas_info
        self._new_radio_meas_nei_info = new_radio_meas_nei_info
        self._notification_type = notification_type
        self._rsrp = rsrp
        self._rsrp_ex = rsrp_ex
        self._rsrq = rsrq
        self._rsrq_ex = rsrq_ex
        self._sinr = sinr
        self._time_stamp = time_stamp
        self._trigger = trigger

    @classmethod
    def from_dict(cls, dikt) -> 'MeasRepUeNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The MeasRepUeNotification of this MeasRepUeNotification.  # noqa: E501
        :rtype: MeasRepUeNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def associate_id(self) -> List[AssociateId]:
        """Gets the associate_id of this MeasRepUeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :return: The associate_id of this MeasRepUeNotification.
        :rtype: List[AssociateId]
        """
        return self._associate_id

    @associate_id.setter
    def associate_id(self, associate_id: List[AssociateId]):
        """Sets the associate_id of this MeasRepUeNotification.

        0 to N identifiers to associate the event for a specific UE or flow.  # noqa: E501

        :param associate_id: The associate_id of this MeasRepUeNotification.
        :type associate_id: List[AssociateId]
        """

        self._associate_id = associate_id

    @property
    def carrier_aggregation_meas_info(self) -> List[MeasRepUeNotificationCarrierAggregationMeasInfo]:
        """Gets the carrier_aggregation_meas_info of this MeasRepUeNotification.

        This parameter can be repeated to contain information of all the carriers assign for Carrier Aggregation up to M.  # noqa: E501

        :return: The carrier_aggregation_meas_info of this MeasRepUeNotification.
        :rtype: List[MeasRepUeNotificationCarrierAggregationMeasInfo]
        """
        return self._carrier_aggregation_meas_info

    @carrier_aggregation_meas_info.setter
    def carrier_aggregation_meas_info(self, carrier_aggregation_meas_info: List[MeasRepUeNotificationCarrierAggregationMeasInfo]):
        """Sets the carrier_aggregation_meas_info of this MeasRepUeNotification.

        This parameter can be repeated to contain information of all the carriers assign for Carrier Aggregation up to M.  # noqa: E501

        :param carrier_aggregation_meas_info: The carrier_aggregation_meas_info of this MeasRepUeNotification.
        :type carrier_aggregation_meas_info: List[MeasRepUeNotificationCarrierAggregationMeasInfo]
        """

        self._carrier_aggregation_meas_info = carrier_aggregation_meas_info

    @property
    def ecgi(self) -> Ecgi:
        """Gets the ecgi of this MeasRepUeNotification.


        :return: The ecgi of this MeasRepUeNotification.
        :rtype: Ecgi
        """
        return self._ecgi

    @ecgi.setter
    def ecgi(self, ecgi: Ecgi):
        """Sets the ecgi of this MeasRepUeNotification.


        :param ecgi: The ecgi of this MeasRepUeNotification.
        :type ecgi: Ecgi
        """
        if ecgi is None:
            raise ValueError("Invalid value for `ecgi`, must not be `None`")  # noqa: E501

        self._ecgi = ecgi

    @property
    def eutran_neighbour_cell_meas_info(self) -> List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]:
        """Gets the eutran_neighbour_cell_meas_info of this MeasRepUeNotification.

        This parameter can be repeated to contain information of all the neighbouring cells up to N.  # noqa: E501

        :return: The eutran_neighbour_cell_meas_info of this MeasRepUeNotification.
        :rtype: List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]
        """
        return self._eutran_neighbour_cell_meas_info

    @eutran_neighbour_cell_meas_info.setter
    def eutran_neighbour_cell_meas_info(self, eutran_neighbour_cell_meas_info: List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]):
        """Sets the eutran_neighbour_cell_meas_info of this MeasRepUeNotification.

        This parameter can be repeated to contain information of all the neighbouring cells up to N.  # noqa: E501

        :param eutran_neighbour_cell_meas_info: The eutran_neighbour_cell_meas_info of this MeasRepUeNotification.
        :type eutran_neighbour_cell_meas_info: List[MeasRepUeNotificationEutranNeighbourCellMeasInfo]
        """

        self._eutran_neighbour_cell_meas_info = eutran_neighbour_cell_meas_info

    @property
    def height_ue(self) -> int:
        """Gets the height_ue of this MeasRepUeNotification.

        Indicates height of the UE in meters relative to the sea level as defined in ETSI TS 136.331 [i.7].  # noqa: E501

        :return: The height_ue of this MeasRepUeNotification.
        :rtype: int
        """
        return self._height_ue

    @height_ue.setter
    def height_ue(self, height_ue: int):
        """Sets the height_ue of this MeasRepUeNotification.

        Indicates height of the UE in meters relative to the sea level as defined in ETSI TS 136.331 [i.7].  # noqa: E501

        :param height_ue: The height_ue of this MeasRepUeNotification.
        :type height_ue: int
        """

        self._height_ue = height_ue

    @property
    def new_radio_meas_info(self) -> List[MeasRepUeNotificationNewRadioMeasInfo]:
        """Gets the new_radio_meas_info of this MeasRepUeNotification.

        5G New Radio secondary serving cells measurement information.  # noqa: E501

        :return: The new_radio_meas_info of this MeasRepUeNotification.
        :rtype: List[MeasRepUeNotificationNewRadioMeasInfo]
        """
        return self._new_radio_meas_info

    @new_radio_meas_info.setter
    def new_radio_meas_info(self, new_radio_meas_info: List[MeasRepUeNotificationNewRadioMeasInfo]):
        """Sets the new_radio_meas_info of this MeasRepUeNotification.

        5G New Radio secondary serving cells measurement information.  # noqa: E501

        :param new_radio_meas_info: The new_radio_meas_info of this MeasRepUeNotification.
        :type new_radio_meas_info: List[MeasRepUeNotificationNewRadioMeasInfo]
        """

        self._new_radio_meas_info = new_radio_meas_info

    @property
    def new_radio_meas_nei_info(self) -> List[MeasRepUeNotificationNewRadioMeasNeiInfo]:
        """Gets the new_radio_meas_nei_info of this MeasRepUeNotification.

        Measurement quantities concerning the 5G NR neighbours.  # noqa: E501

        :return: The new_radio_meas_nei_info of this MeasRepUeNotification.
        :rtype: List[MeasRepUeNotificationNewRadioMeasNeiInfo]
        """
        return self._new_radio_meas_nei_info

    @new_radio_meas_nei_info.setter
    def new_radio_meas_nei_info(self, new_radio_meas_nei_info: List[MeasRepUeNotificationNewRadioMeasNeiInfo]):
        """Sets the new_radio_meas_nei_info of this MeasRepUeNotification.

        Measurement quantities concerning the 5G NR neighbours.  # noqa: E501

        :param new_radio_meas_nei_info: The new_radio_meas_nei_info of this MeasRepUeNotification.
        :type new_radio_meas_nei_info: List[MeasRepUeNotificationNewRadioMeasNeiInfo]
        """

        self._new_radio_meas_nei_info = new_radio_meas_nei_info

    @property
    def notification_type(self) -> str:
        """Gets the notification_type of this MeasRepUeNotification.

        Shall be set to \"MeasRepUeNotification\".  # noqa: E501

        :return: The notification_type of this MeasRepUeNotification.
        :rtype: str
        """
        return self._notification_type

    @notification_type.setter
    def notification_type(self, notification_type: str):
        """Sets the notification_type of this MeasRepUeNotification.

        Shall be set to \"MeasRepUeNotification\".  # noqa: E501

        :param notification_type: The notification_type of this MeasRepUeNotification.
        :type notification_type: str
        """
        if notification_type is None:
            raise ValueError("Invalid value for `notification_type`, must not be `None`")  # noqa: E501

        self._notification_type = notification_type

    @property
    def rsrp(self) -> int:
        """Gets the rsrp of this MeasRepUeNotification.

        Reference Signal Received Power as defined in ETSI TS 136 214 [i.5].  # noqa: E501

        :return: The rsrp of this MeasRepUeNotification.
        :rtype: int
        """
        return self._rsrp

    @rsrp.setter
    def rsrp(self, rsrp: int):
        """Sets the rsrp of this MeasRepUeNotification.

        Reference Signal Received Power as defined in ETSI TS 136 214 [i.5].  # noqa: E501

        :param rsrp: The rsrp of this MeasRepUeNotification.
        :type rsrp: int
        """
        if rsrp is None:
            raise ValueError("Invalid value for `rsrp`, must not be `None`")  # noqa: E501

        self._rsrp = rsrp

    @property
    def rsrp_ex(self) -> int:
        """Gets the rsrp_ex of this MeasRepUeNotification.

        Extended Reference Signal Received Power, with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :return: The rsrp_ex of this MeasRepUeNotification.
        :rtype: int
        """
        return self._rsrp_ex

    @rsrp_ex.setter
    def rsrp_ex(self, rsrp_ex: int):
        """Sets the rsrp_ex of this MeasRepUeNotification.

        Extended Reference Signal Received Power, with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :param rsrp_ex: The rsrp_ex of this MeasRepUeNotification.
        :type rsrp_ex: int
        """

        self._rsrp_ex = rsrp_ex

    @property
    def rsrq(self) -> int:
        """Gets the rsrq of this MeasRepUeNotification.

        Reference Signal Received Quality as defined in ETSI TS 136 214 [i.5].  # noqa: E501

        :return: The rsrq of this MeasRepUeNotification.
        :rtype: int
        """
        return self._rsrq

    @rsrq.setter
    def rsrq(self, rsrq: int):
        """Sets the rsrq of this MeasRepUeNotification.

        Reference Signal Received Quality as defined in ETSI TS 136 214 [i.5].  # noqa: E501

        :param rsrq: The rsrq of this MeasRepUeNotification.
        :type rsrq: int
        """
        if rsrq is None:
            raise ValueError("Invalid value for `rsrq`, must not be `None`")  # noqa: E501

        self._rsrq = rsrq

    @property
    def rsrq_ex(self) -> int:
        """Gets the rsrq_ex of this MeasRepUeNotification.

        Extended Reference Signal Received Quality, with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :return: The rsrq_ex of this MeasRepUeNotification.
        :rtype: int
        """
        return self._rsrq_ex

    @rsrq_ex.setter
    def rsrq_ex(self, rsrq_ex: int):
        """Sets the rsrq_ex of this MeasRepUeNotification.

        Extended Reference Signal Received Quality, with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :param rsrq_ex: The rsrq_ex of this MeasRepUeNotification.
        :type rsrq_ex: int
        """

        self._rsrq_ex = rsrq_ex

    @property
    def sinr(self) -> int:
        """Gets the sinr of this MeasRepUeNotification.

        Reference Signal \"Signal to Interference plus Noise Ratio\", with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :return: The sinr of this MeasRepUeNotification.
        :rtype: int
        """
        return self._sinr

    @sinr.setter
    def sinr(self, sinr: int):
        """Sets the sinr of this MeasRepUeNotification.

        Reference Signal \"Signal to Interference plus Noise Ratio\", with value mapping defined in ETSI TS 136 133 [i.16].  # noqa: E501

        :param sinr: The sinr of this MeasRepUeNotification.
        :type sinr: int
        """

        self._sinr = sinr

    @property
    def time_stamp(self) -> TimeStamp:
        """Gets the time_stamp of this MeasRepUeNotification.


        :return: The time_stamp of this MeasRepUeNotification.
        :rtype: TimeStamp
        """
        return self._time_stamp

    @time_stamp.setter
    def time_stamp(self, time_stamp: TimeStamp):
        """Sets the time_stamp of this MeasRepUeNotification.


        :param time_stamp: The time_stamp of this MeasRepUeNotification.
        :type time_stamp: TimeStamp
        """

        self._time_stamp = time_stamp

    @property
    def trigger(self) -> Trigger:
        """Gets the trigger of this MeasRepUeNotification.


        :return: The trigger of this MeasRepUeNotification.
        :rtype: Trigger
        """
        return self._trigger

    @trigger.setter
    def trigger(self, trigger: Trigger):
        """Sets the trigger of this MeasRepUeNotification.


        :param trigger: The trigger of this MeasRepUeNotification.
        :type trigger: Trigger
        """
        if trigger is None:
            raise ValueError("Invalid value for `trigger`, must not be `None`")  # noqa: E501

        self._trigger = trigger
